/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.revertion.ChangeReverter;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.revertion.SelectionReverter;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.FileHistoryDialogModel;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.history.integration.ui.models.SelectionDifferenceModel;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;

public class SelectionHistoryDialogModel
extends FileHistoryDialogModel {
    private SelectionCalculator myCalculatorCache;
    private final int myFrom;
    private final int myTo;

    public SelectionHistoryDialogModel(IdeaGateway gw, LocalVcs vcs, VirtualFile f, int from, int to) {
        super(gw, vcs, f);
        this.myFrom = from;
        this.myTo = to;
    }

    @Override
    protected List<Revision> getRevisionsCache() {
        this.myCalculatorCache = null;
        return super.getRevisionsCache();
    }

    @Override
    public FileDifferenceModel getDifferenceModel() {
        return new SelectionDifferenceModel(this.myGateway, this.getCalculator(), this.getLeftRevision(), this.getRightRevision(), this.myFrom, this.myTo, this.isCurrentRevisionSelected());
    }

    private SelectionCalculator getCalculator() {
        if (this.myCalculatorCache == null) {
            this.myCalculatorCache = new SelectionCalculator(this.myGateway, this.getRevisions(), this.myFrom, this.myTo);
        }
        return this.myCalculatorCache;
    }

    @Override
    protected Reverter createRevisionReverter() {
        return new SelectionReverter(this.myVcs, this.myGateway, this.getCalculator(), this.getLeftRevision(), this.getRightEntry(), this.myFrom, this.myTo);
    }

    @Override
    protected ChangeReverter createChangeReverter() {
        return new ChangeReverter(this.myVcs, this.myGateway, this.getRightRevision().getCauseChange()){

            @Override
            public List<String> askUserForProceeding() throws IOException {
                List<String> result = super.askUserForProceeding();
                result.add(LocalHistoryBundle.message("revert.message.will.revert.whole.file", new Object[0]));
                return result;
            }
        };
    }
}

