/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views.table;

import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.integration.ui.views.table.RevisionsTableCellRenderer;
import com.intellij.history.integration.ui.views.table.RevisionsTableModel;
import com.intellij.history.integration.ui.views.table.RevisionsTableUI;
import com.intellij.history.integration.ui.views.table.ShiftedCellRendererWrapper;
import com.intellij.util.ui.Table;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RevisionsTable
extends Table {
    private final ShiftedCellRendererWrapper myShiftedCellRenderer = new ShiftedCellRendererWrapper();

    public RevisionsTable(HistoryDialogModel m, SelectionListener l) {
        super((TableModel)new RevisionsTableModel(m));
        this.setDefaultRenderer(Object.class, new RevisionsTableCellRenderer());
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(0).setMinWidth(150);
        cm.getColumn(0).setMaxWidth(150);
        cm.getColumn(0).setResizable(false);
        cm.getColumn(1).setResizable(false);
        this.setCellSelectionEnabled(true);
        this.addSelectionListener(l);
    }

    private void addSelectionListener(SelectionListener listener) {
        ListSelectionModel sm = this.getSelectionModel();
        ListSelectionModel csm = this.getColumnModel().getSelectionModel();
        MyListSelectionListener l = new MyListSelectionListener(listener);
        sm.addListSelectionListener(l);
        csm.addListSelectionListener(l);
    }

    public void setUI(TableUI ui) {
        this.getTableHeader().setReorderingAllowed(false);
        if (this.myShiftedCellRenderer != null) {
            this.myShiftedCellRenderer.updateUI();
        }
        super.setUI((TableUI)new RevisionsTableUI(ui));
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer cellRenderer = super.getCellRenderer(row, column);
        if (column != this.getColumnCount() - 1 || cellRenderer == null) {
            return cellRenderer;
        }
        this.myShiftedCellRenderer.setDataRenderer(cellRenderer);
        return this.myShiftedCellRenderer;
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        Point bottomRight = new Point(x + width - 1, y + height - 1);
        int lastColumn = this.columnAtPoint(bottomRight);
        if ((lastColumn == -1 || lastColumn == this.getColumnCount() - 1) && this.getRowHeight() != 0) {
            int lastRow = this.rowAtPoint(bottomRight);
            if (lastRow == -1) {
                lastRow = this.getRowCount() - 1;
            }
            int lastHalf = this.getRowHeight(lastRow) / 2 + 1;
            int firstRow = this.rowAtPoint(new Point(bottomRight.x, y));
            if (firstRow == -1) {
                firstRow = this.getRowCount() - 1;
            }
            int firstHalf = this.getRowHeight(firstRow) / 2 + 1;
            y = Math.max(0, y - firstHalf);
            height += lastHalf + firstHalf;
        }
        super.repaint(tm, x, y, width, height);
    }

    protected void processMouseEvent(MouseEvent e) {
        int delta = this.correctEvent(e);
        super.processMouseEvent(e);
        e.translatePoint(0, -delta);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        int delta = this.correctEvent(e);
        super.processMouseMotionEvent(e);
        e.translatePoint(0, -delta);
    }

    private int correctEvent(MouseEvent e) {
        int column = this.columnAtPoint(e.getPoint());
        int delta = 0;
        if (column == this.getColumnCount() - 1) {
            delta = -this.getRowHeight() / 2;
        }
        e.translatePoint(0, delta);
        return delta;
    }

    public void updateData() {
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private int mySelectedRow1 = 0;
        private int mySelectedRow2 = 0;
        private int mySelectedColumn1 = 1;
        private int mySelectedColumn2 = 1;
        private final SelectionListener mySelectionListener;

        public MyListSelectionListener(SelectionListener l) {
            this.mySelectionListener = l;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel sm = RevisionsTable.this.getSelectionModel();
            ListSelectionModel csm = RevisionsTable.this.getColumnModel().getSelectionModel();
            if (!this.isValidSelection()) {
                sm.setSelectionInterval(this.mySelectedRow1, this.mySelectedRow2);
                csm.setSelectionInterval(this.mySelectedColumn1, this.mySelectedColumn2);
            } else {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                this.mySelectedRow1 = sm.getMinSelectionIndex();
                this.mySelectedRow2 = sm.getMaxSelectionIndex();
                this.mySelectedColumn1 = csm.getMinSelectionIndex();
                this.mySelectedColumn2 = csm.getMaxSelectionIndex();
                if (this.mySelectedColumn1 == 2) {
                    this.mySelectionListener.changesSelected(this.mySelectedRow1, this.mySelectedRow2);
                } else {
                    this.mySelectionListener.revisionsSelected(this.mySelectedRow1, this.mySelectedRow2);
                }
            }
        }

        private boolean isValidSelection() {
            if (RevisionsTable.this.getSelectedColumnCount() > 1) {
                return false;
            }
            if (RevisionsTable.this.getSelectedColumn() < 2) {
                return true;
            }
            return !RevisionsTable.this.isRowSelected(RevisionsTable.this.getRowCount() - 1);
        }
    }

    public static interface SelectionListener {
        public void changesSelected(int var1, int var2);

        public void revisionsSelected(int var1, int var2);
    }
}

