/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views.table;

import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.integration.ui.views.table.RevisionsTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class RevisionsTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Color BLUE = new Color(230, 230, 250);
    private static final Color PINK = new Color(255, 235, 205);

    @Override
    public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(t, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            Color c = t.getBackground();
            if (this.isDateOrRevisionColumn(column)) {
                Color specified = this.getSpecifiedColorForRevision(t, row);
                if (specified != null) {
                    c = specified;
                } else if (this.hasTextInRevisionOrActionColumns(t, row)) {
                    c = BLUE;
                }
            }
            if (this.isActionColumnWithName(t, row, column)) {
                c = PINK;
            }
            this.setBackground(c);
        }
        return this;
    }

    private boolean isDateOrRevisionColumn(int column) {
        return column == 0 || column == 1;
    }

    private Color getSpecifiedColorForRevision(JTable t, int row) {
        int color;
        Change c = this.getModel(t).getRevisionAt(row).getCauseChange();
        if (c == null) {
            return null;
        }
        if (c.isSystemLabel() && (color = ((PutSystemLabelChange)c).getColor()) != -1) {
            return new Color(color);
        }
        return null;
    }

    private boolean hasTextInRevisionOrActionColumns(JTable t, int row) {
        return this.hasValueAt(t, row, 1) || this.hasValueAt(t, row, 2);
    }

    private boolean isActionColumnWithName(JTable t, int row, int column) {
        return column == 2 && this.hasValueAt(t, row, 2);
    }

    private boolean hasValueAt(JTable t, int row, int column) {
        return this.getModel(t).getValueAt(row, column) != null;
    }

    private RevisionsTableModel getModel(JTable t) {
        return (RevisionsTableModel)t.getModel();
    }
}

