/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.VolatileImage;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class IdeRepaintManager
extends RepaintManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.HackyRepaintManager");
    private Map<GraphicsConfiguration, VolatileImage> myImagesMap;
    @NonNls
    private static final String FAULTY_FIELD_NAME = "volatileMap";
    WeakReference<JComponent> myLastComponent;

    @Override
    public Image getVolatileOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        Image buffer = super.getVolatileOffscreenBuffer(c, proposedWidth, proposedHeight);
        this.clearLeakyImages();
        return buffer;
    }

    private void clearLeakyImages() {
        if (this.myImagesMap == null) {
            try {
                Field volMapField = RepaintManager.class.getDeclaredField(FAULTY_FIELD_NAME);
                volMapField.setAccessible(true);
                this.myImagesMap = (Map)volMapField.get(this);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myImagesMap.size() > 3) {
            for (VolatileImage image : this.myImagesMap.values()) {
                image.flush();
            }
            this.myImagesMap.clear();
        }
    }

    @Override
    public void addInvalidComponent(JComponent invalidComponent) {
        this.checkThreadViolations(invalidComponent);
        super.addInvalidComponent(invalidComponent);
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        this.checkThreadViolations(c);
        super.addDirtyRegion(c, x, y, w, h);
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && c.isShowing()) {
            StackTraceElement[] stackTrace;
            boolean repaint = false;
            boolean fromSwing = false;
            boolean imageUpdate = false;
            Exception exception = new Exception();
            for (StackTraceElement st : stackTrace = exception.getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
                fromSwing = false;
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (this.myLastComponent != null && c == this.myLastComponent.get()) {
                return;
            }
            this.myLastComponent = new WeakReference<JComponent>(c);
            LOG.warn("Access to realized (ever shown) UI components should be done only from the AWT event dispatch thread, revalidate(), invalidate() & repaint() is ok from any thread", (Throwable)exception);
        }
    }
}

