/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.ProjectBaseDirectory;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.Nullable;

@State(name="RecentDirectoryProjectsManager", roamingType=RoamingType.DISABLED, storages={@Storage(id="other", file="$APP_CONFIG$/other.xml")})
public class RecentDirectoryProjectsManager
extends RecentProjectsManagerBase {
    public RecentDirectoryProjectsManager(ProjectManager projectManager, MessageBus messageBus) {
        super(projectManager, messageBus);
    }

    @Override
    @Nullable
    protected String getProjectPath(Project project) {
        ProjectBaseDirectory baseDir = ProjectBaseDirectory.getInstance(project);
        if (baseDir.getBaseDir() != null) {
            return FileUtil.toSystemDependentName((String)baseDir.getBaseDir().getPath());
        }
        return null;
    }

    @Override
    protected void doOpenProject(String projectPath, Project projectToClose) {
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)projectPath));
        if (projectDir != null) {
            PlatformProjectOpenProcessor.getInstance().doOpenProject(projectDir, projectToClose, false);
        }
    }
}

