/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowserSettings;
import com.intellij.ide.browsers.firefox.FirefoxSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xml.XmlBundle;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WebBrowsersConfiguration", storages={@Storage(id="other", file="$APP_CONFIG$/browsers.xml")})
public class BrowsersConfiguration
implements ApplicationComponent,
PersistentStateComponent<Element> {
    private final Map<BrowserFamily, WebBrowserSettings> myBrowserToSettingsMap = new HashMap();

    public Element getState() {
        Element element = new Element("WebBrowsersConfiguration");
        for (BrowserFamily browserFamily : this.myBrowserToSettingsMap.keySet()) {
            Element browser = new Element("browser");
            browser.setAttribute("family", browserFamily.toString());
            WebBrowserSettings value = this.myBrowserToSettingsMap.get((Object)browserFamily);
            browser.setAttribute("path", value.getPath());
            browser.setAttribute("active", Boolean.toString(value.isActive()));
            BrowserSpecificSettings specificSettings = value.getBrowserSpecificSettings();
            if (specificSettings != null) {
                Element settingsElement = new Element("settings");
                XmlSerializer.serializeInto((Object)specificSettings, (Element)settingsElement, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
                browser.addContent(settingsElement);
            }
            element.addContent(browser);
        }
        return element;
    }

    public void loadState(@NonNls Element element) {
        for (Element child : element.getChildren("browser")) {
            String family = child.getAttributeValue("family");
            String path = child.getAttributeValue("path");
            String active = child.getAttributeValue("active");
            Element settingsElement = child.getChild("settings");
            try {
                BrowserFamily browserFamily = BrowserFamily.valueOf(family);
                BrowserSpecificSettings specificSettings = null;
                if (settingsElement != null) {
                    specificSettings = browserFamily.createBrowserSpecificSettings();
                    XmlSerializer.deserializeInto((Object)specificSettings, (Element)settingsElement);
                }
                this.myBrowserToSettingsMap.put(browserFamily, new WebBrowserSettings(path, Boolean.parseBoolean(active), specificSettings));
            }
            catch (IllegalArgumentException e) {}
        }
    }

    public void updateBrowserValue(BrowserFamily family, String path, boolean isActive) {
        WebBrowserSettings settings = this.getBrowserSettings(family);
        this.myBrowserToSettingsMap.put(family, new WebBrowserSettings(path, isActive, settings.getBrowserSpecificSettings()));
    }

    public void updateBrowserSpecificSettings(BrowserFamily family, BrowserSpecificSettings specificSettings) {
        WebBrowserSettings settings = this.getBrowserSettings(family);
        this.myBrowserToSettingsMap.put(family, new WebBrowserSettings(settings.getPath(), settings.isActive(), specificSettings));
    }

    @NotNull
    public WebBrowserSettings getBrowserSettings(@NotNull BrowserFamily browserFamily) {
        if (browserFamily == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/browsers/BrowsersConfiguration.getBrowserSettings must not be null");
        }
        WebBrowserSettings result = this.myBrowserToSettingsMap.get((Object)browserFamily);
        if (result == null) {
            String path = browserFamily.getExecutionPath();
            result = new WebBrowserSettings(path == null ? "" : path, path != null, null);
            this.myBrowserToSettingsMap.put(browserFamily, result);
        }
        WebBrowserSettings webBrowserSettings = result;
        if (webBrowserSettings == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/browsers/BrowsersConfiguration.getBrowserSettings must not return null");
        }
        return webBrowserSettings;
    }

    public static BrowsersConfiguration getInstance() {
        return (BrowsersConfiguration)ApplicationManager.getApplication().getComponent(BrowsersConfiguration.class);
    }

    @NotNull
    public String getComponentName() {
        if ("BrowsersConfiguration" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/browsers/BrowsersConfiguration.getComponentName must not return null");
        }
        return "BrowsersConfiguration";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public static void launchBrowser(BrowserFamily family, @NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/browsers/BrowsersConfiguration.launchBrowser must not be null");
        }
        BrowsersConfiguration.getInstance()._launchBrowser(family, url);
    }

    private void _launchBrowser(BrowserFamily family, @NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/browsers/BrowsersConfiguration._launchBrowser must not be null");
        }
        WebBrowserSettings settings = this.getBrowserSettings(family);
        String path = settings.getPath();
        if (path != null && path.length() > 0) {
            url = BrowserUtil.escapeUrl((String)url);
            try {
                BrowserSpecificSettings specificSettings = settings.getBrowserSpecificSettings();
                String[] parameters = specificSettings != null ? (String[])ArrayUtil.append((Object[])specificSettings.getAdditionalParameters(), (Object)url) : new String[]{url};
                BrowsersConfiguration.launchBrowser(path, parameters);
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)XmlBundle.message((String)"browser.error", (Object[])new Object[0]));
            }
        } else {
            Messages.showErrorDialog((String)XmlBundle.message((String)"browser.path.not.specified", (Object[])new Object[]{family.getName()}), (String)XmlBundle.message((String)"browser.path.not.specified.title", (Object[])new Object[0]));
        }
    }

    public static void launchBrowser(@NonNls @NotNull String path, String ... parameters) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/browsers/BrowsersConfiguration.launchBrowser must not be null");
        }
        Object[] command = SystemInfo.isMac ? (parameters.length > 1 ? new String[]{path} : new String[]{"open", "-a", path}) : (SystemInfo.isWindows9x ? (path.indexOf(File.separatorChar) != -1 ? new String[]{path} : new String[]{"command.com", "/c", "start", path}) : (SystemInfo.isWindows ? (path.indexOf(File.separatorChar) != -1 ? new String[]{path} : new String[]{"cmd.exe", "/c", "start", path}) : new String[]{path}));
        Runtime.getRuntime().exec((String[])ArrayUtil.mergeArrays((Object[])command, (Object[])parameters, String.class));
    }

    public static enum BrowserFamily {
        EXPLORER(XmlBundle.message((String)"browsers.explorer", (Object[])new Object[0]), "iexplore", null, null, IconLoader.getIcon((String)"/xml/browsers/explorer16.png")),
        SAFARI(XmlBundle.message((String)"browsers.safari", (Object[])new Object[0]), "safari", "safari", "Safari", IconLoader.getIcon((String)"/xml/browsers/safari16.png")),
        OPERA(XmlBundle.message((String)"browsers.opera", (Object[])new Object[0]), "opera", "opera", "Opera", IconLoader.getIcon((String)"/xml/browsers/opera16.png")),
        FIREFOX(XmlBundle.message((String)"browsers.firefox", (Object[])new Object[0]), "firefox", "firefox", "Firefox", IconLoader.getIcon((String)"/xml/browsers/firefox16.png")){

            @Override
            public BrowserSpecificSettings createBrowserSpecificSettings() {
                return new FirefoxSettings();
            }
        }
        ,
        CHROME(XmlBundle.message((String)"browsers.chrome", (Object[])new Object[0]), "chrome", null, null, IconLoader.getIcon((String)"/xml/browsers/chrome16.png"));

        private final String myName;
        private final String myWindowsPath;
        private final String myLinuxPath;
        private final String myMacPath;
        private final Icon myIcon;

        private BrowserFamily(@NonNls String name, @NonNls String windowsPath, String linuxPath, String macPath, Icon icon) {
            this.myName = name;
            this.myWindowsPath = windowsPath;
            this.myLinuxPath = linuxPath;
            this.myMacPath = macPath;
            this.myIcon = icon;
        }

        @Nullable
        public BrowserSpecificSettings createBrowserSpecificSettings() {
            return null;
        }

        @Nullable
        public String getExecutionPath() {
            if (SystemInfo.isWindows) {
                return this.myWindowsPath;
            }
            if (SystemInfo.isLinux) {
                return this.myLinuxPath;
            }
            if (SystemInfo.isMac) {
                return this.myMacPath;
            }
            return null;
        }

        public String getName() {
            return this.myName;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

