/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ProjectTopics;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeStructure;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Collection;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesViewTreeBuilder
extends BaseProjectTreeBuilder {
    private final ProjectViewPsiTreeChangeListener myPsiTreeChangeListener;
    private final FileStatusListener myFileStatusListener;
    private final CopyPasteUtil.DefaultCopyPasteListener myCopyPasteListener;
    private final FavoritesManager.FavoritesListener myFavoritesListener;
    private final String myListName;

    public FavoritesViewTreeBuilder(Project project, JTree tree, DefaultTreeModel treeModel, ProjectAbstractTreeStructureBase treeStructure, String name) {
        super(project, tree, treeModel, treeStructure, null);
        this.myListName = name;
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        this.myPsiTreeChangeListener = new ProjectViewPsiTreeChangeListener(this.myProject){

            @Override
            protected DefaultMutableTreeNode getRootNode() {
                return FavoritesViewTreeBuilder.this.getRootNode();
            }

            @Override
            protected AbstractTreeUpdater getUpdater() {
                return FavoritesViewTreeBuilder.this.getUpdater();
            }

            @Override
            protected boolean isFlattenPackages() {
                return ((FavoritesTreeStructure)FavoritesViewTreeBuilder.this.getTreeStructure()).isFlattenPackages();
            }

            @Override
            protected void childrenChanged(PsiElement parent, boolean stopProcessingForThisModificationCount) {
                if (FavoritesViewTreeBuilder.this.findNodeByElement(parent) == null) {
                    this.getUpdater().addSubtreeToUpdate(this.getRootNode());
                } else {
                    super.childrenChanged(parent, true);
                }
            }
        };
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                FavoritesViewTreeBuilder.this.getUpdater().addSubtreeToUpdate(FavoritesViewTreeBuilder.this.getRootNode());
            }
        });
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myFileStatusListener = new MyFileStatusListener();
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener(this.myFileStatusListener);
        this.myCopyPasteListener = new CopyPasteUtil.DefaultCopyPasteListener(this.getUpdater());
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)this.myCopyPasteListener);
        this.myFavoritesListener = new FavoritesManager.FavoritesListener(){

            @Override
            public void rootsChanged(String listName) {
                if (FavoritesViewTreeBuilder.this.myListName.equals(listName)) {
                    FavoritesViewTreeBuilder.this.updateFromRoot();
                }
            }

            @Override
            public void listAdded(String listName) {
                FavoritesViewTreeBuilder.this.updateFromRoot();
            }

            @Override
            public void listRemoved(String listName) {
                FavoritesViewTreeBuilder.this.updateFromRoot();
            }
        };
        FavoritesManager.getInstance(this.myProject).addFavoritesListener(this.myFavoritesListener);
        this.initRootNode();
    }

    public void updateFromRoot() {
        this.updateFromRootCB();
    }

    public ActionCallback updateFromRootCB() {
        ((FavoritesTreeStructure)this.getTreeStructure()).rootsChanged();
        if (this.isDisposed()) {
            return new ActionCallback.Done();
        }
        this.getUpdater().cancelAllRequests();
        return super.updateFromRootCB();
    }

    @Override
    public ActionCallback select(Object element, VirtualFile file, boolean requestFocus) {
        DefaultMutableTreeNode node = this.findSmartFirstLevelNodeByElement(element);
        if (node != null) {
            return TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)requestFocus, (JTree)this.getTree());
        }
        return super.select(element, file, requestFocus);
    }

    @Nullable
    private static DefaultMutableTreeNode findFirstLevelNodeWithObject(DefaultMutableTreeNode aRoot, Object aObject) {
        for (int i = 0; i < aRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)aRoot.getChildAt(i);
            Object userObject = child.getUserObject();
            if (!(userObject instanceof FavoritesTreeNodeDescriptor) || !Comparing.equal((Object)((FavoritesTreeNodeDescriptor)((Object)userObject)).getElement(), (Object)aObject)) continue;
            return child;
        }
        return null;
    }

    protected Object findNodeByElement(Object element) {
        DefaultMutableTreeNode node = this.findSmartFirstLevelNodeByElement(element);
        if (node != null) {
            return node;
        }
        return super.findNodeByElement(element);
    }

    @Nullable
    DefaultMutableTreeNode findSmartFirstLevelNodeByElement(Object element) {
        Collection favorites = ((AbstractTreeNode)((FavoritesTreeStructure)this.getTreeStructure()).getRootElement()).getChildren();
        for (AbstractTreeNode favorite : favorites) {
            DefaultMutableTreeNode nodeWithObject;
            Object currentValue = favorite.getValue();
            if (currentValue instanceof SmartPsiElementPointer) {
                currentValue = ((SmartPsiElementPointer)favorite.getValue()).getElement();
            }
            if (!Comparing.equal((Object)element, (Object)currentValue) || (nodeWithObject = FavoritesViewTreeBuilder.findFirstLevelNodeWithObject((DefaultMutableTreeNode)this.getTree().getModel().getRoot(), favorite)) == null) continue;
            return nodeWithObject;
        }
        return null;
    }

    public final void dispose() {
        super.dispose();
        FavoritesManager.getInstance(this.myProject).removeFavoritesListener(this.myFavoritesListener);
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        FileStatusManager.getInstance((Project)this.myProject).removeFileStatusListener(this.myFileStatusListener);
        CopyPasteManager.getInstance().removeContentChangedListener((CopyPasteManager.ContentChangedListener)this.myCopyPasteListener);
    }

    @Override
    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        Object[] childElements = this.getTreeStructure().getChildElements((Object)nodeDescriptor);
        return childElements != null && childElements.length > 0;
    }

    @Override
    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getParentDescriptor() == null;
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            FavoritesViewTreeBuilder.this.getUpdater().addSubtreeToUpdate(FavoritesViewTreeBuilder.this.getRootNode());
        }

        public void fileStatusChanged(@NotNull VirtualFile vFile) {
            if (vFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesViewTreeBuilder$MyFileStatusListener.fileStatusChanged must not be null");
            }
            PsiManager psiManager = PsiManager.getInstance((Project)FavoritesViewTreeBuilder.this.myProject);
            Object element = vFile.isDirectory() ? psiManager.findDirectory(vFile) : psiManager.findFile(vFile);
            if (!FavoritesViewTreeBuilder.this.getUpdater().addSubtreeToUpdateByElement(element) && element instanceof PsiFile && ((PsiFile)element).getFileType() == StdFileTypes.JAVA) {
                FavoritesViewTreeBuilder.this.getUpdater().addSubtreeToUpdateByElement((Object)((PsiFile)element).getContainingDirectory());
            }
        }
    }
}

