/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.actions.AddNewFavoritesListAction;
import com.intellij.ide.favoritesTreeView.actions.SendToFavoritesAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendToFavoritesGroup
extends ActionGroup {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        if (e == null) {
            anActionArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/actions/SendToFavoritesGroup.getChildren must not return null");
            return anActionArray;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            anActionArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/actions/SendToFavoritesGroup.getChildren must not return null");
            return anActionArray;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        DataContext dataContext = e.getDataContext();
        FavoritesTreeNodeDescriptor[] roots = (FavoritesTreeNodeDescriptor[])FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        if (roots == null || roots.length == 0 || listName == null) {
            anActionArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/actions/SendToFavoritesGroup.getChildren must not return null");
            return anActionArray;
        }
        String[] allLists = favoritesManager.getAvailableFavoritesLists();
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        for (String list : allLists) {
            if (list.equals(listName)) continue;
            actions.add(new SendToFavoritesAction(list));
        }
        if (actions.size() != 0) {
            actions.add((AnAction)Separator.getInstance());
        }
        actions.add(new SendToNewFavoritesListAction());
        anActionArray = actions.toArray(new AnAction[actions.size()]);
        if (anActionArray != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/actions/SendToFavoritesGroup.getChildren must not return null");
    }

    private static class SendToNewFavoritesListAction
    extends AnAction {
        public SendToNewFavoritesListAction() {
            super(IdeBundle.message((String)"action.send.to.new.favorites.list", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            DataContext dataContext = e.getDataContext();
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            FavoritesTreeNodeDescriptor[] roots = (FavoritesTreeNodeDescriptor[])FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
            String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
            String newName = AddNewFavoritesListAction.doAddNewFavoritesList(project);
            if (newName != null) {
                new SendToFavoritesAction(newName).doSend(FavoritesManager.getInstance(project), roots, listName);
            }
        }
    }
}

