/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ProjectTopics;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.Icons;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectView", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public final class ProjectViewImpl
extends ProjectView
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.impl.ProjectViewImpl");
    private final CopyPasteDelegator myCopyPasteDelegator;
    private boolean isInitialized;
    private boolean myExtensionsLoaded = false;
    private final Project myProject;
    private final Map<String, Boolean> myFlattenPackages = new THashMap();
    private static final boolean ourFlattenPackagesDefaults = false;
    private final Map<String, Boolean> myShowMembers = new THashMap();
    private static final boolean ourShowMembersDefaults = false;
    private final Map<String, Boolean> mySortByType = new THashMap();
    private static final boolean ourSortByTypeDefaults = false;
    private final Map<String, Boolean> myShowModules = new THashMap();
    private static final boolean ourShowModulesDefaults = true;
    private final Map<String, Boolean> myShowLibraryContents = new THashMap();
    private static final boolean ourShowLibraryContentsDefaults = true;
    private final Map<String, Boolean> myHideEmptyPackages = new THashMap();
    private static final boolean ourHideEmptyPackagesDefaults = true;
    private final Map<String, Boolean> myAbbreviatePackageNames = new THashMap();
    private static final boolean ourAbbreviatePackagesDefaults = false;
    private final Map<String, Boolean> myAutoscrollToSource = new THashMap();
    private static final boolean ourAutoscrollToSourceDefaults = false;
    private final Map<String, Boolean> myAutoscrollFromSource = new THashMap();
    private static final boolean ourAutoscrollFromSourceDefaults = false;
    private static final boolean ourShowStructureDefaults = false;
    private String myCurrentViewId;
    private String myCurrentViewSubId;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    private final IdeView myIdeView = new MyIdeView();
    private final MyDeletePSIElementProvider myDeletePSIElementProvider = new MyDeletePSIElementProvider();
    private final ModuleDeleteProvider myDeleteModuleProvider = new ModuleDeleteProvider();
    private SimpleToolWindowPanel myPanel;
    private final Map<String, AbstractProjectViewPane> myId2Pane = new LinkedHashMap<String, AbstractProjectViewPane>();
    private final Collection<AbstractProjectViewPane> myUninitializedPanes = new THashSet();
    static final DataKey<ProjectViewImpl> DATA_KEY = DataKey.create((String)"com.intellij.ide.projectView.impl.ProjectViewImpl");
    @Deprecated
    static final String PROJECT_VIEW_DATA_CONSTANT = DATA_KEY.getName();
    private DefaultActionGroup myActionGroup;
    private final Runnable myTreeChangeListener;
    private String mySavedPaneId = "ProjectPane";
    private String mySavedPaneSubId;
    private static final Icon COMPACT_EMPTY_MIDDLE_PACKAGES_ICON = IconLoader.getIcon((String)"/objectBrowser/compactEmptyPackages.png");
    private static final Icon HIDE_EMPTY_MIDDLE_PACKAGES_ICON = IconLoader.getIcon((String)"/objectBrowser/hideEmptyPackages.png");
    @NonNls
    private static final String ELEMENT_NAVIGATOR = "navigator";
    @NonNls
    private static final String ELEMENT_PANES = "panes";
    @NonNls
    private static final String ELEMENT_PANE = "pane";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_VIEW = "currentView";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_SUBVIEW = "currentSubView";
    @NonNls
    private static final String ELEMENT_FLATTEN_PACKAGES = "flattenPackages";
    @NonNls
    private static final String ELEMENT_SHOW_MEMBERS = "showMembers";
    @NonNls
    private static final String ELEMENT_SHOW_MODULES = "showModules";
    @NonNls
    private static final String ELEMENT_SHOW_LIBRARY_CONTENTS = "showLibraryContents";
    @NonNls
    private static final String ELEMENT_HIDE_EMPTY_PACKAGES = "hideEmptyPackages";
    @NonNls
    private static final String ELEMENT_ABBREVIATE_PACKAGE_NAMES = "abbreviatePackageNames";
    @NonNls
    private static final String ELEMENT_AUTOSCROLL_TO_SOURCE = "autoscrollToSource";
    @NonNls
    private static final String ELEMENT_AUTOSCROLL_FROM_SOURCE = "autoscrollFromSource";
    @NonNls
    private static final String ELEMENT_SORT_BY_TYPE = "sortByType";
    private static final String ATTRIBUTE_ID = "id";
    private ComboBox myCombo;
    private JPanel myViewContentPanel;
    private JPanel myActionGroupPanel;
    private JLabel myLabel;
    private static final Comparator<AbstractProjectViewPane> PANE_WEIGHT_COMPARATOR = new Comparator<AbstractProjectViewPane>(){

        @Override
        public int compare(AbstractProjectViewPane o1, AbstractProjectViewPane o2) {
            return o1.getWeight() - o2.getWeight();
        }
    };
    private final FileEditorManager myFileEditorManager;
    private final MyPanel myDataProvider;
    private final SplitterProportionsData splitterProportions = new SplitterProportionsDataImpl();
    private static final Icon BULLET_ICON = IconLoader.getIcon((String)"/general/bullet.png");
    private final MessageBusConnection myConnection;
    private JPanel myTopPanel;
    private ActionToolbar myToolBar;
    private final Map<String, Element> myUninitializedPaneState = new HashMap<String, Element>();
    private final Map<String, SelectInTarget> mySelectInTargets = new HashMap<String, SelectInTarget>();
    private final FocusListener myLabelFocusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            if (!ProjectViewImpl.this.myCombo.isPopupVisible() && ProjectViewImpl.this.myCombo.isShowing()) {
                ProjectViewImpl.this.myCombo.requestFocusInWindow();
                ProjectViewImpl.this.myCombo.showPopup();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    };

    public ProjectViewImpl(Project project, FileEditorManager fileEditorManager, final ToolWindowManagerEx toolWindowManager) {
        this.myProject = project;
        this.constructUi();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myFileEditorManager = fileEditorManager;
        this.myTreeChangeListener = new Runnable(){

            @Override
            public void run() {
                ProjectViewImpl.this.updateToolWindowTitle();
            }
        };
        this.myConnection = project.getMessageBus().connect();
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                ProjectViewImpl.this.refresh();
            }
        });
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        this.myDataProvider = new MyPanel();
        this.myDataProvider.add((Component)this.myPanel, "Center");
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myPanel){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                PsiElement[] psiElementArray = viewPane == null ? PsiElement.EMPTY_ARRAY : viewPane.getSelectedPSIElements();
                if (psiElementArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/ProjectViewImpl$4.getSelectedElements must not return null");
                }
                return psiElementArray;
            }
        };
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ProjectViewImpl.this.isAutoscrollToSource(ProjectViewImpl.this.myCurrentViewId);
            }

            protected void setAutoScrollMode(boolean state) {
                ProjectViewImpl.this.setAutoscrollToSource(state, ProjectViewImpl.this.myCurrentViewId);
            }
        };
        toolWindowManager.addToolWindowManagerListener(new ToolWindowManagerAdapter(){
            private boolean toolWindowVisible;

            @Override
            public void stateChanged() {
                ToolWindow window = toolWindowManager.getToolWindow(ToolWindowId.PROJECT_VIEW);
                if (window == null) {
                    return;
                }
                if (window.isVisible() && !this.toolWindowVisible) {
                    String id = ProjectViewImpl.this.getCurrentViewId();
                    if (ProjectViewImpl.this.isAutoscrollToSource(id)) {
                        ProjectViewImpl.this.myAutoScrollToSourceHandler.onMouseClicked((Component)ProjectViewImpl.this.getCurrentProjectViewPane().getTree());
                    }
                    if (ProjectViewImpl.this.isAutoscrollFromSource(id)) {
                        ProjectViewImpl.this.myAutoScrollFromSourceHandler.setAutoScrollMode(true);
                    }
                }
                this.toolWindowVisible = window.isVisible();
            }
        });
    }

    private void constructUi() {
        this.myActionGroupPanel = new JPanel(new BorderLayout());
        this.myLabel = new JLabel("View as:");
        if (!SystemInfo.isMac) {
            this.myLabel.setDisplayedMnemonic('a');
        }
        this.myCombo = new ComboBox();
        this.myCombo.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.myLabel.setLabelFor((Component)this.myCombo);
        JPanel combo = new JPanel(new BorderLayout());
        combo.setBorder(new EmptyBorder(4, 4, 4, 4));
        combo.add((Component)this.myLabel, "West");
        combo.add((Component)this.myCombo, "Center");
        this.myTopPanel = new JPanel(new GridBagLayout());
        this.myTopPanel.add((Component)combo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myTopPanel.add((Component)this.myActionGroupPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myViewContentPanel = new JPanel();
        this.myPanel = new SimpleToolWindowPanel(true);
        this.myPanel.setToolbar((JComponent)this.myTopPanel);
        this.myPanel.setContent((JComponent)this.myViewContentPanel);
        this.myPanel.setBorder((Border)new ToolWindow.Border(true, false, false, false));
    }

    @Override
    public synchronized void addProjectPane(AbstractProjectViewPane pane) {
        this.myUninitializedPanes.add(pane);
        SelectInTarget selectInTarget = pane.createSelectInTarget();
        if (selectInTarget != null) {
            this.mySelectInTargets.put(pane.getId(), selectInTarget);
        }
        if (this.isInitialized) {
            this.doAddUninitializedPanes();
        }
    }

    @Override
    public synchronized void removeProjectPane(AbstractProjectViewPane pane) {
        this.myUninitializedPanes.remove(pane);
        String idToRemove = pane.getId();
        if (!this.myId2Pane.containsKey(idToRemove)) {
            return;
        }
        pane.removeTreeChangeListener();
        for (int i = this.myCombo.getItemCount() - 1; i >= 0; --i) {
            Pair ids = (Pair)this.myCombo.getItemAt(i);
            String id = (String)ids.first;
            if (!id.equals(idToRemove)) continue;
            if (i == this.myCombo.getSelectedIndex()) {
                this.myCombo.setSelectedIndex(0);
            }
            this.myCombo.removeItemAt(i);
        }
        this.myId2Pane.remove(idToRemove);
        this.mySelectInTargets.remove(idToRemove);
        this.viewSelectionChanged();
    }

    private synchronized void doAddUninitializedPanes() {
        DefaultComboBoxModel comboBoxModel;
        int size;
        for (AbstractProjectViewPane pane : this.myUninitializedPanes) {
            this.doAddPane(pane);
        }
        if (this.myCombo.getSelectedItem() == null && (size = (comboBoxModel = (DefaultComboBoxModel)this.myCombo.getModel()).getSize()) > 0) {
            Pair ids = (Pair)comboBoxModel.getElementAt(size - 1);
            this.changeView((String)ids.first, (String)ids.second);
        }
        this.myUninitializedPanes.clear();
    }

    private void doAddPane(AbstractProjectViewPane newPane) {
        int index;
        for (index = 0; index < this.myCombo.getItemCount(); ++index) {
            Pair ids = (Pair)this.myCombo.getItemAt(index);
            String id = (String)ids.first;
            AbstractProjectViewPane pane = this.myId2Pane.get(id);
            int comp = PANE_WEIGHT_COMPARATOR.compare(pane, newPane);
            LOG.assertTrue(comp != 0);
            if (comp > 0) break;
        }
        String id = newPane.getId();
        this.myId2Pane.put(id, newPane);
        Object[] subIds = newPane.getSubIds();
        for (Object subId : subIds = (String[])ArrayUtil.mergeArrays((Object[])new String[]{null}, (Object[])subIds, String.class)) {
            this.myCombo.insertItemAt((Object)Pair.create((Object)id, (Object)subId), index++);
        }
        this.myCombo.setMaximumRowCount(this.myCombo.getItemCount());
        if (id.equals(this.mySavedPaneId)) {
            this.changeView(this.mySavedPaneId, this.mySavedPaneSubId);
            this.mySavedPaneId = null;
            this.mySavedPaneSubId = null;
        }
        Disposer.register((Disposable)this, (Disposable)newPane);
    }

    private void showPane(AbstractProjectViewPane newPane) {
        VirtualFile virtualFile;
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        PsiElement selectedPsiElement = null;
        Module selectedModule = null;
        if (currentPane != null) {
            PsiElement[] elements;
            if (currentPane != newPane) {
                currentPane.saveExpandedPaths();
            }
            if ((elements = currentPane.getSelectedPSIElements()).length > 0) {
                selectedPsiElement = elements[0];
            } else {
                Object selected = currentPane.getSelectedElement();
                if (selected instanceof Module) {
                    selectedModule = (Module)selected;
                }
            }
        }
        this.removeLabelFocusListener();
        this.myViewContentPanel.removeAll();
        JComponent component = newPane.createComponent();
        UIUtil.removeScrollBorder((Component)component);
        this.myViewContentPanel.setLayout(new BorderLayout());
        this.myViewContentPanel.add((Component)component, "Center");
        this.myCurrentViewId = newPane.getId();
        String newSubId = this.myCurrentViewSubId = newPane.getSubId();
        this.myViewContentPanel.revalidate();
        this.myViewContentPanel.repaint();
        this.createToolbarActions();
        this.myToolBar.updateActionsImmediately();
        this.myTopPanel.revalidate();
        newPane.setTreeChangeListener(this.myTreeChangeListener);
        this.myAutoScrollToSourceHandler.install((JTree)((Object)newPane.myTree));
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)newPane.getComponentToFocus(), false);
        this.updateToolWindowTitle();
        newPane.restoreExpandedPaths();
        if (selectedPsiElement != null && (virtualFile = PsiUtilBase.getVirtualFile((PsiElement)selectedPsiElement)) != null && ((ProjectViewSelectInTarget)newPane.createSelectInTarget()).isSubIdSelectable(newSubId, new SelectInContext(){

            @NotNull
            public Project getProject() {
                Project project = ProjectViewImpl.this.myProject;
                if (project == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/ProjectViewImpl$7.getProject must not return null");
                }
                return project;
            }

            @NotNull
            public VirtualFile getVirtualFile() {
                VirtualFile virtualFile2 = virtualFile;
                if (virtualFile2 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/ProjectViewImpl$7.getVirtualFile must not return null");
                }
                return virtualFile2;
            }

            public Object getSelectorInFile() {
                return null;
            }

            public FileEditorProvider getFileEditorProvider() {
                return null;
            }
        })) {
            newPane.select(selectedPsiElement, virtualFile, true);
        }
        this.myAutoScrollToSourceHandler.onMouseClicked((Component)((Object)newPane.myTree));
        this.installLabelFocusListener();
    }

    public synchronized void setupImpl(ToolWindow toolWindow) {
        this.setupImpl(toolWindow, true);
    }

    public synchronized void setupImpl(ToolWindow toolWindow, boolean loadPaneExtensions) {
        this.myCombo.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return this;
                }
                Pair ids = (Pair)value;
                String id = (String)ids.first;
                String subId = (String)ids.second;
                AbstractProjectViewPane pane = ProjectViewImpl.this.getProjectViewPaneById(id);
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (pane != null) {
                    if (subId == null) {
                        this.setText(pane.getTitle());
                        this.setIcon(pane.getIcon());
                    } else {
                        String presentable = pane.getPresentableSubIdName(subId);
                        if (index == -1) {
                            this.setText(presentable);
                            this.setIcon(pane.getIcon());
                        } else {
                            this.setText(presentable);
                            this.setIcon(BULLET_ICON);
                        }
                    }
                }
                return this;
            }
        });
        this.myCombo.setMinimumAndPreferredWidth(10);
        this.myActionGroup = new DefaultActionGroup();
        this.myAutoScrollFromSourceHandler.install();
        this.myToolBar = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)this.myActionGroup, true);
        this.myToolBar.setSecondaryActionsTooltip("View Options");
        JComponent toolbarComponent = this.myToolBar.getComponent();
        this.myActionGroupPanel.setLayout(new BorderLayout());
        this.myActionGroupPanel.add((Component)toolbarComponent, "Center");
        if (toolWindow != null) {
            ContentManager contentManager = toolWindow.getContentManager();
            Content content = contentManager.getFactory().createContent(this.getComponent(), ToolWindowId.PROJECT_VIEW, false);
            contentManager.addContent(content);
            content.setPreferredFocusedComponent((Computable)new Computable<JComponent>(){

                public JComponent compute() {
                    AbstractProjectViewPane current = ProjectViewImpl.this.getCurrentProjectViewPane();
                    return current != null ? current.getComponentToFocus() : null;
                }
            });
            toolWindow.setIcon(IconLoader.getIcon((String)ApplicationInfoEx.getInstanceEx().getToolWindowIconUrl()));
        }
        this.myCombo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!ProjectViewImpl.this.viewSelectionChanged()) {
                    ToolWindowManager.getInstance((Project)ProjectViewImpl.this.myProject).activateEditorComponent();
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ToolWindowManager.getInstance((Project)ProjectViewImpl.this.myProject).activateEditorComponent();
            }
        });
        this.installLabelFocusListener();
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectViewImpl.this.splitterProportions.restoreSplitterProportions((Component)ProjectViewImpl.this.myPanel);
            }
        });
        if (loadPaneExtensions) {
            this.ensurePanesLoaded();
        }
        this.isInitialized = true;
        this.doAddUninitializedPanes();
    }

    private void ensurePanesLoaded() {
        if (this.myExtensionsLoaded) {
            return;
        }
        this.myExtensionsLoaded = true;
        for (AbstractProjectViewPane pane : (AbstractProjectViewPane[])Extensions.getExtensions(AbstractProjectViewPane.EP_NAME, (AreaInstance)this.myProject)) {
            if (this.myUninitializedPaneState.containsKey(pane.getId())) {
                try {
                    pane.readExternal(this.myUninitializedPaneState.get(pane.getId()));
                }
                catch (InvalidDataException e) {
                    // empty catch block
                }
                this.myUninitializedPaneState.remove(pane.getId());
            }
            if (pane.isInitiallyVisible() && !this.myId2Pane.containsKey(pane.getId())) {
                this.addProjectPane(pane);
            }
            Disposer.register((Disposable)this, (Disposable)pane);
        }
    }

    private void installLabelFocusListener() {
        this.myLabel.addFocusListener(this.myLabelFocusListener);
    }

    private void removeLabelFocusListener() {
        this.myLabel.removeFocusListener(this.myLabelFocusListener);
    }

    private boolean viewSelectionChanged() {
        Pair ids = (Pair)this.myCombo.getSelectedItem();
        if (ids == null) {
            return false;
        }
        final String id = (String)ids.first;
        String subId = (String)ids.second;
        if (ids.equals((Object)Pair.create((Object)this.myCurrentViewId, (Object)this.myCurrentViewSubId))) {
            return false;
        }
        final AbstractProjectViewPane newPane = this.getProjectViewPaneById(id);
        if (newPane == null) {
            return false;
        }
        newPane.setSubId(subId);
        String[] subIds = newPane.getSubIds();
        if (subId == null && subIds.length != 0) {
            final String firstNonTrivialSubId = subIds[0];
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectViewImpl.this.changeView(id, firstNonTrivialSubId);
                    newPane.setSubId(firstNonTrivialSubId);
                }
            });
        } else {
            this.showPane(newPane);
        }
        return true;
    }

    private void createToolbarActions() {
        this.myActionGroup.removeAll();
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            this.myActionGroup.addAction((AnAction)new PaneOptionAction((Map)this.myFlattenPackages, IdeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), IdeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), Icons.FLATTEN_PACKAGES_ICON, false){

                @Override
                public void setSelected(AnActionEvent event, boolean flag) {
                    AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                    SelectionInfo selectionInfo = SelectionInfo.create(viewPane);
                    super.setSelected(event, flag);
                    selectionInfo.apply(viewPane);
                }
            }).setAsSecondary(true);
        }
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsHideEmptyMiddlePackages()) {
            this.myActionGroup.addAction((AnAction)new HideEmptyMiddlePackagesAction()).setAsSecondary(true);
        }
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            class FlattenPackagesDependableAction
            extends PaneOptionAction {
                final /* synthetic */ ProjectViewImpl this$0;

                FlattenPackagesDependableAction(ProjectViewImpl projectViewImpl, Map<String, Boolean> optionsMap, String text, String description, Icon icon, boolean optionDefaultValue) {
                    this.this$0 = projectViewImpl;
                    super(optionsMap, text, description, icon, optionDefaultValue);
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    Presentation presentation = e.getPresentation();
                    presentation.setVisible(this.this$0.isFlattenPackages(ProjectViewImpl.access$400(this.this$0)));
                }
            }
            this.myActionGroup.addAction((AnAction)new FlattenPackagesDependableAction((Map)this.myAbbreviatePackageNames, IdeBundle.message((String)"action.abbreviate.qualified.package.names", (Object[])new Object[0]), IdeBundle.message((String)"action.abbreviate.qualified.package.names", (Object[])new Object[0]), IconLoader.getIcon((String)"/objectBrowser/abbreviatePackageNames.png"), false){
                {
                    super(ProjectViewImpl.this, x0, x1, x2, x3, x4);
                }

                @Override
                public boolean isSelected(AnActionEvent event) {
                    return super.isSelected(event) && ProjectViewImpl.this.isAbbreviatePackageNames(ProjectViewImpl.this.myCurrentViewId);
                }

                @Override
                public void update(AnActionEvent e) {
                    super.update(e);
                    if ("Scope".equals(ProjectViewImpl.this.myCurrentViewId)) {
                        e.getPresentation().setEnabled(false);
                    }
                }
            }).setAsSecondary(true);
        }
        this.myActionGroup.addAction((AnAction)new PaneOptionAction(this.myShowMembers, IdeBundle.message((String)"action.show.members", (Object[])new Object[0]), IdeBundle.message((String)"action.show.hide.members", (Object[])new Object[0]), IconLoader.getIcon((String)"/objectBrowser/showMembers.png"), false)).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)this.myAutoScrollToSourceHandler.createToggleAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)this.myAutoScrollFromSourceHandler.createToggleAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)new SortByTypeAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)new ScrollFromSourceAction());
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction(new TreeExpander(){

            public void expandAll() {
            }

            public boolean canExpand() {
                return false;
            }

            public void collapseAll() {
                AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
                DnDAwareTree tree = pane.myTree;
                if (tree != null) {
                    TreeUtil.collapseAll((JTree)((Object)tree), (int)-1);
                }
            }

            public boolean canCollapse() {
                return true;
            }
        }, this.getComponent());
        this.myActionGroup.add(collapseAllAction);
        this.getCurrentProjectViewPane().addToolbarActions(this.myActionGroup);
    }

    @Override
    public AbstractProjectViewPane getProjectViewPaneById(String id) {
        AbstractProjectViewPane pane;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.ensurePanesLoaded();
        }
        if ((pane = this.myId2Pane.get(id)) != null) {
            return pane;
        }
        for (AbstractProjectViewPane viewPane : this.myUninitializedPanes) {
            if (!viewPane.getId().equals(id)) continue;
            return viewPane;
        }
        return null;
    }

    @Override
    public AbstractProjectViewPane getCurrentProjectViewPane() {
        return this.getProjectViewPaneById(this.myCurrentViewId);
    }

    @Override
    public void refresh() {
        AbstractProjectViewPane currentProjectViewPane = this.getCurrentProjectViewPane();
        if (currentProjectViewPane != null) {
            currentProjectViewPane.updateFromRoot(false);
        }
    }

    @Override
    public void select(Object element, VirtualFile file, boolean requestFocus) {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane != null) {
            viewPane.select(element, file, requestFocus);
        }
    }

    @Override
    public ActionCallback selectCB(Object element, VirtualFile file, boolean requestFocus) {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane != null && viewPane instanceof AbstractProjectViewPSIPane) {
            return ((AbstractProjectViewPSIPane)viewPane).selectCB(element, file, requestFocus);
        }
        this.select(element, file, requestFocus);
        return new ActionCallback.Done();
    }

    public void dispose() {
        this.myConnection.disconnect();
    }

    private JComponent getComponent() {
        return this.myDataProvider;
    }

    @Override
    public String getCurrentViewId() {
        return this.myCurrentViewId;
    }

    private void updateToolWindowTitle() {
        Object o;
        DefaultMutableTreeNode selectedNode;
        ToolWindow toolWindow;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow2 = toolWindow = toolWindowManager == null ? null : toolWindowManager.getToolWindow(ToolWindowId.PROJECT_VIEW);
        if (toolWindow == null) {
            return;
        }
        String title = null;
        AbstractProjectViewPane pane = this.getCurrentProjectViewPane();
        if (pane != null && (selectedNode = pane.getSelectedNode()) != null && (o = selectedNode.getUserObject()) instanceof ProjectViewNode) {
            title = ((ProjectViewNode)o).getTitle();
        }
        if (title == null) {
            PsiElement element = (PsiElement)this.myDataProvider.getData(LangDataKeys.PSI_ELEMENT.getName());
            if (element != null) {
                PsiFile file = element.getContainingFile();
                title = file != null ? file.getVirtualFile().getPresentableUrl() : (element instanceof PsiDirectory ? PsiDirectoryFactory.getInstance(this.myProject).getQualifiedName((PsiDirectory)element, true) : element.toString());
            } else {
                title = "";
                if (this.myProject != null) {
                    title = this.myProject.getPresentableUrl();
                }
            }
        }
        toolWindow.setTitle(title);
    }

    @Override
    public PsiElement getParentOfCurrentSelection() {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            return null;
        }
        TreePath path = viewPane.getSelectedPath();
        if (path == null) {
            return null;
        }
        if ((path = path.getParentPath()) == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof ProjectViewNode) {
            ProjectViewNode descriptor = (ProjectViewNode)userObject;
            Object element = descriptor.getValue();
            if (element instanceof PsiElement) {
                PsiElement psiElement = (PsiElement)element;
                if (!psiElement.isValid()) {
                    return null;
                }
                return psiElement;
            }
            return null;
        }
        return null;
    }

    @Override
    public void changeView() {
        ArrayList<AbstractProjectViewPane> views = new ArrayList<AbstractProjectViewPane>(this.myId2Pane.values());
        views.remove(this.getCurrentProjectViewPane());
        Collections.sort(views, PANE_WEIGHT_COMPARATOR);
        final JList<Object> list = new JList<Object>(ArrayUtil.toObjectArray(views));
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                AbstractProjectViewPane pane = (AbstractProjectViewPane)value;
                this.setText(pane.getTitle());
                return this;
            }
        });
        if (!views.isEmpty()) {
            list.setSelectedValue(views.get(0), true);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (list.getSelectedIndex() < 0) {
                    return;
                }
                AbstractProjectViewPane pane = (AbstractProjectViewPane)list.getSelectedValue();
                ProjectViewImpl.this.changeView(pane.getId());
            }
        };
        new PopupChooserBuilder(list).setTitle(IdeBundle.message((String)"title.popup.views", (Object[])new Object[0])).setItemChoosenCallback(runnable).createPopup().showInCenterOf((Component)this.getComponent());
    }

    @Override
    public void changeView(@NotNull String viewId) {
        if (viewId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/ProjectViewImpl.changeView must not be null");
        }
        this.changeView(viewId, null);
    }

    @Override
    public void changeView(@NotNull String viewId, @Nullable String subId) {
        if (viewId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/ProjectViewImpl.changeView must not be null");
        }
        AbstractProjectViewPane pane = this.getProjectViewPaneById(viewId);
        LOG.assertTrue(pane != null, (Object)("Project view pane not found: " + viewId + "; subId:" + subId));
        if (!viewId.equals(this.getCurrentViewId()) || subId != null && !subId.equals(pane.getSubId()) || ((DefaultComboBoxModel)this.myCombo.getModel()).getIndexOf(Pair.create((Object)viewId, (Object)pane.getSubId())) == -1) {
            this.myCombo.setSelectedItem((Object)Pair.create((Object)viewId, (Object)subId));
            this.viewSelectionChanged();
        }
    }

    private Module moduleByContentRoot(VirtualFile file) {
        Module module;
        if (ProjectRootsUtil.isModuleContentRoot(file, this.myProject) && (module = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file)) != null && !module.isDisposed()) {
            return module;
        }
        return null;
    }

    private <T> List<T> getSelectedElements(Class<T> klass) {
        Object[] elements;
        ArrayList<Object> result = new ArrayList<Object>();
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            return result;
        }
        for (Object element : elements = viewPane.getSelectedElements()) {
            if (element == null || !klass.isAssignableFrom(element.getClass())) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    public void selectPsiElement(PsiElement element, boolean requestFocus) {
        if (element == null) {
            return;
        }
        VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)element);
        this.select(element, virtualFile, requestFocus);
    }

    private static void readOption(Element node, Map<String, Boolean> options) {
        if (node == null) {
            return;
        }
        List attributes = node.getAttributes();
        for (Object attribute1 : attributes) {
            Attribute attribute = (Attribute)attribute1;
            options.put(attribute.getName(), Boolean.TRUE.toString().equals(attribute.getValue()) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private static void writeOption(Element parentNode, Map<String, Boolean> optionsForPanes, String optionName) {
        Element e = new Element(optionName);
        for (Map.Entry<String, Boolean> entry : optionsForPanes.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            e.setAttribute(key, Boolean.toString(entry.getValue()));
        }
        parentNode.addContent(e);
    }

    public void loadState(Element parentNode) {
        Element panesElement;
        Element navigatorElement = parentNode.getChild(ELEMENT_NAVIGATOR);
        if (navigatorElement != null) {
            this.mySavedPaneId = navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_VIEW);
            this.mySavedPaneSubId = navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_SUBVIEW);
            if (this.mySavedPaneId == null) {
                this.mySavedPaneId = "ProjectPane";
                this.mySavedPaneSubId = null;
            }
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_FLATTEN_PACKAGES), this.myFlattenPackages);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_MEMBERS), this.myShowMembers);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_MODULES), this.myShowModules);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_LIBRARY_CONTENTS), this.myShowLibraryContents);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_HIDE_EMPTY_PACKAGES), this.myHideEmptyPackages);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_ABBREVIATE_PACKAGE_NAMES), this.myAbbreviatePackageNames);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_AUTOSCROLL_TO_SOURCE), this.myAutoscrollToSource);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_AUTOSCROLL_FROM_SOURCE), this.myAutoscrollFromSource);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SORT_BY_TYPE), this.mySortByType);
            try {
                this.splitterProportions.readExternal(navigatorElement);
            }
            catch (InvalidDataException e) {
                // empty catch block
            }
        }
        if ((panesElement = parentNode.getChild(ELEMENT_PANES)) != null) {
            this.readPaneState(panesElement);
        }
    }

    private void readPaneState(Element panesElement) {
        List paneElements = panesElement.getChildren(ELEMENT_PANE);
        for (Element paneElement : paneElements) {
            String paneId = paneElement.getAttributeValue(ATTRIBUTE_ID);
            AbstractProjectViewPane pane = this.myId2Pane.get(paneId);
            if (pane != null) {
                try {
                    pane.readExternal(paneElement);
                }
                catch (InvalidDataException e) {}
                continue;
            }
            this.myUninitializedPaneState.put(paneId, paneElement);
        }
    }

    public Element getState() {
        Element parentNode = new Element("projectView");
        Element navigatorElement = new Element(ELEMENT_NAVIGATOR);
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        if (currentPane != null) {
            navigatorElement.setAttribute(ATTRIBUTE_CURRENT_VIEW, currentPane.getId());
            String subId = currentPane.getSubId();
            if (subId != null) {
                navigatorElement.setAttribute(ATTRIBUTE_CURRENT_SUBVIEW, subId);
            }
        }
        ProjectViewImpl.writeOption(navigatorElement, this.myFlattenPackages, ELEMENT_FLATTEN_PACKAGES);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowMembers, ELEMENT_SHOW_MEMBERS);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowModules, ELEMENT_SHOW_MODULES);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowLibraryContents, ELEMENT_SHOW_LIBRARY_CONTENTS);
        ProjectViewImpl.writeOption(navigatorElement, this.myHideEmptyPackages, ELEMENT_HIDE_EMPTY_PACKAGES);
        ProjectViewImpl.writeOption(navigatorElement, this.myAbbreviatePackageNames, ELEMENT_ABBREVIATE_PACKAGE_NAMES);
        ProjectViewImpl.writeOption(navigatorElement, this.myAutoscrollToSource, ELEMENT_AUTOSCROLL_TO_SOURCE);
        ProjectViewImpl.writeOption(navigatorElement, this.myAutoscrollFromSource, ELEMENT_AUTOSCROLL_FROM_SOURCE);
        ProjectViewImpl.writeOption(navigatorElement, this.mySortByType, ELEMENT_SORT_BY_TYPE);
        this.splitterProportions.saveSplitterProportions((Component)this.myPanel);
        try {
            this.splitterProportions.writeExternal(navigatorElement);
        }
        catch (WriteExternalException e) {
            // empty catch block
        }
        parentNode.addContent(navigatorElement);
        String ATTRIBUTE_SPLITTER_PROPORTION = "splitterProportion";
        navigatorElement.setAttribute("splitterProportion", "0.5");
        Element panesElement = new Element(ELEMENT_PANES);
        this.writePaneState(panesElement);
        parentNode.addContent(panesElement);
        return parentNode;
    }

    private void writePaneState(Element panesElement) {
        for (AbstractProjectViewPane pane : this.myId2Pane.values()) {
            Element paneElement = new Element(ELEMENT_PANE);
            paneElement.setAttribute(ATTRIBUTE_ID, pane.getId());
            try {
                pane.writeExternal(paneElement);
            }
            catch (WriteExternalException e) {
                continue;
            }
            panesElement.addContent(paneElement);
        }
        for (Element element : this.myUninitializedPaneState.values()) {
            panesElement.addContent((Element)element.clone());
        }
    }

    @Override
    public boolean isAutoscrollToSource(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myAutoscrollToSource, paneId, false);
    }

    private void setAutoscrollToSource(boolean autoscrollMode, String paneId) {
        this.myAutoscrollToSource.put(paneId, autoscrollMode ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public boolean isAutoscrollFromSource(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myAutoscrollFromSource, paneId, false);
    }

    private void setAutoscrollFromSource(boolean autoscrollMode, String paneId) {
        this.setPaneOption(this.myAutoscrollFromSource, autoscrollMode, paneId, false);
    }

    @Override
    public boolean isFlattenPackages(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myFlattenPackages, paneId, false);
    }

    public void setFlattenPackages(boolean flattenPackages, String paneId) {
        this.setPaneOption(this.myFlattenPackages, flattenPackages, paneId, true);
    }

    @Override
    public boolean isShowMembers(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myShowMembers, paneId, false);
    }

    @Override
    public boolean isHideEmptyMiddlePackages(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myHideEmptyPackages, paneId, true);
    }

    @Override
    public boolean isAbbreviatePackageNames(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myAbbreviatePackageNames, paneId, false);
    }

    @Override
    public boolean isShowLibraryContents(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myShowLibraryContents, paneId, true);
    }

    @Override
    public void setShowLibraryContents(boolean showLibraryContents, String paneId) {
        this.setPaneOption(this.myShowLibraryContents, showLibraryContents, paneId, true);
    }

    public ActionCallback setShowLibraryContentsCB(boolean showLibraryContents, String paneId) {
        return this.setPaneOption(this.myShowLibraryContents, showLibraryContents, paneId, true);
    }

    @Override
    public boolean isShowModules(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myShowModules, paneId, true);
    }

    @Override
    public void setShowModules(boolean showModules, String paneId) {
        this.setPaneOption(this.myShowModules, showModules, paneId, true);
    }

    @Override
    public void setHideEmptyPackages(boolean hideEmptyPackages, String paneId) {
        this.setPaneOption(this.myHideEmptyPackages, hideEmptyPackages, paneId, true);
    }

    @Override
    public void setAbbreviatePackageNames(boolean abbreviatePackageNames, String paneId) {
        this.setPaneOption(this.myAbbreviatePackageNames, abbreviatePackageNames, paneId, true);
    }

    private ActionCallback setPaneOption(Map<String, Boolean> optionsMap, boolean value, String paneId, boolean updatePane) {
        AbstractProjectViewPane pane;
        optionsMap.put(paneId, value ? Boolean.TRUE : Boolean.FALSE);
        if (updatePane && (pane = this.getProjectViewPaneById(paneId)) != null) {
            return pane.updateFromRoot(false);
        }
        return new ActionCallback.Done();
    }

    private static boolean getPaneOptionValue(Map<String, Boolean> optionsMap, String paneId, boolean defaultValue) {
        Boolean value = optionsMap.get(paneId);
        return value == null ? defaultValue : value;
    }

    @Override
    public boolean isSortByType(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.mySortByType, paneId, false);
    }

    @Override
    public void setSortByType(String paneId, boolean sortByType) {
        this.setPaneOption(this.mySortByType, sortByType, paneId, false);
        AbstractProjectViewPane pane = this.getProjectViewPaneById(paneId);
        pane.installComparator();
    }

    @Override
    public Collection<String> getPaneIds() {
        return this.myId2Pane.keySet();
    }

    @Override
    public Collection<SelectInTarget> getSelectInTargets() {
        this.ensurePanesLoaded();
        return this.mySelectInTargets.values();
    }

    private class ScrollFromSourceAction
    extends AnAction {
        private ScrollFromSourceAction() {
            super("Scroll from Source", "Select the file open in the active editor", IconLoader.getIcon((String)"/general/autoscrollFromSource.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            ProjectViewImpl.this.myAutoScrollFromSourceHandler.scrollFromSource();
        }
    }

    private class SortByTypeAction
    extends ToggleAction {
        private SortByTypeAction() {
            super(IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), IconLoader.getIcon((String)"/objectBrowser/sortByType.png"));
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectViewImpl.this.isSortByType(ProjectViewImpl.this.getCurrentViewId());
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setSortByType(ProjectViewImpl.this.getCurrentViewId(), flag);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setVisible(ProjectViewImpl.this.getCurrentProjectViewPane() != null);
        }
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private final Alarm myAlarm;

        private MyAutoScrollFromSourceHandler() {
            super(ProjectViewImpl.this.myProject, (Disposable)ProjectViewImpl.this);
            this.myAlarm = new Alarm((Disposable)this.myProject);
        }

        public void install() {
            FileEditorManagerAdapter myEditorManagerListener = new FileEditorManagerAdapter(){

                public void selectionChanged(FileEditorManagerEvent event) {
                    final FileEditor newEditor = event.getNewEditor();
                    MyAutoScrollFromSourceHandler.this.myAlarm.cancelAllRequests();
                    MyAutoScrollFromSourceHandler.this.myAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            if (MyAutoScrollFromSourceHandler.this.myProject.isDisposed() || !ProjectViewImpl.this.myViewContentPanel.isShowing()) {
                                return;
                            }
                            if (ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.getCurrentViewId())) {
                                MySelectInContext selectInContext;
                                SelectInTarget target;
                                PsiFile psiFile;
                                VirtualFile file;
                                if (newEditor instanceof TextEditor) {
                                    Editor editor = ((TextEditor)newEditor).getEditor();
                                    MyAutoScrollFromSourceHandler.this.selectElementAtCaretNotLosingFocus(editor);
                                } else if (newEditor != null && (file = FileEditorManagerEx.getInstanceEx(MyAutoScrollFromSourceHandler.this.myProject).getFile(newEditor)) != null && (psiFile = PsiManager.getInstance((Project)MyAutoScrollFromSourceHandler.this.myProject).findFile(file)) != null && (target = (SelectInTarget)ProjectViewImpl.this.mySelectInTargets.get(ProjectViewImpl.this.getCurrentViewId())) != null && target.canSelect((SelectInContext)(selectInContext = new MySelectInContext(psiFile, null){

                                    @Override
                                    public Object getSelectorInFile() {
                                        return psiFile;
                                    }
                                }))) {
                                    target.selectIn((SelectInContext)selectInContext, false);
                                }
                            }
                        }
                    }, 300, ModalityState.NON_MODAL);
                }
            };
            ProjectViewImpl.this.myFileEditorManager.addFileEditorManagerListener((FileEditorManagerListener)myEditorManagerListener, (Disposable)this);
        }

        public void scrollFromSource() {
            PsiFile file;
            FileEditor[] editors;
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            for (FileEditor fileEditor : editors = fileEditorManager.getSelectedEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Editor editor = ((TextEditor)fileEditor).getEditor();
                this.selectElementAtCaret(editor);
                return;
            }
            VirtualFile[] selectedFiles = fileEditorManager.getSelectedFiles();
            if (selectedFiles.length > 0 && (file = PsiManager.getInstance((Project)this.myProject).findFile(selectedFiles[0])) != null) {
                this.scrollFromFile(file, null);
            }
        }

        private void selectElementAtCaretNotLosingFocus(Editor editor) {
            if (IJSwingUtilities.hasFocus(ProjectViewImpl.this.getCurrentProjectViewPane().getComponentToFocus())) {
                return;
            }
            this.selectElementAtCaret(editor);
        }

        private void selectElementAtCaret(Editor editor) {
            PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
            if (file == null) {
                return;
            }
            this.scrollFromFile(file, editor);
        }

        private void scrollFromFile(PsiFile file, @Nullable Editor editor) {
            MySelectInContext selectInContext = new MySelectInContext(file, editor);
            SelectInTarget target = (SelectInTarget)ProjectViewImpl.this.mySelectInTargets.get(ProjectViewImpl.this.getCurrentViewId());
            if (target != null && target.canSelect((SelectInContext)selectInContext)) {
                target.selectIn((SelectInContext)selectInContext, false);
            }
        }

        public void dispose() {
        }

        protected boolean isAutoScrollMode() {
            return ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.myCurrentViewId);
        }

        protected void setAutoScrollMode(boolean state) {
            Editor editor;
            ProjectViewImpl.this.setAutoscrollFromSource(state, ProjectViewImpl.this.myCurrentViewId);
            if (state && (editor = ProjectViewImpl.this.myFileEditorManager.getSelectedTextEditor()) != null) {
                this.selectElementAtCaretNotLosingFocus(editor);
            }
        }

        private class MySelectInContext
        implements SelectInContext {
            private final PsiFile myPsiFile;
            @Nullable
            private final Editor myEditor;

            private MySelectInContext(@Nullable PsiFile psiFile, Editor editor) {
                this.myPsiFile = psiFile;
                this.myEditor = editor;
            }

            @NotNull
            public Project getProject() {
                Project project = MyAutoScrollFromSourceHandler.this.myProject;
                if (project == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/ProjectViewImpl$MyAutoScrollFromSourceHandler$MySelectInContext.getProject must not return null");
                }
                return project;
            }

            private PsiFile getPsiFile() {
                return this.myPsiFile;
            }

            public FileEditorProvider getFileEditorProvider() {
                if (this.myPsiFile == null) {
                    return null;
                }
                return new FileEditorProvider(){

                    public FileEditor openFileEditor() {
                        return ProjectViewImpl.this.myFileEditorManager.openFile(MySelectInContext.this.myPsiFile.getContainingFile().getVirtualFile(), false)[0];
                    }
                };
            }

            private PsiElement getPsiElement() {
                PsiFile e = null;
                if (this.myEditor != null) {
                    int offset = this.myEditor.getCaretModel().getOffset();
                    PsiDocumentManager.getInstance((Project)MyAutoScrollFromSourceHandler.this.myProject).commitAllDocuments();
                    e = this.getPsiFile().findElementAt(offset);
                }
                if (e == null) {
                    e = this.getPsiFile();
                }
                return e;
            }

            @NotNull
            public VirtualFile getVirtualFile() {
                VirtualFile virtualFile = this.getPsiFile().getVirtualFile();
                if (virtualFile == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/ProjectViewImpl$MyAutoScrollFromSourceHandler$MySelectInContext.getVirtualFile must not return null");
                }
                return virtualFile;
            }

            public Object getSelectorInFile() {
                return this.getPsiElement();
            }
        }
    }

    private static class SelectionInfo {
        private final Object[] myElements;

        private SelectionInfo(Object[] elements) {
            this.myElements = elements;
        }

        public void apply(AbstractProjectViewPane viewPane) {
            if (viewPane == null) {
                return;
            }
            AbstractTreeBuilder treeBuilder = viewPane.getTreeBuilder();
            DnDAwareTree tree = viewPane.myTree;
            DefaultTreeModel treeModel = (DefaultTreeModel)((JTree)((Object)tree)).getModel();
            ArrayList<TreePath> paths = new ArrayList<TreePath>(this.myElements.length);
            for (Object element : this.myElements) {
                DefaultMutableTreeNode node = treeBuilder.getNodeForElement(element);
                if (node == null) {
                    treeBuilder.buildNodeForElement(element);
                    node = treeBuilder.getNodeForElement(element);
                }
                if (node == null) continue;
                paths.add(new TreePath(treeModel.getPathToRoot(node)));
            }
            if (!paths.isEmpty()) {
                ((JTree)((Object)tree)).setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
            }
        }

        public static SelectionInfo create(AbstractProjectViewPane viewPane) {
            TreePath[] selectionPaths;
            List selectedElements = Collections.emptyList();
            if (viewPane != null && (selectionPaths = viewPane.getSelectionPaths()) != null) {
                selectedElements = new ArrayList();
                for (TreePath path : selectionPaths) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object userObject = node.getUserObject();
                    if (!(userObject instanceof NodeDescriptor)) continue;
                    selectedElements.add(((NodeDescriptor)userObject).getElement());
                }
            }
            return new SelectionInfo(selectedElements.toArray());
        }
    }

    private class HideEmptyMiddlePackagesAction
    extends PaneOptionAction {
        private HideEmptyMiddlePackagesAction() {
            super(ProjectViewImpl.this.myHideEmptyPackages, "", "", null, true);
        }

        @Override
        public void setSelected(AnActionEvent event, boolean flag) {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            SelectionInfo selectionInfo = SelectionInfo.create(viewPane);
            super.setSelected(event, flag);
            selectionInfo.apply(viewPane);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (ProjectViewImpl.this.isFlattenPackages(ProjectViewImpl.this.myCurrentViewId)) {
                presentation.setText(IdeBundle.message((String)"action.hide.empty.middle.packages", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.show.hide.empty.middle.packages", (Object[])new Object[0]));
            } else {
                presentation.setText(IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.show.compact.empty.middle.packages", (Object[])new Object[0]));
            }
        }
    }

    private final class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element) {
            Editor editor;
            boolean isDirectory;
            ProjectViewImpl.this.selectPsiElement(element, false);
            boolean requestFocus = true;
            if (element != null && !(isDirectory = element instanceof PsiDirectory) && (editor = EditorHelper.openInEditor(element)) != null) {
                ToolWindowManager.getInstance((Project)ProjectViewImpl.this.myProject).activateEditorComponent();
                requestFocus = false;
            }
            if (requestFocus) {
                ProjectViewImpl.this.selectPsiElement(element, true);
            }
        }

        public PsiDirectory[] getDirectories() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane != null) {
                return viewPane.getSelectedDirectories();
            }
            return PsiDirectory.EMPTY_ARRAY;
        }

        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }
    }

    private final class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
        }

        private Object getSelectedNodeElement() {
            AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (currentProjectViewPane == null) {
                return null;
            }
            DefaultMutableTreeNode node = currentProjectViewPane.getSelectedNode();
            if (node == null) {
                return null;
            }
            Object userObject = node.getUserObject();
            if (userObject instanceof AbstractTreeNode) {
                return ((AbstractTreeNode)userObject).getValue();
            }
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            return ((NodeDescriptor)userObject).getElement();
        }

        public Object getData(String dataId) {
            List selectedElements;
            Object selected;
            PsiElement[] elements;
            Object paneSpecificData;
            AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (currentProjectViewPane != null && (paneSpecificData = currentProjectViewPane.getData(dataId)) != null) {
                return paneSpecificData;
            }
            if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
                if (currentProjectViewPane == null) {
                    return null;
                }
                elements = currentProjectViewPane.getSelectedPSIElements();
                return elements.length == 1 ? elements[0] : null;
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                if (currentProjectViewPane == null) {
                    return null;
                }
                elements = currentProjectViewPane.getSelectedPSIElements();
                return elements.length == 0 ? null : elements;
            }
            if (PlatformDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                PsiElement[] psiElements = (PsiElement[])this.getData(LangDataKeys.PSI_ELEMENT_ARRAY.getName());
                if (psiElements == null) {
                    return null;
                }
                LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
                for (PsiElement element : psiElements) {
                    if (!(element instanceof PsiFileSystemItem)) continue;
                    files.add(((PsiFileSystemItem)element).getVirtualFile());
                }
                return files.size() > 0 ? VfsUtil.toVirtualFileArray(files) : null;
            }
            if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
                return null;
            }
            if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCutProvider();
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCopyProvider();
            }
            if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getPasteProvider();
            }
            if (LangDataKeys.IDE_VIEW.is(dataId)) {
                return ProjectViewImpl.this.myIdeView;
            }
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                Module[] modules = this.getSelectedModules();
                if (modules != null) {
                    return ProjectViewImpl.this.myDeleteModuleProvider;
                }
                final LibraryOrderEntry orderEntry = this.getSelectedLibrary();
                if (orderEntry != null) {
                    return new DeleteProvider(){

                        public void deleteElement(DataContext dataContext) {
                            MyPanel.this.detachLibrary(orderEntry, ProjectViewImpl.this.myProject);
                        }

                        public boolean canDeleteElement(DataContext dataContext) {
                            return true;
                        }
                    };
                }
                return ProjectViewImpl.this.myDeletePSIElementProvider;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "viewingStructure.projectViews";
            }
            if (DATA_KEY.is(dataId)) {
                return ProjectViewImpl.this;
            }
            if (PlatformDataKeys.PROJECT_CONTEXT.is(dataId)) {
                selected = this.getSelectedNodeElement();
                return selected instanceof Project ? selected : null;
            }
            if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                selected = this.getSelectedNodeElement();
                if (selected instanceof Module) {
                    return !((Module)selected).isDisposed() ? selected : null;
                }
                if (selected instanceof PsiDirectory) {
                    return ProjectViewImpl.this.moduleByContentRoot(((PsiDirectory)selected).getVirtualFile());
                }
                if (selected instanceof VirtualFile) {
                    return ProjectViewImpl.this.moduleByContentRoot((VirtualFile)selected);
                }
                return null;
            }
            if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
                return this.getSelectedModules();
            }
            if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(ModuleGroup.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new ModuleGroup[selectedElements.size()]);
            }
            if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(LibraryGroupElement.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new LibraryGroupElement[selectedElements.size()]);
            }
            if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(NamedLibraryElement.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new NamedLibraryElement[selectedElements.size()]);
            }
            return null;
        }

        private LibraryOrderEntry getSelectedLibrary() {
            DefaultMutableTreeNode node;
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            DefaultMutableTreeNode defaultMutableTreeNode = node = viewPane != null ? viewPane.getSelectedNode() : null;
            if (node == null) {
                return null;
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent == null) {
                return null;
            }
            Object userObject = parent.getUserObject();
            if (userObject instanceof LibraryGroupNode) {
                userObject = node.getUserObject();
                if (userObject instanceof NamedLibraryElementNode) {
                    NamedLibraryElement element = (NamedLibraryElement)((NamedLibraryElementNode)((Object)userObject)).getValue();
                    OrderEntry orderEntry = element.getOrderEntry();
                    return orderEntry instanceof LibraryOrderEntry ? (LibraryOrderEntry)orderEntry : null;
                }
                PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)((Object)userObject)).getValue();
                VirtualFile virtualFile = directory.getVirtualFile();
                Module module = (Module)((AbstractTreeNode)((DefaultMutableTreeNode)parent.getParent()).getUserObject()).getValue();
                if (module == null) {
                    return null;
                }
                ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
                OrderEntry entry = index.getOrderEntryForFile(virtualFile);
                if (entry instanceof LibraryOrderEntry) {
                    return (LibraryOrderEntry)entry;
                }
            }
            return null;
        }

        private void detachLibrary(final LibraryOrderEntry orderEntry, Project project) {
            String title;
            final Module module = orderEntry.getOwnerModule();
            String message = IdeBundle.message((String)"detach.library.from.module", (Object[])new Object[]{orderEntry.getPresentableName(), module.getName()});
            int ret = Messages.showOkCancelDialog((Project)project, (String)message, (String)(title = IdeBundle.message((String)"detach.library", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon());
            if (ret != 0) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(module.getProject(), new Runnable(){

                @Override
                public void run() {
                    Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                            OrderEntry[] orderEntries = rootManager.getOrderEntries();
                            ModifiableRootModel model = rootManager.getModifiableModel();
                            OrderEntry[] modifiableEntries = model.getOrderEntries();
                            for (int i = 0; i < orderEntries.length; ++i) {
                                OrderEntry entry = orderEntries[i];
                                if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() != orderEntry.getLibrary()) continue;
                                model.removeOrderEntry(modifiableEntries[i]);
                            }
                            model.commit();
                        }
                    };
                    ApplicationManager.getApplication().runWriteAction(action);
                }
            }, title, null);
        }

        @Nullable
        private Module[] getSelectedModules() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane == null) {
                return null;
            }
            Object[] elements = viewPane.getSelectedElements();
            ArrayList<Module> result = new ArrayList<Module>();
            for (Object element : elements) {
                Module module;
                if (element instanceof Module) {
                    module = (Module)element;
                    if (module.isDisposed()) continue;
                    result.add(module);
                    continue;
                }
                if (element instanceof ModuleGroup) {
                    Collection<Module> modules = ((ModuleGroup)element).modulesInGroup(ProjectViewImpl.this.myProject, true);
                    result.addAll(modules);
                    continue;
                }
                if (element instanceof PsiDirectory) {
                    module = ProjectViewImpl.this.moduleByContentRoot(((PsiDirectory)element).getVirtualFile());
                    if (module == null) continue;
                    result.add(module);
                    continue;
                }
                if (!(element instanceof VirtualFile) || (module = ProjectViewImpl.this.moduleByContentRoot((VirtualFile)element)) == null) continue;
                result.add(module);
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new Module[result.size()]);
        }
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(DataContext dataContext) {
            PsiElement[] elements = this.getElementsToDelete();
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(DataContext dataContext) {
            List<PsiElement> allElements = Arrays.asList(this.getElementsToDelete());
            ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
            for (PsiElement psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = validElements.toArray(new PsiElement[validElements.size()]);
            LocalHistoryAction a = LocalHistory.startAction((Project)ProjectViewImpl.this.myProject, (String)IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, ProjectViewImpl.this.myProject);
            }
            finally {
                a.finish();
            }
        }

        private PsiElement[] getElementsToDelete() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            PsiElement[] elements = viewPane.getSelectedPSIElements();
            for (int idx = 0; idx < elements.length; ++idx) {
                PsiFile psiFile;
                VirtualFile vFile;
                VirtualFile virtualFile;
                String path;
                PsiElement element = elements[idx];
                if (!(element instanceof PsiDirectory)) continue;
                PsiDirectory directory = (PsiDirectory)element;
                ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance(ProjectViewImpl.this.myProject);
                if (ProjectViewImpl.this.isHideEmptyMiddlePackages(viewPane.getId()) && directory.getChildren().length == 0 && !directoryHelper.skipDirectory(directory)) {
                    PsiElement[] children;
                    PsiDirectory parent;
                    while ((parent = directory.getParentDirectory()) != null && !directoryHelper.skipDirectory(parent) && PsiDirectoryFactory.getInstance(ProjectViewImpl.this.myProject).getQualifiedName(parent, false).length() != 0 && ((children = parent.getChildren()).length == 0 || children.length == 1 && children[0] == directory)) {
                        directory = parent;
                    }
                    elements[idx] = directory;
                }
                if (!(path = (virtualFile = directory.getVirtualFile()).getPath()).endsWith("!/") || (vFile = LocalFileSystem.getInstance().findFileByPath(path.substring(0, path.length() - "!/".length()))) == null || (psiFile = PsiManager.getInstance((Project)ProjectViewImpl.this.myProject).findFile(vFile)) == null) continue;
                elements[idx] = psiFile;
            }
            return elements;
        }
    }

    private class PaneOptionAction
    extends ToggleAction
    implements DumbAware {
        private final Map<String, Boolean> myOptionsMap;
        private final boolean myOptionDefaultValue;

        PaneOptionAction(Map<String, Boolean> optionsMap, String text, String description, Icon icon, boolean optionDefaultValue) {
            super(text, description, icon);
            this.myOptionsMap = optionsMap;
            this.myOptionDefaultValue = optionDefaultValue;
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectViewImpl.getPaneOptionValue(this.myOptionsMap, ProjectViewImpl.this.myCurrentViewId, this.myOptionDefaultValue);
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setPaneOption(this.myOptionsMap, flag, ProjectViewImpl.this.myCurrentViewId, true);
        }
    }
}

