/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.Icons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryGroupNode
extends ProjectViewNode<LibraryGroupElement> {
    public LibraryGroupNode(Project project, LibraryGroupElement value, ViewSettings viewSettings) {
        super(project, (Object)value, viewSettings);
    }

    public LibraryGroupNode(Project project, Object value, ViewSettings viewSettings) {
        this(project, (LibraryGroupElement)value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        OrderEntry[] orderEntries;
        Module module = ((LibraryGroupElement)this.getValue()).getModule();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
            Sdk jdk;
            if (orderEntry instanceof LibraryOrderEntry) {
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                Library library = libraryOrderEntry.getLibrary();
                if (library == null) continue;
                String libraryName = library.getName();
                if (libraryName == null || libraryName.length() == 0) {
                    LibraryGroupNode.addLibraryChildren(orderEntry, children, this.getProject(), this);
                    continue;
                }
                children.add((AbstractTreeNode)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(module, orderEntry), this.getSettings()));
                continue;
            }
            if (!(orderEntry instanceof JdkOrderEntry) || (jdk = ((JdkOrderEntry)orderEntry).getJdk()) == null) continue;
            children.add((AbstractTreeNode)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(module, orderEntry), this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/LibraryGroupNode.getChildren must not return null");
        }
        return arrayList;
    }

    public static void addLibraryChildren(OrderEntry entry, List<AbstractTreeNode> children, Project project, ProjectViewNode node) {
        VirtualFile[] files;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : files = entry.getFiles(OrderRootType.CLASSES)) {
            PsiDirectory psiDir = psiManager.findDirectory(file);
            if (psiDir == null) continue;
            children.add((AbstractTreeNode)new PsiDirectoryNode(project, psiDir, node.getSettings()));
        }
    }

    public String getTestPresentation() {
        return "Libraries";
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/LibraryGroupNode.contains must not be null");
        }
        return this.someChildContainsFile(file);
    }

    public void update(PresentationData presentation) {
        presentation.setPresentableText(IdeBundle.message((String)"node.projectview.libraries", (Object[])new Object[0]));
        presentation.setIcons(Icons.LIBRARY_ICON);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public void navigate(boolean requestFocus) {
        Module module = ((LibraryGroupElement)this.getValue()).getModule();
        ProjectSettingsService.getInstance(this.myProject).openModuleLibrarySettings(module);
    }
}

