/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Icons;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ModuleListNode
extends ProjectViewNode<Module> {
    public ModuleListNode(Project project, Module value, ViewSettings viewSettings) {
        super(project, (Object)value, viewSettings);
    }

    public ModuleListNode(Project project, Object value, ViewSettings viewSettings) {
        this(project, (Module)value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = (Module)this.getValue();
        Module[] deps = ModuleRootManager.getInstance((Module)module).getDependencies(true);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (Module dependency : deps) {
            children.add((AbstractTreeNode)new ProjectViewModuleNode(this.myProject, dependency, this.getSettings()){

                @Override
                protected boolean showModuleNameInBold() {
                    return false;
                }
            });
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/ModuleListNode.getChildren must not return null");
        }
        return arrayList;
    }

    public String getTestPresentation() {
        return "Modules";
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/ModuleListNode.contains must not be null");
        }
        return this.someChildContainsFile(file);
    }

    public void update(PresentationData presentation) {
        presentation.setPresentableText("Module Dependencies");
        presentation.setIcons(Icons.CLOSED_MODULE_GROUP_ICON);
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public boolean isAlwaysExpand() {
        return true;
    }
}

