/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startupWizard;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startupWizard.SelectPluginsStep;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.ui.wizard.WizardModel;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StartupWizardModel
extends WizardModel {
    private final Set<String> myDisabledPluginIds = new HashSet();
    private final Map<String, SelectPluginsStep> myStepMap = new HashMap<String, SelectPluginsStep>();
    private SelectPluginsStep myOtherStep;

    public StartupWizardModel(List<ApplicationInfoEx.PluginChooserPage> pluginChooserPages) {
        super(ApplicationNamesInfo.getInstance().getFullProductName() + " Initial Configuration Wizard");
        IdeaPluginDescriptorImpl[] pluginDescriptors;
        this.loadDisabledPlugins(new File(PathManager.getConfigPath()));
        for (ApplicationInfoEx.PluginChooserPage page : pluginChooserPages) {
            if (page.getCategory() == null) {
                this.myOtherStep = new SelectPluginsStep(page.getTitle(), this.myDisabledPluginIds, null);
                continue;
            }
            this.addSelectPluginsStep(page.getCategory(), page.getTitle(), page.getDependentPlugin());
        }
        if (this.myOtherStep != null) {
            this.add(this.myOtherStep);
        }
        for (IdeaPluginDescriptorImpl pluginDescriptor : pluginDescriptors = PluginManager.loadDescriptors()) {
            if (pluginDescriptor.getPluginId().getIdString().equals("com.intellij")) continue;
            PluginManager.initClassLoader((ClassLoader)this.getClass().getClassLoader(), (IdeaPluginDescriptorImpl)pluginDescriptor);
            SelectPluginsStep step = this.myStepMap.get(pluginDescriptor.getCategory());
            if (step != null) {
                step.addPlugin((IdeaPluginDescriptor)pluginDescriptor);
                continue;
            }
            if (this.myOtherStep == null) continue;
            this.myOtherStep.addPlugin((IdeaPluginDescriptor)pluginDescriptor);
        }
        for (SelectPluginsStep step : this.myStepMap.values()) {
            step.fillPlugins();
        }
        this.myOtherStep.fillPlugins();
    }

    private SelectPluginsStep addSelectPluginsStep(String category, String title, String requirePlugin) {
        SelectPluginsStep step = new SelectPluginsStep(title, this.myDisabledPluginIds, requirePlugin);
        this.add(step);
        this.myStepMap.put(category, step);
        return step;
    }

    public void loadDisabledPlugins(File configDir) {
        PluginManager.loadDisabledPlugins((String)configDir.getPath(), this.myDisabledPluginIds);
    }

    public Collection<String> getDisabledPluginIds() {
        return this.myDisabledPluginIds;
    }
}

