/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.ReflectionCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

@com.intellij.openapi.components.State(name="StructureViewFactory", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public final class StructureViewFactoryImpl
extends StructureViewFactoryEx
implements PersistentStateComponent<State> {
    private final Project myProject;
    private StructureViewWrapperImpl myStructureViewWrapperImpl;
    private State myState = new State();
    private Runnable myRunWhenInitialized = null;
    private final MultiValuesMap<Class<? extends PsiElement>, StructureViewExtension> myExtensions = new MultiValuesMap();
    private final MultiValuesMap<Class<? extends PsiElement>, StructureViewExtension> myImplExtensions = new MultiValuesMap();

    public StructureViewFactoryImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public StructureViewWrapper getStructureViewWrapper() {
        return this.myStructureViewWrapperImpl;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public void initToolWindow(ToolWindow toolWindow) {
        this.myStructureViewWrapperImpl = new StructureViewWrapperImpl(this.myProject);
        Content content = ContentFactory.SERVICE.getInstance().createContent(this.myStructureViewWrapperImpl.getComponent(), "", false);
        Disposer.register((Disposable)content, (Disposable)this.myStructureViewWrapperImpl);
        toolWindow.getContentManager().addContent(content);
        if (this.myRunWhenInitialized != null) {
            this.myRunWhenInitialized.run();
            this.myRunWhenInitialized = null;
        }
    }

    @Override
    public void registerExtension(Class<? extends PsiElement> type, StructureViewExtension extension) {
        this.myExtensions.put(type, (Object)extension);
        this.myImplExtensions.clear();
    }

    @Override
    public void unregisterExtension(Class<? extends PsiElement> type, StructureViewExtension extension) {
        this.myExtensions.remove(type, (Object)extension);
        this.myImplExtensions.clear();
    }

    @Override
    public Collection<StructureViewExtension> getAllExtensions(Class<? extends PsiElement> type) {
        Collection result = this.myImplExtensions.get(type);
        if (result == null) {
            for (Class registeredType : this.myExtensions.keySet()) {
                if (!ReflectionCache.isAssignable((Class)registeredType, type)) continue;
                Collection extensions = this.myExtensions.get((Object)registeredType);
                for (StructureViewExtension extension : extensions) {
                    this.myImplExtensions.put(type, (Object)extension);
                }
            }
            result = this.myImplExtensions.get(type);
            if (result == null) {
                return Collections.emptyList();
            }
        }
        return result;
    }

    @Override
    public void setActiveAction(String name, boolean state) {
        Collection<String> activeActions = this.collectActiveActions();
        if (state) {
            activeActions.add(name);
        } else {
            activeActions.remove(name);
        }
        this.myState.ACTIVE_ACTIONS = StructureViewFactoryImpl.toString(activeActions);
    }

    private static String toString(Collection<String> activeActions) {
        return StringUtil.join(activeActions, (String)",");
    }

    private Collection<String> collectActiveActions() {
        String[] strings = this.myState.ACTIVE_ACTIONS.split(",");
        return new HashSet<String>(Arrays.asList(strings));
    }

    @Override
    public boolean isActionActive(String name) {
        return this.collectActiveActions().contains(name);
    }

    @Override
    public void runWhenInitialized(Runnable runnable) {
        if (this.myStructureViewWrapperImpl != null) {
            runnable.run();
        } else {
            this.myRunWhenInitialized = runnable;
        }
    }

    public StructureView createStructureView(FileEditor fileEditor, StructureViewModel treeModel, Project project) {
        return new StructureViewComponent(fileEditor, treeModel, project);
    }

    public StructureView createStructureView(FileEditor fileEditor, StructureViewModel treeModel, Project project, boolean showRootNode) {
        return new StructureViewComponent(fileEditor, treeModel, project, showRootNode);
    }

    public static class State {
        public boolean AUTOSCROLL_MODE = true;
        public boolean AUTOSCROLL_FROM_SOURCE = false;
        public String ACTIVE_ACTIONS = "";
    }
}

