/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoCompositeRenderer;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.configurable.TodoConfigurable;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.VisibilityWatcher;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Icons;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

abstract class TodoPanel
extends SimpleToolWindowPanel
implements OccurenceNavigator,
DataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.todo.TodoPanel");
    protected Project myProject;
    private final TodoPanelSettings mySettings;
    private final boolean myCurrentFileMode;
    private final Content myContent;
    private final Tree myTree;
    private final MyTreeExpander myTreeExpander;
    private final MyOccurenceNavigator myOccurenceNavigator;
    protected final TodoTreeBuilder myTodoTreeBuilder;
    private MyVisibilityWatcher myVisibilityWatcher;

    TodoPanel(Project project, TodoPanelSettings settings, boolean currentFileMode, Content content) {
        super(false, true);
        this.myProject = project;
        this.mySettings = settings;
        this.myCurrentFileMode = currentFileMode;
        this.myContent = content;
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model);
        this.myTreeExpander = new MyTreeExpander();
        this.myOccurenceNavigator = new MyOccurenceNavigator();
        this.initUI();
        this.myTodoTreeBuilder = this.createTreeBuilder((JTree)this.myTree, model, this.myProject);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myTodoTreeBuilder);
        this.updateTodoFilter();
        this.myTodoTreeBuilder.setShowPackages(this.mySettings.arePackagesShown());
        this.myTodoTreeBuilder.setShowModules(this.mySettings.areModulesShown());
        this.myTodoTreeBuilder.setFlattenPackages(this.mySettings.areFlattenPackages());
        this.myVisibilityWatcher = new MyVisibilityWatcher();
        this.myVisibilityWatcher.install((Component)((Object)this));
    }

    protected abstract TodoTreeBuilder createTreeBuilder(JTree var1, DefaultTreeModel var2, Project var3);

    private void initUI() {
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new TodoCompositeRenderer());
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("EditSource"));
        group.addSeparator();
        group.add(ActionManager.getInstance().getAction("VersionControlsGroup"));
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)group, (String)"TodoViewPopup", (ActionManager)ActionManager.getInstance());
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!e.isConsumed() && 10 == e.getKeyCode()) {
                    TreePath path = TodoPanel.this.myTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    NodeDescriptor desciptor = (NodeDescriptor)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (!(desciptor instanceof TodoItemNode)) {
                        return;
                    }
                    OpenSourceUtil.openSourcesFrom((DataProvider)TodoPanel.this, (boolean)false);
                }
            }
        });
        this.setContent(new JScrollPane((Component)this.myTree));
        JPanel toolBarPanel = new JPanel(new GridLayout());
        DefaultActionGroup leftGroup = new DefaultActionGroup();
        leftGroup.add((AnAction)new PreviousOccurenceToolbarAction(this.myOccurenceNavigator));
        leftGroup.add((AnAction)new NextOccurenceToolbarAction(this.myOccurenceNavigator));
        leftGroup.add((AnAction)new ContextHelpAction("find.todoList"));
        toolBarPanel.add(ActionManager.getInstance().createActionToolbar("TodoViewToolbar", (ActionGroup)leftGroup, false).getComponent());
        DefaultActionGroup rightGroup = new DefaultActionGroup();
        AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)this.myTreeExpander, (JComponent)((Object)this));
        rightGroup.add(expandAllAction);
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)this.myTreeExpander, (JComponent)((Object)this));
        rightGroup.add(collapseAllAction);
        if (!this.myCurrentFileMode) {
            MyShowModulesAction showModulesAction = new MyShowModulesAction();
            showModulesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(77, SystemInfo.isMac ? 4 : 2)), (JComponent)this.myTree);
            rightGroup.add((AnAction)showModulesAction);
            MyShowPackagesAction showPackagesAction = new MyShowPackagesAction();
            showPackagesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(80, SystemInfo.isMac ? 4 : 2)), (JComponent)this.myTree);
            rightGroup.add((AnAction)showPackagesAction);
            MyFlattenPackagesAction flattenPackagesAction = new MyFlattenPackagesAction();
            flattenPackagesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(70, SystemInfo.isMac ? 4 : 2)), (JComponent)this.myTree);
            rightGroup.add((AnAction)flattenPackagesAction);
        }
        MyAutoScrollToSourceHandler autoScrollToSourceHandler = new MyAutoScrollToSourceHandler();
        autoScrollToSourceHandler.install((JTree)this.myTree);
        rightGroup.add((AnAction)autoScrollToSourceHandler.createToggleAction());
        MySetTodoFilterAction setTodoFilterAction = new MySetTodoFilterAction();
        rightGroup.add((AnAction)setTodoFilterAction);
        toolBarPanel.add(ActionManager.getInstance().createActionToolbar("TodoViewToolbar", (ActionGroup)rightGroup, false).getComponent());
        this.setToolbar(toolBarPanel);
    }

    public void dispose() {
        if (this.myVisibilityWatcher != null) {
            this.myVisibilityWatcher.deinstall((Component)((Object)this));
            this.myVisibilityWatcher = null;
        }
        this.myProject = null;
    }

    void rebuildCache() {
        this.myTodoTreeBuilder.rebuildCache();
    }

    void updateTree() {
        this.myTodoTreeBuilder.updateTree(false);
    }

    void updateTodoFilter() {
        TodoFilter filter = TodoConfiguration.getInstance().getTodoFilter(this.mySettings.getTodoFilterName());
        this.setTodoFilter(filter);
    }

    private void setTodoFilter(TodoFilter filter) {
        String filterName = filter != null ? filter.getName() : null;
        this.mySettings.setTodoFilterName(filterName);
        this.myTodoTreeBuilder.setTodoFilter(filter);
        this.myContent.setDescription(filterName);
    }

    @Nullable
    protected PsiFile getSelectedFile() {
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        LOG.assertTrue(node != null);
        if (node.getUserObject() == null) {
            return null;
        }
        return TodoTreeBuilder.getFileForNode(node);
    }

    protected void setDisplayName(String tabName) {
        this.myContent.setDisplayName(tabName);
    }

    @Nullable
    private PsiElement getSelectedElement() {
        if (this.myTree == null) {
            return null;
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        PsiElement selectedElement = TodoTreeHelper.getInstance(this.myProject).getSelectedElement(userObject);
        if (selectedElement != null) {
            return selectedElement;
        }
        return this.getSelectedFile();
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            TreePath path = this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            NodeDescriptor userObject = (NodeDescriptor)node.getUserObject();
            if (userObject == null) {
                return null;
            }
            Object element = userObject.getElement();
            if (!(element instanceof TodoFileNode) && !(element instanceof TodoItemNode)) {
                return null;
            }
            TodoItemNode pointer = this.myTodoTreeBuilder.getFirstPointerForElement(element);
            if (pointer != null) {
                return new OpenFileDescriptor(this.myProject, ((SmartTodoItemPointer)pointer.getValue()).getTodoItem().getFile().getVirtualFile(), ((SmartTodoItemPointer)pointer.getValue()).getRangeMarker().getStartOffset());
            }
            return null;
        }
        if (PlatformDataKeys.VIRTUAL_FILE.is(dataId)) {
            PsiFile file = this.getSelectedFile();
            return file != null ? file.getVirtualFile() : null;
        }
        if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.getSelectedElement();
        }
        if (PlatformDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            PsiFile file = this.getSelectedFile();
            if (file != null) {
                return new VirtualFile[]{file.getVirtualFile()};
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "find.todoList";
        }
        return null;
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator.goPreviousOccurence();
    }

    public String getNextOccurenceActionName() {
        return this.myOccurenceNavigator.getNextOccurenceActionName();
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator.goNextOccurence();
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator.hasNextOccurence();
    }

    public String getPreviousOccurenceActionName() {
        return this.myOccurenceNavigator.getPreviousOccurenceActionName();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator.hasPreviousOccurence();
    }

    private final class MyVisibilityWatcher
    extends VisibilityWatcher {
        private MyVisibilityWatcher() {
        }

        @Override
        public void visibilityChanged() {
            PsiDocumentManager.getInstance((Project)TodoPanel.this.myProject).commitAllDocuments();
            TodoPanel.this.myTodoTreeBuilder.setUpdatable(TodoPanel.this.isShowing());
        }
    }

    private final class MySetTodoFilterAction
    extends AnAction
    implements CustomComponentAction {
        MySetTodoFilterAction() {
            super(IdeBundle.message((String)"action.filter.todo.items", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/ant/filter.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            JComponent button = (JComponent)presentation.getClientProperty("button");
            DefaultActionGroup group = this.createPopupActionGroup();
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("TodoViewToolbar", (ActionGroup)group);
            popupMenu.getComponent().show(button, button.getWidth(), 0);
        }

        public JComponent createCustomComponent(Presentation presentation) {
            ActionButton button = new ActionButton(this, presentation, "TodoViewToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            presentation.putClientProperty("button", (Object)button);
            return button;
        }

        private DefaultActionGroup createPopupActionGroup() {
            TodoFilter[] filters = TodoConfiguration.getInstance().getTodoFilters();
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new TodoFilterApplier(IdeBundle.message((String)"action.todo.show.all", (Object[])new Object[0]), IdeBundle.message((String)"action.description.todo.show.all", (Object[])new Object[0]), null));
            for (TodoFilter filter : filters) {
                group.add((AnAction)new TodoFilterApplier(filter.getName(), null, filter));
            }
            group.addSeparator();
            group.add(new AnAction(IdeBundle.message((String)"action.todo.edit.filters", (Object[])new Object[0]), IdeBundle.message((String)"action.todo.edit.filters", (Object[])new Object[0]), IconLoader.getIcon((String)"/general/ideOptions.png")){

                public void actionPerformed(AnActionEvent e) {
                    ShowSettingsUtil.getInstance().editConfigurable(TodoPanel.this.myProject, (Configurable)TodoConfigurable.getInstance());
                }
            });
            return group;
        }

        private final class TodoFilterApplier
        extends ToggleAction {
            private final TodoFilter myFilter;

            TodoFilterApplier(String text, String description, TodoFilter filter) {
                super(null, description, null);
                this.getTemplatePresentation().setText(text, false);
                this.myFilter = filter;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                if (this.myFilter != null) {
                    e.getPresentation().setEnabled(!this.myFilter.isEmpty());
                }
            }

            public boolean isSelected(AnActionEvent e) {
                return Comparing.equal((String)(this.myFilter != null ? this.myFilter.getName() : null), (String)TodoPanel.this.mySettings.getTodoFilterName());
            }

            public void setSelected(AnActionEvent e, boolean state) {
                if (state) {
                    TodoPanel.this.setTodoFilter(this.myFilter);
                }
            }
        }
    }

    private final class MyFlattenPackagesAction
    extends ToggleAction {
        MyFlattenPackagesAction() {
            super(IdeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), null, Icons.FLATTEN_PACKAGES_ICON);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(TodoPanel.this.mySettings.arePackagesShown());
        }

        public boolean isSelected(AnActionEvent e) {
            return TodoPanel.this.mySettings.areFlattenPackages();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            TodoPanel.this.mySettings.setAreFlattenPackages(state);
            TodoPanel.this.myTodoTreeBuilder.setFlattenPackages(state);
        }
    }

    private final class MyShowModulesAction
    extends ToggleAction {
        MyShowModulesAction() {
            super(IdeBundle.message((String)"action.group.by.modules", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/objectBrowser/showModules.png"));
        }

        public boolean isSelected(AnActionEvent e) {
            return TodoPanel.this.mySettings.areModulesShown();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            TodoPanel.this.mySettings.setShownModules(state);
            TodoPanel.this.myTodoTreeBuilder.setShowModules(state);
        }
    }

    private final class MyShowPackagesAction
    extends ToggleAction {
        MyShowPackagesAction() {
            super(IdeBundle.message((String)"action.group.by.packages", (Object[])new Object[0]), null, Icons.GROUP_BY_PACKAGES);
        }

        public boolean isSelected(AnActionEvent e) {
            return TodoPanel.this.mySettings.arePackagesShown();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            TodoPanel.this.mySettings.setShownPackages(state);
            TodoPanel.this.myTodoTreeBuilder.setShowPackages(state);
        }
    }

    private final class MyOccurenceNavigator
    implements OccurenceNavigator {
        private MyOccurenceNavigator() {
        }

        public boolean hasNextOccurence() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject == null) {
                return false;
            }
            if (userObject instanceof NodeDescriptor && ((NodeDescriptor)userObject).getElement() instanceof TodoItemNode) {
                return TodoPanel.this.myTree.getRowCount() != TodoPanel.this.myTree.getRowForPath(path) + 1;
            }
            return node.getChildCount() > 0;
        }

        public boolean hasPreviousOccurence() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            return userObject instanceof NodeDescriptor && !this.isFirst(node);
        }

        private boolean isFirst(TreeNode node) {
            TreeNode parent = node.getParent();
            return parent == null || parent.getIndex(node) == 0 && this.isFirst(parent);
        }

        @Nullable
        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return this.goToPointer(this.getNextPointer());
        }

        @Nullable
        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return this.goToPointer(this.getPreviousPointer());
        }

        public String getNextOccurenceActionName() {
            return IdeBundle.message((String)"action.next.todo", (Object[])new Object[0]);
        }

        public String getPreviousOccurenceActionName() {
            return IdeBundle.message((String)"action.previous.todo", (Object[])new Object[0]);
        }

        @Nullable
        private OccurenceNavigator.OccurenceInfo goToPointer(TodoItemNode pointer) {
            if (pointer == null) {
                return null;
            }
            DefaultMutableTreeNode node = TodoPanel.this.myTodoTreeBuilder.getNodeForElement(pointer);
            if (node == null) {
                TodoPanel.this.myTodoTreeBuilder.buildNodeForElement(pointer);
                node = TodoPanel.this.myTodoTreeBuilder.getNodeForElement(pointer);
                if (node == null) {
                    return null;
                }
            }
            TreeUtil.selectPath((JTree)TodoPanel.this.myTree, (TreePath)new TreePath(node.getPath()));
            return new OccurenceNavigator.OccurenceInfo((Navigatable)new OpenFileDescriptor(TodoPanel.this.myProject, ((SmartTodoItemPointer)pointer.getValue()).getTodoItem().getFile().getVirtualFile(), ((SmartTodoItemPointer)pointer.getValue()).getRangeMarker().getStartOffset()), -1, -1);
        }

        @Nullable
        private TodoItemNode getNextPointer() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            NodeDescriptor userObject = (NodeDescriptor)node.getUserObject();
            if (userObject == null) {
                return null;
            }
            Object element = userObject.getElement();
            TodoItemNode pointer = element instanceof TodoItemNode ? TodoPanel.this.myTodoTreeBuilder.getNextPointer((TodoItemNode)element) : TodoPanel.this.myTodoTreeBuilder.getFirstPointerForElement(element);
            return pointer;
        }

        @Nullable
        private TodoItemNode getPreviousPointer() {
            TodoItemNode pointer;
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            NodeDescriptor userObject = (NodeDescriptor)node.getUserObject();
            if (userObject == null) {
                return null;
            }
            Object element = userObject.getElement();
            if (element instanceof TodoItemNode) {
                pointer = TodoPanel.this.myTodoTreeBuilder.getPreviousPointer((TodoItemNode)element);
            } else {
                Object sibling = TodoPanel.this.myTodoTreeBuilder.getPreviousSibling(element);
                if (sibling == null) {
                    return null;
                }
                pointer = TodoPanel.this.myTodoTreeBuilder.getLastPointerForElement(sibling);
            }
            return pointer;
        }
    }

    private final class MyAutoScrollToSourceHandler
    extends AutoScrollToSourceHandler {
        MyAutoScrollToSourceHandler() {
        }

        protected boolean isAutoScrollMode() {
            return TodoPanel.this.mySettings.isAutoScrollToSource();
        }

        protected void setAutoScrollMode(boolean state) {
            TodoPanel.this.mySettings.setAutoScrollToSource(state);
        }
    }

    private final class MyTreeExpander
    implements TreeExpander {
        private MyTreeExpander() {
        }

        public boolean canCollapse() {
            return true;
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            TodoPanel.this.myTodoTreeBuilder.collapseAll();
        }

        public void expandAll() {
            TodoPanel.this.myTodoTreeBuilder.expandAll(null);
        }
    }
}

