/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.Patches;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseByNameBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ChooseByNameBase");
    protected final Project myProject;
    protected final ChooseByNameModel myModel;
    protected final String myInitialText;
    private boolean myPreselectInitialText;
    private final Reference<PsiElement> myContext;
    protected Component myPreviouslyFocusedComponent;
    protected JPanelProvider myTextFieldPanel;
    protected JTextField myTextField;
    private JPanel myCardContainer;
    private CardLayout myCard;
    protected JCheckBox myCheckBox;
    protected JComponent myToolArea;
    protected JScrollPane myListScrollPane;
    protected JList myList;
    private DefaultListModel myListModel;
    private List<Pair<String, Integer>> myHistory;
    private List<Pair<String, Integer>> myFuture;
    protected ChooseByNamePopupComponent.Callback myActionListener;
    protected final Alarm myAlarm = new Alarm();
    private final ListUpdater myListUpdater = new ListUpdater();
    private volatile boolean myListIsUpToDate = false;
    protected boolean myDisposedFlag = false;
    private ActionCallback myPosponedOkAction;
    private final String[][] myNames = new String[2][];
    private CalcElementsThread myCalcElementsThread;
    private static int VISIBLE_LIST_SIZE_LIMIT = 10;
    private static final int MAXIMUM_LIST_SIZE_LIMIT = 30;
    private int myMaximumListSizeLimit = 30;
    @NonNls
    private static final String NOT_FOUND_IN_PROJECT_CARD = "syslib";
    @NonNls
    private static final String NOT_FOUND_CARD = "nfound";
    @NonNls
    private static final String CHECK_BOX_CARD = "chkbox";
    @NonNls
    private static final String SEARCHING_CARD = "searching";
    private static final int REBUILD_DELAY = 300;
    private final Alarm myHideAlarm = new Alarm();
    private final Object myRebuildMutex = new Object();
    private static final String EXTRA_ELEM = "...";

    protected ChooseByNameBase(Project project, ChooseByNameModel model, String initialText, PsiElement context) {
        this.myProject = project;
        this.myModel = model;
        this.myInitialText = initialText;
        this.myContext = new WeakReference<PsiElement>(context);
    }

    public boolean isPreselectInitialText() {
        return this.myPreselectInitialText;
    }

    public void setPreselectInitialText(boolean preselectInitialText) {
        this.myPreselectInitialText = preselectInitialText;
    }

    public void setToolArea(JComponent toolArea) {
        if (this.myCard != null) {
            throw new IllegalStateException("Tool area is modifiable only before invoke()");
        }
        this.myToolArea = toolArea;
    }

    public void invoke(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
        this.initUI(callback, modalityState, allowMultipleSelection);
    }

    protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
        this.myPreviouslyFocusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
        this.myActionListener = callback;
        this.myTextFieldPanel = new JPanelProvider();
        this.myTextFieldPanel.setLayout(new BoxLayout(this.myTextFieldPanel, 1));
        JPanel hBox = new JPanel();
        hBox.setLayout(new BoxLayout(hBox, 0));
        if (this.myModel.getPromptText() != null) {
            JLabel label = new JLabel(" " + this.myModel.getPromptText());
            label.setFont(UIUtil.getLabelFont().deriveFont(1));
            hBox.add(label);
        }
        this.myCard = new CardLayout();
        this.myCardContainer = new JPanel(this.myCard);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.myCheckBox = new JCheckBox(this.myModel.getCheckBoxName());
        this.myCheckBox.setSelected(this.myModel.loadInitialCheckBoxState());
        if (this.myModel.getPromptText() != null) {
            checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
            checkBoxPanel.add(new JLabel("  ("));
            checkBoxPanel.add(this.myCheckBox);
            checkBoxPanel.add(new JLabel(")"));
        } else {
            checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 2));
            checkBoxPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            checkBoxPanel.add(new JLabel(")"));
            checkBoxPanel.add(this.myCheckBox);
            checkBoxPanel.add(new JLabel("  ("));
        }
        checkBoxPanel.setVisible(this.myModel.getCheckBoxName() != null);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)checkBoxPanel, "Center");
        this.myCardContainer.add((Component)panel, CHECK_BOX_CARD);
        this.myCardContainer.add((Component)new JLabel("  (" + this.myModel.getNotInMessage() + ")"), NOT_FOUND_IN_PROJECT_CARD);
        this.myCardContainer.add((Component)new JLabel("  " + IdeBundle.message((String)"label.choosebyname.no.matches.found", (Object[])new Object[0])), NOT_FOUND_CARD);
        this.myCardContainer.add((Component)new JLabel("  " + IdeBundle.message((String)"label.choosebyname.searching", (Object[])new Object[0])), SEARCHING_CARD);
        this.myCard.show(this.myCardContainer, CHECK_BOX_CARD);
        if (this.isCheckboxVisible()) {
            hBox.add(this.myCardContainer);
        }
        if (this.myToolArea != null) {
            hBox.add(this.myToolArea);
        }
        this.myTextFieldPanel.add(hBox);
        this.myHistory = new ArrayList<Pair<String, Integer>>();
        this.myFuture = new ArrayList<Pair<String, Integer>>();
        this.myTextField = new MyTextField();
        this.myTextField.setText(this.myInitialText);
        if (this.myPreselectInitialText) {
            this.myTextField.select(0, this.myInitialText.length());
        }
        final ActionMap actionMap = new ActionMap();
        actionMap.setParent(this.myTextField.getActionMap());
        actionMap.put("copy-to-clipboard", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChooseByNameBase.this.myTextField.getSelectedText() != null) {
                    actionMap.getParent().get("copy-to-clipboard").actionPerformed(e);
                    return;
                }
                Object chosenElement = ChooseByNameBase.this.getChosenElement();
                if (chosenElement instanceof PsiElement) {
                    CopyReferenceAction.doCopy((PsiElement)chosenElement, ChooseByNameBase.this.myProject);
                }
            }
        });
        this.myTextField.setActionMap(actionMap);
        this.myTextFieldPanel.add(this.myTextField);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Font editorFont = new Font(scheme.getEditorFontName(), 0, scheme.getEditorFontSize());
        this.myTextField.setFont(editorFont);
        if (this.isCloseByFocusLost()) {
            this.myTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(final FocusEvent e) {
                    ChooseByNameBase.this.myHideAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            if (!JBPopupFactory.getInstance().isChildPopupFocused(e.getComponent())) {
                                ChooseByNameBase.this.hideHint();
                            }
                        }
                    }, 200);
                }
            });
        }
        this.myCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ChooseByNameBase.this.rebuildList();
            }
        });
        this.myCheckBox.setFocusable(false);
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ChooseByNameBase.this.clearPosponedOkAction(false);
                ChooseByNameBase.this.rebuildList();
            }
        });
        this.myTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!ChooseByNameBase.this.myListScrollPane.isVisible()) {
                    return;
                }
                int keyCode = e.getKeyCode();
                switch (keyCode) {
                    case 40: {
                        ListScrollingUtil.moveDown((JList)ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                        break;
                    }
                    case 38: {
                        ListScrollingUtil.moveUp((JList)ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                        break;
                    }
                    case 33: {
                        ListScrollingUtil.movePageUp((JList)ChooseByNameBase.this.myList);
                        break;
                    }
                    case 34: {
                        ListScrollingUtil.movePageDown((JList)ChooseByNameBase.this.myList);
                        break;
                    }
                    case 10: {
                        if (ChooseByNameBase.this.myList.getSelectedValue() != ChooseByNameBase.EXTRA_ELEM) break;
                        ChooseByNameBase.this.myMaximumListSizeLimit += 30;
                        ChooseByNameBase.this.rebuildList(ChooseByNameBase.this.myList.getSelectedIndex(), 300, null, ModalityState.current());
                        e.consume();
                    }
                }
            }
        });
        this.myTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseByNameBase.this.doClose(true);
            }
        });
        this.myListModel = new DefaultListModel();
        this.myList = new JList(this.myListModel);
        this.myList.setFocusable(false);
        this.myList.setSelectionMode(allowMultipleSelection ? 2 : 0);
        this.myList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ChooseByNameBase.this.myTextField.hasFocus()) {
                    ChooseByNameBase.this.myTextField.requestFocus();
                }
                if (e.getClickCount() == 2) {
                    if (ChooseByNameBase.this.myList.getSelectedValue() == ChooseByNameBase.EXTRA_ELEM) {
                        ChooseByNameBase.this.myMaximumListSizeLimit += 30;
                        ChooseByNameBase.this.rebuildList(ChooseByNameBase.this.myList.getSelectedIndex(), 300, null, ModalityState.current());
                        e.consume();
                    } else {
                        ChooseByNameBase.this.doClose(true);
                    }
                }
            }
        });
        this.myList.setCellRenderer(this.myModel.getListCellRenderer());
        this.myList.setFont(editorFont);
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ChooseByNameBase.this.choosenElementMightChange();
                ChooseByNameBase.this.updateDocumentation();
            }
        });
        this.myListScrollPane = new JScrollPane(this.myList);
        if (!UIUtil.isMotifLookAndFeel()) {
            UIUtil.installPopupMenuBorder((JComponent)this.myTextFieldPanel);
        }
        UIUtil.installPopupMenuColorAndFonts((JComponent)this.myTextFieldPanel);
        this.showTextFieldPanel();
        if (modalityState != null) {
            this.rebuildList(0, 0, null, modalityState);
        }
    }

    private void hideHint() {
        if (!this.myTextFieldPanel.focusRequested()) {
            this.doClose(false);
            this.myTextFieldPanel.hideHint();
        }
    }

    public void rebuildList() {
        this.rebuildList(0, 300, null, ModalityState.current());
    }

    private void updateDocumentation() {
        JBPopup hint = this.myTextFieldPanel.getHint();
        Object element = this.getChosenElement();
        if (hint != null) {
            Object o;
            if (element instanceof PsiElement) {
                this.myTextFieldPanel.updateHint((PsiElement)element);
            } else if (element instanceof DataProvider && (o = ((DataProvider)element).getData(LangDataKeys.PSI_ELEMENT.getName())) instanceof PsiElement) {
                this.myTextFieldPanel.updateHint((PsiElement)o);
            }
        }
    }

    private void doClose(boolean ok) {
        if (this.myDisposedFlag) {
            return;
        }
        if (this.posponeCloseWhenListReady(ok)) {
            return;
        }
        this.cancelListUpdater();
        this.close(ok);
        this.clearPosponedOkAction(ok);
    }

    protected void cancelListUpdater() {
        this.myListUpdater.cancelAll();
    }

    private boolean posponeCloseWhenListReady(boolean ok) {
        if (!Registry.is((String)"actionSystem.fixLostTyping")) {
            return false;
        }
        String text = this.myTextField.getText();
        if (ok && !this.myListIsUpToDate && text != null && text.trim().length() > 0) {
            this.myPosponedOkAction = new ActionCallback();
            IdeFocusManager.getInstance((Project)this.myProject).suspendKeyProcessingUntil(this.myPosponedOkAction);
            return true;
        }
        return false;
    }

    private synchronized void ensureNamesLoaded(boolean checkboxState) {
        int index;
        int n = index = checkboxState ? 1 : 0;
        if (this.myNames[index] != null) {
            return;
        }
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.myTextField);
        Window ownerWindow = null;
        if (window != null) {
            window.setCursor(Cursor.getPredefinedCursor(3));
            ownerWindow = window.getOwner();
            if (ownerWindow != null) {
                ownerWindow.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
        this.myNames[index] = this.myModel.getNames(checkboxState);
        if (window != null) {
            window.setCursor(Cursor.getDefaultCursor());
            if (ownerWindow != null) {
                ownerWindow.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    protected abstract boolean isCheckboxVisible();

    protected abstract boolean isShowListForEmptyPattern();

    protected abstract boolean isCloseByFocusLost();

    protected void showTextFieldPanel() {
        JLayeredPane layeredPane = this.getLayeredPane();
        Dimension preferredTextFieldPanelSize = this.myTextFieldPanel.getPreferredSize();
        int x = (layeredPane.getWidth() - preferredTextFieldPanelSize.width) / 2;
        int paneHeight = layeredPane.getHeight();
        int y = paneHeight / 3 - preferredTextFieldPanelSize.height / 2;
        this.myTextFieldPanel.setBounds(x, y, preferredTextFieldPanelSize.width, preferredTextFieldPanelSize.height);
        layeredPane.add((Component)this.myTextFieldPanel, (Object)500);
        layeredPane.moveToFront(this.myTextFieldPanel);
        VISIBLE_LIST_SIZE_LIMIT = Math.max(10, (paneHeight - (y + preferredTextFieldPanelSize.height)) / (preferredTextFieldPanelSize.height / 2) - 1);
        this.myTextFieldPanel.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseByNameBase.this.doClose(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.myList.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseByNameBase.this.doClose(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTextField, true);
        this.myTextFieldPanel.validate();
        this.myTextFieldPanel.paintImmediately(0, 0, this.myTextFieldPanel.getWidth(), this.myTextFieldPanel.getHeight());
    }

    private JLayeredPane getLayeredPane() {
        JLayeredPane layeredPane;
        Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
        Component parent = UIUtil.findUltimateParent((Component)window);
        if (parent instanceof JFrame) {
            layeredPane = ((JFrame)parent).getLayeredPane();
        } else if (parent instanceof JDialog) {
            layeredPane = ((JDialog)parent).getLayeredPane();
        } else {
            throw new IllegalStateException("cannot find parent window: project=" + this.myProject + (this.myProject != null ? "; open=" + this.myProject.isOpen() : "") + "; window=" + window);
        }
        return layeredPane;
    }

    protected void rebuildList(final int pos, final int delay, final Runnable postRunnable, final ModalityState modalityState) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myListIsUpToDate = false;
        this.myAlarm.cancelAllRequests();
        this.myListUpdater.cancelAll();
        this.cancelCalcElementsThread();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                final String text = ChooseByNameBase.this.myTextField.getText();
                if (!(ChooseByNameBase.this.isShowListForEmptyPattern() || text != null && text.trim().length() != 0)) {
                    ChooseByNameBase.this.myListModel.clear();
                    ChooseByNameBase.this.hideList();
                    ChooseByNameBase.this.myCard.show(ChooseByNameBase.this.myCardContainer, ChooseByNameBase.CHECK_BOX_CARD);
                    return;
                }
                Runnable request = new Runnable(){

                    @Override
                    public void run() {
                        CalcElementsCallback callback = new CalcElementsCallback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run(Set<?> elements) {
                                Object object = ChooseByNameBase.this.myRebuildMutex;
                                synchronized (object) {
                                    ApplicationManager.getApplication().assertIsDispatchThread();
                                    if (ChooseByNameBase.this.myDisposedFlag) {
                                        return;
                                    }
                                    ChooseByNameBase.this.setElementsToList(pos, elements);
                                    ChooseByNameBase.this.myListIsUpToDate = true;
                                    ChooseByNameBase.this.choosenElementMightChange();
                                    if (postRunnable != null) {
                                        postRunnable.run();
                                    }
                                }
                            }
                        };
                        ChooseByNameBase.this.cancelCalcElementsThread();
                        ChooseByNameBase.this.myCalcElementsThread = new CalcElementsThread(text, ChooseByNameBase.this.myCheckBox.isSelected(), callback, modalityState, postRunnable == null);
                        ApplicationManager.getApplication().executeOnPooledThread((Runnable)ChooseByNameBase.this.myCalcElementsThread);
                    }
                };
                if (delay > 0) {
                    ChooseByNameBase.this.myAlarm.addRequest(request, delay, ModalityState.stateForComponent((Component)ChooseByNameBase.this.myTextField));
                } else {
                    request.run();
                }
            }
        }, modalityState);
    }

    private void cancelCalcElementsThread() {
        if (this.myCalcElementsThread != null) {
            this.myCalcElementsThread.cancel();
            this.myCalcElementsThread = null;
        }
    }

    private void setElementsToList(int pos, Set<?> elements) {
        Object[] newElements;
        this.myListUpdater.cancelAll();
        if (this.myDisposedFlag) {
            return;
        }
        if (elements.isEmpty()) {
            this.myListModel.clear();
            this.myTextField.setForeground(Color.red);
            this.myListUpdater.cancelAll();
            this.hideList();
            this.clearPosponedOkAction(false);
            return;
        }
        Object[] oldElements = this.myListModel.toArray();
        Diff.Change change = Diff.buildChanges((Object[])oldElements, (Object[])(newElements = elements.toArray()));
        if (change == null) {
            return;
        }
        ArrayList<Cmd> commands = new ArrayList<Cmd>();
        int inserted = 0;
        int deleted = 0;
        while (change != null) {
            if (change.deleted > 0) {
                int start = change.line0 + inserted - deleted;
                commands.add(new RemoveCmd(start, start + change.deleted - 1));
            }
            if (change.inserted > 0) {
                for (int i = 0; i < change.inserted; ++i) {
                    commands.add(new InsertCmd(change.line0 + i + inserted - deleted, newElements[change.line1 + i]));
                }
            }
            deleted += change.deleted;
            inserted += change.inserted;
            change = change.link;
        }
        this.myTextField.setForeground(UIUtil.getTextFieldForeground());
        if (!commands.isEmpty()) {
            this.showList();
            this.myListUpdater.appendToModel(commands, pos);
        } else {
            if (pos == 0) {
                pos = this.detectBestStatisticalPosition();
            }
            ListScrollingUtil.selectItem((JList)this.myList, (int)Math.min(pos, this.myListModel.size() - 1));
            this.myList.setVisibleRowCount(Math.min(VISIBLE_LIST_SIZE_LIMIT, this.myList.getModel().getSize()));
            this.showList();
        }
    }

    private int detectBestStatisticalPosition() {
        int best = 0;
        int bestPosition = 0;
        int count = this.myListModel.getSize();
        String statContext = this.statisticsContext();
        for (int i = 0; i < count; ++i) {
            int stats;
            String text;
            Object modelElement = this.myListModel.getElementAt(i);
            String string = text = EXTRA_ELEM.equals(modelElement) ? null : this.myModel.getFullName(modelElement);
            if (text == null || (stats = StatisticsManager.getInstance().getUseCount(new StatisticsInfo(statContext, text))) <= best) continue;
            best = stats;
            bestPosition = i;
        }
        return bestPosition;
    }

    @NonNls
    protected String statisticsContext() {
        return "choose_by_name#" + this.myModel.getPromptText() + "#" + this.myCheckBox.isSelected() + "#" + this.myTextField.getText();
    }

    private String getQualifierPattern(String pattern) {
        String[] separators = this.myModel.getSeparators();
        int lastSeparatorOccurence = 0;
        for (String separator : separators) {
            lastSeparatorOccurence = Math.max(lastSeparatorOccurence, pattern.lastIndexOf(separator));
        }
        return pattern.substring(0, lastSeparatorOccurence);
    }

    public String getNamePattern(String pattern) {
        String[] separators = this.myModel.getSeparators();
        int lastSeparatorOccurence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            lastSeparatorOccurence = Math.max(lastSeparatorOccurence, idx == -1 ? idx : idx + separator.length());
        }
        return pattern.substring(lastSeparatorOccurence);
    }

    private void clearPosponedOkAction(boolean success) {
        if (this.myPosponedOkAction != null) {
            if (success) {
                this.myPosponedOkAction.setDone();
            } else {
                this.myPosponedOkAction.setRejected();
            }
        }
        this.myPosponedOkAction = null;
    }

    protected abstract void showList();

    protected abstract void hideList();

    protected abstract void close(boolean var1);

    @Nullable
    public Object getChosenElement() {
        List<Object> elements = this.getChosenElements();
        return elements != null && elements.size() == 1 ? elements.get(0) : null;
    }

    protected List<Object> getChosenElements() {
        String[] names;
        if (this.myListIsUpToDate) {
            ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(this.myList.getSelectedValues()));
            values.remove(EXTRA_ELEM);
            return values;
        }
        String text = this.myTextField.getText();
        boolean checkBoxState = this.myCheckBox.isSelected();
        String[] stringArray = names = checkBoxState ? this.myNames[1] : this.myNames[0];
        if (names == null) {
            return Collections.emptyList();
        }
        Object uniqueElement = null;
        for (String name : names) {
            if (!text.equalsIgnoreCase(name)) continue;
            Object[] elements = this.myModel.getElementsByName(name, checkBoxState, text);
            if (elements.length > 1) {
                return Collections.emptyList();
            }
            if (elements.length == 0) continue;
            if (uniqueElement != null) {
                return Collections.emptyList();
            }
            uniqueElement = elements[0];
        }
        return uniqueElement == null ? Collections.emptyList() : Collections.singletonList(uniqueElement);
    }

    protected void choosenElementMightChange() {
    }

    private void sortByProximity(List<Object> sameNameElements) {
        Collections.sort(sameNameElements, new PathProximityComparator(this.myModel, this.myContext.get()));
    }

    private List<String> split(String s) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String token : StringUtil.tokenize((String)s, (String)StringUtil.join((String[])this.myModel.getSeparators(), (String)""))) {
            if (token.length() <= 0) continue;
            answer.add(token);
        }
        return answer.isEmpty() ? Collections.singletonList(s) : answer;
    }

    private boolean matchesQualifier(Object element, String qualifierPattern) {
        String name = this.myModel.getFullName(element);
        if (name == null) {
            return false;
        }
        List<String> suspects = this.split(name);
        List patternsAndMatchers = ContainerUtil.map2List(this.split(qualifierPattern), (Function)new Function<String, Pair<String, NameUtil.Matcher>>(){

            public Pair<String, NameUtil.Matcher> fun(String s) {
                String pattern = ChooseByNameBase.this.getNamePattern(s);
                NameUtil.Matcher matcher = ChooseByNameBase.this.buildPatternMatcher(pattern);
                return new Pair((Object)pattern, (Object)matcher);
            }
        });
        int matchPosition = 0;
        try {
            block2: for (Pair patternAndMatcher : patternsAndMatchers) {
                String pattern = (String)patternAndMatcher.first;
                NameUtil.Matcher matcher = (NameUtil.Matcher)patternAndMatcher.second;
                if (pattern.length() <= 0) continue;
                for (int j = matchPosition; j < suspects.size() - 1; ++j) {
                    String suspect = suspects.get(j);
                    if (!this.matches(pattern, matcher, suspect)) continue;
                    matchPosition = j + 1;
                    continue block2;
                }
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void getNamesByPattern(boolean checkboxState, CalcElementsThread calcElementsThread, List<String> list, String pattern) throws ProcessCanceledException {
        if (!this.isShowListForEmptyPattern()) {
            LOG.assertTrue(pattern.length() > 0);
        }
        if (pattern.startsWith("@")) {
            pattern = pattern.substring(1);
        }
        String[] names = checkboxState ? this.myNames[1] : this.myNames[0];
        NameUtil.Matcher matcher = this.buildPatternMatcher(pattern);
        try {
            for (String name : names) {
                if (calcElementsThread == null || !calcElementsThread.myCancelled) {
                    if (!this.matches(pattern, matcher, name)) continue;
                    list.add(name);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private boolean matches(String pattern, NameUtil.Matcher matcher, String name) {
        boolean matches = false;
        if (name != null) {
            if (this.myModel instanceof CustomMatcherModel) {
                if (((CustomMatcherModel)this.myModel).matches(name, pattern)) {
                    matches = true;
                }
            } else if (pattern.length() == 0 || matcher.matches(name)) {
                matches = true;
            }
        }
        return matches;
    }

    private NameUtil.Matcher buildPatternMatcher(String pattern) {
        return NameUtil.buildMatcher((String)pattern, (int)0, (boolean)true, (boolean)true, (boolean)pattern.toLowerCase().equals(pattern));
    }

    private static class PathProximityComparator
    implements Comparator<Object> {
        private final ChooseByNameModel myModel;
        private final PsiProximityComparator myProximityComparator;

        private PathProximityComparator(ChooseByNameModel model, PsiElement context) {
            this.myModel = model;
            this.myProximityComparator = new PsiProximityComparator(context);
        }

        @Override
        public int compare(Object o1, Object o2) {
            int rc = this.myProximityComparator.compare(o1, o2);
            if (rc != 0) {
                return rc;
            }
            return Comparing.compare((Comparable)((Object)this.myModel.getFullName(o1)), (Comparable)((Object)this.myModel.getFullName(o2)));
        }
    }

    private static interface CalcElementsCallback {
        public void run(Set<?> var1);
    }

    private class CalcElementsThread
    implements Runnable {
        private final String myPattern;
        private boolean myCheckboxState;
        private final CalcElementsCallback myCallback;
        private final ModalityState myModalityState;
        private Set<Object> myElements = null;
        private volatile boolean myCancelled = false;
        private final boolean myCanCancel;
        private final Alarm myShowCardAlarm = new Alarm();

        private CalcElementsThread(String pattern, boolean checkboxState, CalcElementsCallback callback, ModalityState modalityState, boolean canCancel) {
            this.myPattern = pattern;
            this.myCheckboxState = checkboxState;
            this.myCallback = callback;
            this.myModalityState = modalityState;
            this.myCanCancel = canCancel;
        }

        @Override
        public void run() {
            String cardToShow;
            this.showCard(ChooseByNameBase.SEARCHING_CARD, 200);
            final LinkedHashSet<Object> elements = new LinkedHashSet<Object>();
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    try {
                        ChooseByNameBase.this.ensureNamesLoaded(CalcElementsThread.this.myCheckboxState);
                        CalcElementsThread.this.addElementsByPattern(elements, CalcElementsThread.this.myPattern);
                        for (Object elem : elements) {
                            if (!CalcElementsThread.this.myCancelled) {
                                if (!(elem instanceof PsiElement)) continue;
                                PsiElement psiElement = (PsiElement)elem;
                                psiElement.isWritable();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                }
            };
            ApplicationManager.getApplication().runReadAction(action);
            if (this.myCancelled) {
                this.myShowCardAlarm.cancelAllRequests();
                return;
            }
            if (elements.isEmpty() && !this.myCheckboxState) {
                this.myCheckboxState = true;
                ApplicationManager.getApplication().runReadAction(action);
                cardToShow = elements.isEmpty() ? ChooseByNameBase.NOT_FOUND_CARD : ChooseByNameBase.NOT_FOUND_IN_PROJECT_CARD;
            } else {
                cardToShow = elements.isEmpty() ? ChooseByNameBase.NOT_FOUND_CARD : ChooseByNameBase.CHECK_BOX_CARD;
            }
            this.showCard(cardToShow, 0);
            this.myElements = elements;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CalcElementsThread.this.myCallback.run(CalcElementsThread.this.myElements);
                }
            }, this.myModalityState);
        }

        private void showCard(final String card, int delay) {
            this.myShowCardAlarm.cancelAllRequests();
            this.myShowCardAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ChooseByNameBase.this.myCard.show(ChooseByNameBase.this.myCardContainer, card);
                }
            }, delay, this.myModalityState);
        }

        private void addElementsByPattern(Set<Object> elementsArray, String pattern) {
            boolean empty;
            String namePattern = ChooseByNameBase.this.getNamePattern(pattern);
            String qualifierPattern = ChooseByNameBase.this.getQualifierPattern(pattern);
            boolean bl = empty = namePattern.length() == 0 || namePattern.equals("@");
            if (empty && !ChooseByNameBase.this.isShowListForEmptyPattern()) {
                return;
            }
            ArrayList namesList = new ArrayList();
            ChooseByNameBase.this.getNamesByPattern(this.myCheckboxState, this, namesList, namePattern);
            if (this.myCancelled) {
                throw new ProcessCanceledException();
            }
            Collections.sort(namesList, new MatchesComparator(pattern));
            boolean overflow = false;
            SmartList sameNameElements = new SmartList();
            block0: for (String name : namesList) {
                if (this.myCancelled) {
                    throw new ProcessCanceledException();
                }
                Object[] elements = ChooseByNameBase.this.myModel.getElementsByName(name, this.myCheckboxState, namePattern);
                if (elements.length > 1) {
                    sameNameElements.clear();
                    for (Object element : elements) {
                        if (!ChooseByNameBase.this.matchesQualifier(element, qualifierPattern)) continue;
                        sameNameElements.add(element);
                    }
                    ChooseByNameBase.this.sortByProximity((List)sameNameElements);
                    for (Object element : sameNameElements) {
                        elementsArray.add(element);
                        if (elementsArray.size() < ChooseByNameBase.this.myMaximumListSizeLimit) continue;
                        overflow = true;
                        break block0;
                    }
                    continue;
                }
                if (elements.length != 1 || !ChooseByNameBase.this.matchesQualifier(elements[0], qualifierPattern)) continue;
                elementsArray.add(elements[0]);
                if (elementsArray.size() < ChooseByNameBase.this.myMaximumListSizeLimit) continue;
                overflow = true;
                break;
            }
            if (overflow) {
                elementsArray.add(ChooseByNameBase.EXTRA_ELEM);
            }
        }

        private void cancel() {
            if (this.myCanCancel) {
                this.myCancelled = true;
            }
        }
    }

    private final class MyTextField
    extends JTextField
    implements PopupOwner {
        private final KeyStroke myCompletionKeyStroke;
        private final KeyStroke forwardStroke;
        private final KeyStroke backStroke;

        private MyTextField() {
            super(40);
            this.enableEvents(8L);
            this.myCompletionKeyStroke = this.getShortcut("CodeCompletion");
            this.forwardStroke = this.getShortcut("Forward");
            this.backStroke = this.getShortcut("Back");
        }

        private KeyStroke getShortcut(String actionCodeCompletion) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionCodeCompletion)) {
                if (!(shortcut instanceof KeyboardShortcut)) continue;
                return ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            }
            return null;
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            block7: {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                if (this.myCompletionKeyStroke != null && keyStroke.equals(this.myCompletionKeyStroke)) {
                    e.consume();
                    final String pattern = ChooseByNameBase.this.myTextField.getText();
                    String oldText = ChooseByNameBase.this.myTextField.getText();
                    int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                    ChooseByNameBase.this.myHistory.add(Pair.create((Object)oldText, (Object)oldPos));
                    Runnable postRunnable = new Runnable(){

                        @Override
                        public void run() {
                            MyTextField.this.fillInCommonPrefix(pattern);
                        }
                    };
                    ChooseByNameBase.this.rebuildList(0, 0, postRunnable, ModalityState.current());
                    return;
                }
                if (this.backStroke != null && keyStroke.equals(this.backStroke)) {
                    e.consume();
                    if (!ChooseByNameBase.this.myHistory.isEmpty()) {
                        String oldText = ChooseByNameBase.this.myTextField.getText();
                        int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                        Pair last = (Pair)ChooseByNameBase.this.myHistory.remove(ChooseByNameBase.this.myHistory.size() - 1);
                        ChooseByNameBase.this.myTextField.setText((String)last.first);
                        ChooseByNameBase.this.myFuture.add(Pair.create((Object)oldText, (Object)oldPos));
                        ChooseByNameBase.this.rebuildList(0, 0, null, ModalityState.current());
                    }
                    return;
                }
                if (this.forwardStroke != null && keyStroke.equals(this.forwardStroke)) {
                    e.consume();
                    if (!ChooseByNameBase.this.myFuture.isEmpty()) {
                        String oldText = ChooseByNameBase.this.myTextField.getText();
                        int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                        Pair next = (Pair)ChooseByNameBase.this.myFuture.remove(ChooseByNameBase.this.myFuture.size() - 1);
                        ChooseByNameBase.this.myTextField.setText((String)next.first);
                        ChooseByNameBase.this.myHistory.add(Pair.create((Object)oldText, (Object)oldPos));
                        ChooseByNameBase.this.rebuildList(0, 0, null, ModalityState.current());
                    }
                    return;
                }
                try {
                    super.processKeyEvent(e);
                }
                catch (NullPointerException e1) {
                    if (Patches.SUN_BUG_6322854) break block7;
                    throw e1;
                }
            }
        }

        private void fillInCommonPrefix(String pattern) {
            ArrayList list = new ArrayList();
            ChooseByNameBase.this.getNamesByPattern(ChooseByNameBase.this.myCheckBox.isSelected(), null, list, pattern);
            if (this.isComplexPattern(pattern)) {
                return;
            }
            String oldText = ChooseByNameBase.this.myTextField.getText();
            int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
            String commonPrefix = null;
            if (!list.isEmpty()) {
                for (String name : list) {
                    String string = name.toLowerCase();
                    if (commonPrefix == null) {
                        commonPrefix = string;
                        continue;
                    }
                    while (commonPrefix.length() > 0 && !string.startsWith(commonPrefix)) {
                        commonPrefix = commonPrefix.substring(0, commonPrefix.length() - 1);
                    }
                    if (commonPrefix.length() != 0) continue;
                    break;
                }
                commonPrefix = ((String)list.get(0)).substring(0, commonPrefix.length());
                for (int i = 1; i < list.size(); ++i) {
                    String string = ((String)list.get(i)).substring(0, commonPrefix.length());
                    if (string.equals(commonPrefix)) continue;
                    commonPrefix = commonPrefix.toLowerCase();
                    break;
                }
            }
            if (commonPrefix == null) {
                commonPrefix = "";
            }
            String newPattern = commonPrefix;
            ChooseByNameBase.this.myHistory.add(Pair.create((Object)oldText, (Object)oldPos));
            ChooseByNameBase.this.myTextField.setText(newPattern);
            ChooseByNameBase.this.myTextField.setCaretPosition(newPattern.length());
            ChooseByNameBase.this.rebuildList();
        }

        private boolean isComplexPattern(String pattern) {
            if (pattern.indexOf(42) >= 0) {
                return true;
            }
            for (String s : ChooseByNameBase.this.myModel.getSeparators()) {
                if (!pattern.contains(s)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Point getBestPopupPosition() {
            return new Point(ChooseByNameBase.this.myTextFieldPanel.getWidth(), this.getHeight());
        }

        @Override
        protected void paintComponent(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            super.paintComponent(g);
        }
    }

    private class ListUpdater {
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private static final int DELAY = 10;
        private static final int MAX_BLOCKING_TIME = 30;
        private final List<Cmd> myCommands = Collections.synchronizedList(new ArrayList());

        private ListUpdater() {
        }

        public void cancelAll() {
            this.myCommands.clear();
            this.myAlarm.cancelAllRequests();
        }

        public void appendToModel(List<Cmd> commands, final int selectionPos) {
            this.myAlarm.cancelAllRequests();
            this.myCommands.addAll(commands);
            if (this.myCommands.isEmpty() || ChooseByNameBase.this.myDisposedFlag) {
                return;
            }
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    if (ChooseByNameBase.this.myDisposedFlag) {
                        return;
                    }
                    long startTime = System.currentTimeMillis();
                    while (!ListUpdater.this.myCommands.isEmpty() && System.currentTimeMillis() - startTime < 30L) {
                        Cmd cmd = (Cmd)ListUpdater.this.myCommands.remove(0);
                        cmd.apply();
                    }
                    ChooseByNameBase.this.myList.setVisibleRowCount(Math.min(VISIBLE_LIST_SIZE_LIMIT, ChooseByNameBase.this.myList.getModel().getSize()));
                    if (!ChooseByNameBase.this.myListModel.isEmpty()) {
                        int pos = selectionPos == 0 ? ChooseByNameBase.this.detectBestStatisticalPosition() : selectionPos;
                        ListScrollingUtil.selectItem((JList)ChooseByNameBase.this.myList, (int)Math.min(pos, ChooseByNameBase.this.myListModel.size() - 1));
                    }
                    if (!ListUpdater.this.myCommands.isEmpty()) {
                        ListUpdater.this.myAlarm.addRequest((Runnable)this, 10);
                    } else {
                        ListUpdater.this.doPostponedOkIfNeeded();
                    }
                    if (!ChooseByNameBase.this.myDisposedFlag) {
                        ChooseByNameBase.this.showList();
                    }
                }
            }, 10);
        }

        private void doPostponedOkIfNeeded() {
            if (ChooseByNameBase.this.myPosponedOkAction != null && ChooseByNameBase.this.getChosenElement() != null) {
                ChooseByNameBase.this.doClose(true);
                ChooseByNameBase.this.clearPosponedOkAction(ChooseByNameBase.this.myDisposedFlag);
            }
        }
    }

    private class InsertCmd
    implements Cmd {
        private final int idx;
        private final Object element;

        private InsertCmd(int idx, Object element) {
            this.idx = idx;
            this.element = element;
        }

        @Override
        public void apply() {
            if (this.idx < ChooseByNameBase.this.myListModel.size()) {
                ChooseByNameBase.this.myListModel.add(this.idx, this.element);
            } else {
                ChooseByNameBase.this.myListModel.addElement(this.element);
            }
        }
    }

    private class RemoveCmd
    implements Cmd {
        private final int start;
        private final int end;

        private RemoveCmd(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void apply() {
            ChooseByNameBase.this.myListModel.removeRange(this.start, this.end);
        }
    }

    private static interface Cmd {
        public void apply();
    }

    public class JPanelProvider
    extends JPanel
    implements DataProvider {
        JBPopup myHint = null;
        boolean myFocusRequested = false;

        JPanelProvider() {
        }

        public Object getData(String dataId) {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return ChooseByNameBase.this.myModel.getHelpId();
            }
            if (!ChooseByNameBase.this.myListIsUpToDate) {
                return null;
            }
            if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
                Object element = ChooseByNameBase.this.getChosenElement();
                if (element instanceof PsiElement) {
                    return element;
                }
                if (element instanceof DataProvider) {
                    return ((DataProvider)element).getData(dataId);
                }
            } else if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                List<Object> chosenElements = ChooseByNameBase.this.getChosenElements();
                if (chosenElements != null) {
                    ArrayList<PsiElement> result = new ArrayList<PsiElement>();
                    for (Object element : chosenElements) {
                        if (!(element instanceof PsiElement)) continue;
                        result.add((PsiElement)element);
                    }
                    return result.toArray(new PsiElement[result.size()]);
                }
            } else if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
                return this.getBounds();
            }
            return null;
        }

        public void registerHint(JBPopup h) {
            if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
                this.myHint.cancel();
            }
            this.myHint = h;
        }

        public boolean focusRequested() {
            boolean focusRequested = this.myFocusRequested;
            this.myFocusRequested = false;
            return focusRequested;
        }

        @Override
        public void requestFocus() {
            this.myFocusRequested = true;
        }

        public void unregisterHint() {
            this.myHint = null;
        }

        public void hideHint() {
            if (this.myHint != null) {
                this.myHint.cancel();
            }
        }

        public JBPopup getHint() {
            return this.myHint;
        }

        public void updateHint(PsiElement element) {
            if (this.myHint == null || !this.myHint.isVisible()) {
                return;
            }
            PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
            if (updateProcessor != null) {
                this.myHint.cancel();
                updateProcessor.updatePopup(element);
            }
        }
    }

    private static class MatchesComparator
    implements Comparator<String> {
        private final String myOriginalPattern;

        private MatchesComparator(String originalPattern) {
            this.myOriginalPattern = originalPattern.trim();
        }

        @Override
        public int compare(String a, String b) {
            boolean aStarts = a.startsWith(this.myOriginalPattern);
            boolean bStarts = b.startsWith(this.myOriginalPattern);
            if (aStarts && bStarts) {
                return a.compareToIgnoreCase(b);
            }
            if (aStarts && !bStarts) {
                return -1;
            }
            if (bStarts && !aStarts) {
                return 1;
            }
            return a.compareToIgnoreCase(b);
        }
    }
}

