/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public abstract class IndentationParser
implements PsiParser {
    private final IElementType myEolTokenType;
    private final IElementType myIndentTokenType;
    private final IElementType myBlockElementType;

    public IndentationParser(IElementType blockElementType, IElementType eolTokenType, IElementType indentTokenType) {
        this.myBlockElementType = blockElementType;
        this.myEolTokenType = eolTokenType;
        this.myIndentTokenType = indentTokenType;
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker fileMarker = builder.mark();
        Stack<Pair> stack = new Stack<Pair>();
        stack.push(Pair.create((Object)0, (Object)builder.mark()));
        PsiBuilder.Marker startLineMarker = null;
        int currentIndent = 0;
        boolean eolSeen = false;
        while (!builder.eof()) {
            IElementType type = builder.getTokenType();
            if (type == this.myEolTokenType) {
                if (startLineMarker == null) {
                    startLineMarker = builder.mark();
                }
                eolSeen = true;
            } else if (type == this.myIndentTokenType) {
                currentIndent = builder.getTokenText().length();
            } else if (eolSeen) {
                if (startLineMarker != null) {
                    startLineMarker.rollbackTo();
                    startLineMarker = null;
                }
                while (!stack.isEmpty() && currentIndent < (Integer)((Pair)stack.peek()).first) {
                    ((PsiBuilder.Marker)((Pair)stack.pop()).second).done(this.myBlockElementType);
                }
                if (!stack.isEmpty()) {
                    Pair pair = (Pair)stack.peek();
                    if (currentIndent == (Integer)pair.first) {
                        ((PsiBuilder.Marker)((Pair)stack.pop()).second).done(this.myBlockElementType);
                        this.passEOLsAndIndents(builder);
                        stack.push(Pair.create((Object)currentIndent, (Object)builder.mark()));
                    }
                    if (currentIndent > (Integer)pair.first) {
                        this.passEOLsAndIndents(builder);
                        stack.push(Pair.create((Object)currentIndent, (Object)builder.mark()));
                    }
                }
                eolSeen = false;
                currentIndent = 0;
            }
            builder.advanceLexer();
        }
        if (startLineMarker != null) {
            startLineMarker.drop();
        }
        while (!stack.isEmpty()) {
            ((PsiBuilder.Marker)((Pair)stack.pop()).second).done(this.myBlockElementType);
        }
        fileMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/indentation/IndentationParser.parse must not return null");
        }
        return aSTNode;
    }

    private void passEOLsAndIndents(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        while (tokenType == this.myEolTokenType || tokenType == this.myIndentTokenType) {
            builder.advanceLexer();
            tokenType = builder.getTokenType();
        }
    }
}

