/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.injected.editor.RangeMarkerWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.util.text.CharArrayUtil;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentWindowImpl
extends UserDataHolderBase
implements Disposable,
DocumentWindow,
DocumentEx {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.editor.impl.injected.DocumentRangee");
    private final DocumentEx myDelegate;
    private final boolean myOneLine;
    private Place myShreds;
    private final int myPrefixLineCount;
    private final int mySuffixLineCount;

    public DocumentWindowImpl(@NotNull DocumentEx delegate, boolean oneLine, Place shreds) {
        if (delegate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.<init> must not be null");
        }
        this.myDelegate = delegate;
        this.myOneLine = oneLine;
        this.myShreds = shreds;
        this.myPrefixLineCount = Math.max(1, 1 + StringUtil.countNewLines((CharSequence)((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)0)).prefix));
        this.mySuffixLineCount = Math.max(1, 1 + StringUtil.countNewLines((CharSequence)((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)(shreds.size() - 1))).suffix));
    }

    public int getLineCount() {
        return 1 + StringUtil.countNewLines((CharSequence)this.getText());
    }

    public int getLineStartOffset(int line) {
        int newso = this.newso(line);
        return newso;
    }

    private int newso(int line) {
        LOG.assertTrue(line >= 0, (Object)line);
        String hostText = this.myDelegate.getText();
        int curLine = 0;
        int startOffset = 0;
        Iterator i$ = this.myShreds.iterator();
        while (i$.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
            RangeMarker hostRange = shred.getHostRangeMarker();
            if (!hostRange.isValid()) continue;
            startOffset += shred.prefix.length();
            if ((curLine += StringUtil.getLineBreakCount((CharSequence)shred.prefix)) >= line) {
                return startOffset;
            }
            String text = hostText.substring(hostRange.getStartOffset(), hostRange.getEndOffset());
            int i = text.indexOf(10);
            int offsetInside = 0;
            while (i != -1) {
                offsetInside += i + 1;
                if (++curLine >= line) {
                    return startOffset + offsetInside;
                }
                i = text.substring(offsetInside).indexOf(10);
            }
            startOffset += text.length();
            text = shred.suffix;
            i = text.indexOf(10);
            offsetInside = 0;
            while (i != -1) {
                offsetInside += i + 1;
                if (++curLine >= line) {
                    return startOffset + offsetInside;
                }
                i = text.substring(offsetInside).indexOf(10);
            }
            startOffset += text.length();
        }
        return startOffset;
    }

    private int oldso(int line) {
        assert (line >= 0) : line;
        return new DocumentImpl(this.getText()).getLineStartOffset(line);
    }

    public int getLineEndOffset(int line) {
        LOG.assertTrue(line >= 0, (Object)line);
        int startOffsetOfNextLine = this.getLineStartOffset(line + 1);
        return startOffsetOfNextLine == 0 || this.getText().charAt(startOffsetOfNextLine - 1) != '\n' ? startOffsetOfNextLine : startOffsetOfNextLine - 1;
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        String hostText = this.myDelegate.getText();
        Iterator i$ = this.myShreds.iterator();
        while (i$.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
            RangeMarker hostRange = shred.getHostRangeMarker();
            if (!hostRange.isValid()) continue;
            text.append(shred.prefix);
            text.append(hostText, hostRange.getStartOffset(), hostRange.getEndOffset());
            text.append(shred.suffix);
        }
        return text.toString();
    }

    @NotNull
    public CharSequence getCharsSequence() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.getCharsSequence must not return null");
        }
        return string;
    }

    @NotNull
    public char[] getChars() {
        char[] cArray = CharArrayUtil.fromSequence((CharSequence)this.getText());
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.getChars must not return null");
        }
        return cArray;
    }

    public int getTextLength() {
        int length = 0;
        Iterator i$ = this.myShreds.iterator();
        while (i$.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
            RangeMarker hostRange = shred.getHostRangeMarker();
            length += shred.prefix.length();
            length += hostRange.getEndOffset() - hostRange.getStartOffset();
            length += shred.suffix.length();
        }
        return length;
    }

    public int getLineNumber(int offset) {
        int lineNumber = 0;
        String hostText = this.myDelegate.getText();
        Iterator i$ = this.myShreds.iterator();
        while (i$.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
            String prefix = shred.prefix;
            String suffix = shred.suffix;
            lineNumber += StringUtil.getLineBreakCount((CharSequence)prefix.substring(0, Math.min(offset, prefix.length())));
            if (offset < prefix.length()) {
                return lineNumber;
            }
            offset -= prefix.length();
            RangeMarker currentRange = shred.getHostRangeMarker();
            if (!currentRange.isValid()) continue;
            int rangeLength = currentRange.getEndOffset() - currentRange.getStartOffset();
            String rangeText = hostText.substring(currentRange.getStartOffset(), currentRange.getEndOffset());
            lineNumber += StringUtil.getLineBreakCount((CharSequence)rangeText.substring(0, Math.min(offset, rangeLength)));
            if (offset < rangeLength) {
                return lineNumber;
            }
            lineNumber += StringUtil.getLineBreakCount((CharSequence)suffix.substring(0, Math.min(offset -= rangeLength, suffix.length())));
            if (offset < suffix.length()) {
                return lineNumber;
            }
            offset -= suffix.length();
        }
        lineNumber = this.getLineCount() - 1;
        return lineNumber < 0 ? 0 : lineNumber;
    }

    public TextRange getHostRange(int hostOffset) {
        Iterator i$ = this.myShreds.iterator();
        while (i$.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
            RangeMarker currentRange = shred.getHostRangeMarker();
            TextRange textRange = InjectedLanguageUtil.toTextRange(currentRange);
            if (!textRange.grown(1).contains(hostOffset)) continue;
            return textRange;
        }
        return null;
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.insertString must not be null");
        }
        LOG.assertTrue(offset >= ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)0)).prefix.length());
        LOG.assertTrue(offset <= this.getTextLength() - ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)(this.myShreds.size() - 1))).suffix.length());
        if (this.isOneLine()) {
            s = StringUtil.replace((String)((Object)s).toString(), (String)"\n", (String)"");
        }
        this.myDelegate.insertString(this.injectedToHost(offset), s);
    }

    public void deleteString(int startOffset, int endOffset) {
        assert (this.intersectWithEditable(new TextRange(startOffset, startOffset)) != null);
        assert (this.intersectWithEditable(new TextRange(endOffset, endOffset)) != null);
        ArrayList<TextRange> hostRangesToDelete = new ArrayList<TextRange>(this.myShreds.size());
        int offset = startOffset;
        int curRangeStart = 0;
        Iterator i$ = this.myShreds.iterator();
        while (i$.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
            if (offset < (curRangeStart += shred.prefix.length())) {
                offset = curRangeStart;
            }
            if (offset >= endOffset) break;
            RangeMarker hostRange = shred.getHostRangeMarker();
            if (!hostRange.isValid()) continue;
            int hostRangeLength = hostRange.getEndOffset() - hostRange.getStartOffset();
            TextRange range = TextRange.from((int)curRangeStart, (int)hostRangeLength);
            if (range.contains(offset)) {
                TextRange rangeToDelete = new TextRange(offset, Math.min(range.getEndOffset(), endOffset));
                hostRangesToDelete.add(rangeToDelete.shiftRight(hostRange.getStartOffset() - curRangeStart));
                offset = rangeToDelete.getEndOffset();
            }
            curRangeStart += hostRangeLength;
            curRangeStart += shred.suffix.length();
        }
        int delta = 0;
        for (TextRange hostRangeToDelete : hostRangesToDelete) {
            this.myDelegate.deleteString(hostRangeToDelete.getStartOffset() + delta, hostRangeToDelete.getEndOffset() + delta);
            delta -= hostRangeToDelete.getLength();
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.replaceString must not be null");
        }
        if (this.isOneLine()) {
            s = StringUtil.replace((String)((Object)s).toString(), (String)"\n", (String)"");
        }
        CharSequence chars = this.getCharsSequence();
        CharSequence toDelete = chars.subSequence(startOffset, endOffset);
        int perfixLength = StringUtil.commonPrefixLength((CharSequence)s, (CharSequence)toDelete);
        int suffixLength = StringUtil.commonSuffixLength((CharSequence)toDelete.subSequence(perfixLength, toDelete.length()), (CharSequence)s.subSequence(perfixLength, s.length()));
        s = s.subSequence(perfixLength, s.length() - suffixLength);
        this.doReplaceString(startOffset += perfixLength, endOffset -= suffixLength, s);
    }

    private void doReplaceString(int startOffset, int endOffset, CharSequence s) {
        assert (this.intersectWithEditable(new TextRange(startOffset, startOffset)) != null);
        assert (this.intersectWithEditable(new TextRange(endOffset, endOffset)) != null);
        ArrayList<Pair> hostRangesToModify = new ArrayList<Pair>(this.myShreds.size());
        int offset = startOffset;
        int curRangeStart = 0;
        for (int i = 0; i < this.myShreds.size(); ++i) {
            RangeMarker hostRange;
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(i);
            if (offset < (curRangeStart += shred.prefix.length())) {
                offset = curRangeStart;
            }
            if (!(hostRange = shred.getHostRangeMarker()).isValid()) continue;
            int hostRangeLength = hostRange.getEndOffset() - hostRange.getStartOffset();
            TextRange range = TextRange.from((int)curRangeStart, (int)hostRangeLength);
            if (range.contains(offset) || range.getEndOffset() == offset) {
                TextRange rangeToModify = new TextRange(offset, Math.min(range.getEndOffset(), endOffset));
                TextRange hostRangeToModify = rangeToModify.shiftRight(hostRange.getStartOffset() - curRangeStart);
                CharSequence toReplace = i == this.myShreds.size() - 1 || range.getEndOffset() + shred.suffix.length() >= endOffset ? s : s.subSequence(0, Math.min(hostRangeToModify.getLength(), s.length()));
                s = toReplace == s ? "" : s.subSequence(toReplace.length(), s.length());
                hostRangesToModify.add(Pair.create((Object)hostRangeToModify, (Object)toReplace));
                offset = rangeToModify.getEndOffset();
            }
            curRangeStart += hostRangeLength;
            if ((curRangeStart += shred.suffix.length()) >= endOffset) break;
        }
        int delta = 0;
        for (Pair pair : hostRangesToModify) {
            TextRange hostRange = (TextRange)pair.getFirst();
            CharSequence replace = (CharSequence)pair.getSecond();
            this.myDelegate.replaceString(hostRange.getStartOffset() + delta, hostRange.getEndOffset() + delta, replace);
            delta -= hostRange.getLength() - replace.length();
        }
    }

    public boolean isWritable() {
        return this.myDelegate.isWritable();
    }

    public long getModificationStamp() {
        return this.myDelegate.getModificationStamp();
    }

    public void fireReadOnlyModificationAttempt() {
        this.myDelegate.fireReadOnlyModificationAttempt();
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.addDocumentListener must not be null");
        }
        this.myDelegate.addDocumentListener(listener);
    }

    public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.addDocumentListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.addDocumentListener must not be null");
        }
        this.myDelegate.addDocumentListener(listener, parentDisposable);
    }

    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.removeDocumentListener must not be null");
        }
        this.myDelegate.removeDocumentListener(listener);
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        TextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeMarker hostMarker = this.myDelegate.createRangeMarker(hostRange);
        RangeMarkerWindow rangeMarkerWindow = new RangeMarkerWindow(this, (RangeMarkerEx)hostMarker);
        if (rangeMarkerWindow == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.createRangeMarker must not return null");
        }
        return rangeMarkerWindow;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        RangeMarker rangeMarker;
        if (!surviveOnExternalChange) {
            rangeMarker = this.createRangeMarker(startOffset, endOffset);
            if (rangeMarker == null) throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.createRangeMarker must not return null");
            return rangeMarker;
        }
        TextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        rangeMarker = this.myDelegate.createRangeMarker(hostRange.getStartOffset(), hostRange.getEndOffset(), surviveOnExternalChange);
        if (rangeMarker != null) return rangeMarker;
        throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.createRangeMarker must not return null");
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        MarkupModelWindow markupModelWindow = new MarkupModelWindow((MarkupModelEx)this.myDelegate.getMarkupModel(), this);
        if (markupModelWindow == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.getMarkupModel must not return null");
        }
        return markupModelWindow;
    }

    @NotNull
    public MarkupModel getMarkupModel(Project project) {
        MarkupModelWindow markupModelWindow = new MarkupModelWindow((MarkupModelEx)this.myDelegate.getMarkupModel(project), this);
        if (markupModelWindow == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.getMarkupModel must not return null");
        }
        return markupModelWindow;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.addPropertyChangeListener must not be null");
        }
        this.myDelegate.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.removePropertyChangeListener must not be null");
        }
        this.myDelegate.removePropertyChangeListener(listener);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.myDelegate.setReadOnly(isReadOnly);
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        TextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeMarker rangeMarker = this.myDelegate.createGuardedBlock(hostRange.getStartOffset(), hostRange.getEndOffset());
        if (rangeMarker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.createGuardedBlock must not return null");
        }
        return rangeMarker;
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.removeGuardedBlock must not be null");
        }
        this.myDelegate.removeGuardedBlock(block);
    }

    public RangeMarker getOffsetGuard(int offset) {
        return this.myDelegate.getOffsetGuard(this.injectedToHost(offset));
    }

    public RangeMarker getRangeGuard(int startOffset, int endOffset) {
        TextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        return this.myDelegate.getRangeGuard(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    public void startGuardedBlockChecking() {
        this.myDelegate.startGuardedBlockChecking();
    }

    public void stopGuardedBlockChecking() {
        this.myDelegate.stopGuardedBlockChecking();
    }

    public void setCyclicBufferSize(int bufferSize) {
        this.myDelegate.setCyclicBufferSize(bufferSize);
    }

    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.setText must not be null");
        }
        LOG.assertTrue(((Object)text).toString().startsWith(((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)0)).prefix));
        LOG.assertTrue(((Object)text).toString().endsWith(((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)(this.myShreds.size() - 1))).suffix));
        if (this.isOneLine()) {
            text = StringUtil.replace((String)((Object)text).toString(), (String)"\n", (String)"");
        }
        String[] changes = this.calculateMinEditSequence(((Object)text).toString());
        assert (changes.length == this.myShreds.size());
        for (int i = 0; i < changes.length; ++i) {
            String change = changes[i];
            if (change == null) continue;
            RangeMarker hostRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
            this.myDelegate.replaceString(hostRange.getStartOffset(), hostRange.getEndOffset(), change);
        }
    }

    @NotNull
    public RangeMarker[] getHostRanges() {
        RangeMarker[] markers = new RangeMarker[this.myShreds.size()];
        for (int i = 0; i < this.myShreds.size(); ++i) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(i);
            markers[i] = shred.getHostRangeMarker();
        }
        if (markers == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.getHostRanges must not return null");
        }
        return markers;
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.createRangeMarker must not be null");
        }
        TextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(textRange));
        RangeMarker hostMarker = this.myDelegate.createRangeMarker(hostRange);
        RangeMarkerWindow rangeMarkerWindow = new RangeMarkerWindow(this, (RangeMarkerEx)hostMarker);
        if (rangeMarkerWindow == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.createRangeMarker must not return null");
        }
        return rangeMarkerWindow;
    }

    @Override
    public void stripTrailingSpaces(boolean inChangedLinesOnly) {
        this.myDelegate.stripTrailingSpaces(inChangedLinesOnly);
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        this.myDelegate.setStripTrailingSpacesEnabled(isEnabled);
    }

    public int getLineSeparatorLength(int line) {
        return this.myDelegate.getLineSeparatorLength(this.injectedToHostLine(line));
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.myDelegate.createLineIterator();
        if (lineIterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.createLineIterator must not return null");
        }
        return lineIterator;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myDelegate.setModificationStamp(modificationStamp);
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.addEditReadOnlyListener must not be null");
        }
        this.myDelegate.addEditReadOnlyListener(listener);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.removeEditReadOnlyListener must not be null");
        }
        this.myDelegate.removeEditReadOnlyListener(listener);
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.replaceText must not be null");
        }
        this.setText(chars);
        this.myDelegate.setModificationStamp(newModificationStamp);
    }

    @Override
    public int getListenersCount() {
        return this.myDelegate.getListenersCount();
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myDelegate.suppressGuardedExceptions();
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myDelegate.unSuppressGuardedExceptions();
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myDelegate.isInEventsHandling();
    }

    @Override
    public void clearLineModificationFlags() {
    }

    @Override
    public void removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.removeRangeMarker must not be null");
        }
        this.myDelegate.removeRangeMarker(((RangeMarkerWindow)rangeMarker).getDelegate());
    }

    @Override
    public void addRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.addRangeMarker must not be null");
        }
        this.myDelegate.addRangeMarker(((RangeMarkerWindow)rangeMarker).getDelegate());
    }

    @Override
    public boolean isInBulkUpdate() {
        return false;
    }

    @Override
    public void setInBulkUpdate(boolean value) {
    }

    @NotNull
    public DocumentEx getDelegate() {
        DocumentEx documentEx = this.myDelegate;
        if (documentEx == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.getDelegate must not return null");
        }
        return documentEx;
    }

    public int hostToInjected(int hostOffset) {
        if (hostOffset < ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker().getStartOffset()) {
            return ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)0)).prefix.length();
        }
        int offset = 0;
        for (int i = 0; i < this.myShreds.size(); ++i) {
            RangeMarker nextRange;
            offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)i)).prefix.length();
            RangeMarker currentRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
            RangeMarker rangeMarker = nextRange = i == this.myShreds.size() - 1 ? null : ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i + 1)).getHostRangeMarker();
            if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                if (hostOffset >= currentRange.getEndOffset()) {
                    hostOffset = currentRange.getEndOffset();
                }
                return offset + hostOffset - currentRange.getStartOffset();
            }
            offset += currentRange.getEndOffset() - currentRange.getStartOffset();
            offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)i)).suffix.length();
        }
        return this.getTextLength() - ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)(this.myShreds.size() - 1))).suffix.length();
    }

    public int injectedToHost(int offset) {
        int offsetInRightFragment;
        int offsetInLeftFragment = this.injectedToHost(offset, true);
        if (offsetInLeftFragment == (offsetInRightFragment = this.injectedToHost(offset, false))) {
            return offsetInLeftFragment;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        if (editor != null) {
            int caret = editor.getCaretModel().getOffset();
            return Math.abs(caret - offsetInLeftFragment) < Math.abs(caret - offsetInRightFragment) ? offsetInLeftFragment : offsetInRightFragment;
        }
        return offsetInLeftFragment;
    }

    private int injectedToHost(int offset, boolean preferLeftFragment) {
        if (offset < ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)0)).prefix.length()) {
            return ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker().getStartOffset();
        }
        int prevEnd = 0;
        for (int i = 0; i < this.myShreds.size(); ++i) {
            RangeMarker currentRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
            int length = currentRange.getEndOffset() - currentRange.getStartOffset();
            if ((offset -= ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)i)).prefix.length()) < 0) {
                return preferLeftFragment ? prevEnd : currentRange.getStartOffset() - 1;
            }
            if (offset == 0) {
                return preferLeftFragment && i != 0 ? prevEnd : currentRange.getStartOffset();
            }
            if (offset < length || offset == length && preferLeftFragment) {
                return currentRange.getStartOffset() + offset;
            }
            offset -= length;
            offset -= ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)i)).suffix.length();
            prevEnd = currentRange.getEndOffset();
        }
        return ((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getHostRangeMarker().getEndOffset();
    }

    @NotNull
    public TextRange injectedToHost(@NotNull TextRange injected) {
        if (injected == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.injectedToHost must not be null");
        }
        ProperTextRange.assertProperRange((TextRange)injected);
        int start = this.injectedToHost(injected.getStartOffset(), false);
        int end = this.injectedToHost(injected.getEndOffset(), true);
        if (end < start) {
            end = this.injectedToHost(injected.getEndOffset(), false);
        }
        ProperTextRange properTextRange = new ProperTextRange(start, end);
        if (properTextRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.injectedToHost must not return null");
        }
        return properTextRange;
    }

    public int injectedToHostLine(int line) {
        if (line < this.myPrefixLineCount) {
            return this.myDelegate.getLineNumber(((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker().getStartOffset());
        }
        int lineCount = this.getLineCount();
        if (line > lineCount - this.mySuffixLineCount) {
            return lineCount;
        }
        int offset = this.getLineStartOffset(line);
        int hostOffset = this.injectedToHost(offset);
        return this.myDelegate.getLineNumber(hostOffset);
    }

    public boolean containsRange(int start, int end) {
        if (end - start > ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker().getEndOffset() - ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker().getStartOffset()) {
            return false;
        }
        Iterator i$ = this.myShreds.iterator();
        while (i$.hasNext()) {
            TextRange textRange;
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
            RangeMarker hostRange = shred.getHostRangeMarker();
            if (!hostRange.isValid() || !(textRange = InjectedLanguageUtil.toTextRange(hostRange)).contains((TextRange)new ProperTextRange(start, end))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @Nullable
    public TextRange intersectWithEditable(@NotNull TextRange rangeToEdit) {
        if (rangeToEdit == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.intersectWithEditable must not be null");
        }
        int offset = 0;
        int startOffset = -1;
        int endOffset = -1;
        Iterator i$ = this.myShreds.iterator();
        while (i$.hasNext()) {
            int length;
            ProperTextRange intersection;
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
            RangeMarker hostRange = shred.getHostRangeMarker();
            if ((intersection = new ProperTextRange(offset += shred.prefix.length(), offset + (length = hostRange.getEndOffset() - hostRange.getStartOffset())).intersection(rangeToEdit)) != null) {
                if (startOffset == -1) {
                    startOffset = intersection.getStartOffset();
                }
                endOffset = intersection.getEndOffset();
            }
            offset += length;
            offset += shred.suffix.length();
        }
        if (startOffset == -1) {
            return null;
        }
        return new ProperTextRange(startOffset, endOffset);
    }

    boolean intersects(DocumentWindowImpl documentWindow) {
        int i = 0;
        int j = 0;
        while (i < this.myShreds.size() && j < documentWindow.myShreds.size()) {
            RangeMarker range = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
            RangeMarker otherRange = ((PsiLanguageInjectionHost.Shred)documentWindow.myShreds.get(j)).getHostRangeMarker();
            if (InjectedLanguageUtil.toTextRange(range).intersects(InjectedLanguageUtil.toTextRange(otherRange))) {
                return true;
            }
            if (range.getEndOffset() > otherRange.getStartOffset()) {
                ++i;
                continue;
            }
            if (range.getStartOffset() < otherRange.getEndOffset()) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        return false;
    }

    public String[] calculateMinEditSequence(String newText) {
        String[] result = new String[this.myShreds.size()];
        String hostText = this.myDelegate.getText();
        this.calculateMinEditSequence(hostText, newText, result, 0, result.length - 1);
        for (int i = 0; i < result.length; ++i) {
            String change = result[i];
            if (change == null) continue;
            String prefix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)i)).prefix;
            String suffix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)i)).suffix;
            assert (change.startsWith(prefix)) : change + "/" + prefix;
            assert (change.endsWith(suffix)) : change + "/" + suffix;
            result[i] = StringUtil.trimEnd((String)StringUtil.trimStart((String)change, (String)prefix), (String)suffix);
        }
        return result;
    }

    private String getRangeText(String hostText, int hostNum) {
        PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(hostNum);
        return shred.prefix + hostText.substring(shred.getHostRangeMarker().getStartOffset(), shred.getHostRangeMarker().getEndOffset()) + shred.suffix;
    }

    private void calculateMinEditSequence(String hostText, String newText, String[] result, int i, int j) {
        String rangeText1 = this.getRangeText(hostText, i);
        if (i == j) {
            result[i] = rangeText1.equals(newText) ? null : newText;
            return;
        }
        if (StringUtil.startsWith((CharSequence)newText, (CharSequence)rangeText1)) {
            result[i] = null;
            this.calculateMinEditSequence(hostText, newText.substring(rangeText1.length()), result, i + 1, j);
            return;
        }
        String rangeText2 = this.getRangeText(hostText, j);
        if (StringUtil.endsWith((CharSequence)newText, (CharSequence)rangeText2)) {
            result[j] = null;
            this.calculateMinEditSequence(hostText, newText.substring(0, newText.length() - rangeText2.length()), result, i, j - 1);
            return;
        }
        if (i + 1 == j) {
            String commonPrefix;
            String suffix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)i)).suffix;
            String prefix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get((int)j)).prefix;
            String separator = suffix + prefix;
            if (separator.length() != 0) {
                int sep = newText.indexOf(separator);
                assert (sep != -1);
                result[i] = newText.substring(0, sep + suffix.length());
                result[j] = newText.substring(sep + suffix.length() + prefix.length(), newText.length());
                return;
            }
            result[i] = commonPrefix = StringUtil.commonPrefix((String)rangeText1, (String)newText);
            result[j] = newText.substring(commonPrefix.length());
            return;
        }
        String middleText = this.getRangeText(hostText, i + 1);
        int m = newText.indexOf(middleText);
        if (m != -1) {
            result[i] = newText.substring(0, m);
            result[i + 1] = null;
            this.calculateMinEditSequence(hostText, newText.substring(m + middleText.length(), newText.length()), result, i + 2, j);
            return;
        }
        middleText = this.getRangeText(hostText, j - 1);
        m = newText.lastIndexOf(middleText);
        if (m != -1) {
            result[j] = newText.substring(m + middleText.length());
            result[j - 1] = null;
            this.calculateMinEditSequence(hostText, newText.substring(0, m), result, i, j - 2);
            return;
        }
        result[i] = "";
        result[j] = "";
        this.calculateMinEditSequence(hostText, newText, result, i + 1, j - 1);
    }

    public boolean areRangesEqual(@NotNull DocumentWindow otherd) {
        if (otherd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/DocumentWindowImpl.areRangesEqual must not be null");
        }
        DocumentWindowImpl window = (DocumentWindowImpl)otherd;
        if (this.myShreds.size() != window.myShreds.size()) {
            return false;
        }
        for (int i = 0; i < this.myShreds.size(); ++i) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(i);
            PsiLanguageInjectionHost.Shred otherShred = (PsiLanguageInjectionHost.Shred)window.myShreds.get(i);
            if (!shred.prefix.equals(otherShred.prefix)) {
                return false;
            }
            if (!shred.suffix.equals(otherShred.suffix)) {
                return false;
            }
            RangeMarker hostRange = shred.getHostRangeMarker();
            RangeMarker other = otherShred.getHostRangeMarker();
            if (hostRange.getStartOffset() != other.getStartOffset()) {
                return false;
            }
            if (hostRange.getEndOffset() == other.getEndOffset()) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.myShreds.isValid();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DocumentWindowImpl)) {
            return false;
        }
        DocumentWindowImpl window = (DocumentWindowImpl)o;
        return this.myDelegate.equals(window.getDelegate()) && this.areRangesEqual(window);
    }

    public int hashCode() {
        return ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker().getStartOffset();
    }

    public boolean isOneLine() {
        return this.myOneLine;
    }

    public void dispose() {
        Iterator i$ = this.myShreds.iterator();
        while (i$.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
            RangeMarker rangeMarker = shred.getHostRangeMarker();
            this.myDelegate.removeRangeMarker((RangeMarkerEx)rangeMarker);
        }
    }

    public void setShreds(Place shreds) {
        this.myShreds = shreds;
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/DocumentWindowImpl.getGuardedBlocks must not return null");
        }
        return list;
    }
}

