/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.pratt;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.LangBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.pratt.MutableMarker;
import com.intellij.lang.pratt.PathPattern;
import com.intellij.lang.pratt.PrattBuilder;
import com.intellij.lang.pratt.PrattBuilderFacade;
import com.intellij.lang.pratt.PrattRegistry;
import com.intellij.lang.pratt.TokenParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrattBuilderImpl
extends PrattBuilder
implements PrattBuilderFacade {
    private final PrattBuilder myParentBuilder;
    private final PsiBuilder myBuilder;
    private final LinkedList<IElementType> myLeftSiblings = new LinkedList();
    private boolean myParsingStarted;
    private String myExpectedMessage;
    private int myPriority = Integer.MIN_VALUE;
    private MutableMarker myStartMarker;

    private PrattBuilderImpl(PsiBuilder builder, PrattBuilder parent) {
        this.myBuilder = builder;
        this.myParentBuilder = parent;
    }

    public static PrattBuilderImpl createBuilder(PsiBuilder builder) {
        return new PrattBuilderImpl(builder, null);
    }

    @Override
    public PrattBuilderFacade expecting(String expectedMessage) {
        this.myExpectedMessage = expectedMessage;
        return this;
    }

    @Override
    public PrattBuilderFacade withLowestPriority(int priority) {
        this.myPriority = priority;
        return this;
    }

    @Override
    public Lexer getLexer() {
        return ((PsiBuilderImpl)this.myBuilder).getLexer();
    }

    @Override
    public void setTokenTypeRemapper(@Nullable ITokenTypeRemapper remapper) {
        this.myBuilder.setTokenTypeRemapper(remapper);
    }

    @Override
    public MutableMarker mark() {
        return new MutableMarker(this.myLeftSiblings, this.myBuilder.mark(), this.myLeftSiblings.size());
    }

    @Override
    @Nullable
    public IElementType parse() {
        this.checkParsed();
        return this.myLeftSiblings.size() != 1 ? null : this.myLeftSiblings.getLast();
    }

    @Override
    protected PrattBuilderFacade createChildBuilder() {
        assert (this.myParsingStarted);
        return new PrattBuilderImpl(this.myBuilder, this){

            @Override
            protected void doParse() {
                super.doParse();
                PrattBuilderImpl.this.myLeftSiblings.addAll(this.getResultTypes());
            }
        };
    }

    protected void doParse() {
        if (this.isEof()) {
            this.error(this.myExpectedMessage != null ? this.myExpectedMessage : LangBundle.message("unexpected.eof", new Object[0]));
            return;
        }
        TokenParser parser = this.findParser();
        if (parser == null) {
            this.error(this.myExpectedMessage != null ? this.myExpectedMessage : LangBundle.message("unexpected.token", new Object[0]));
            return;
        }
        this.myStartMarker = this.mark();
        while (!this.isEof()) {
            int startOffset = this.myBuilder.getCurrentOffset();
            if (!parser.parseToken(this)) break;
            assert (startOffset < this.myBuilder.getCurrentOffset()) : "Endless loop on " + this.getTokenType();
            parser = this.findParser();
            if (parser != null) continue;
            break;
        }
        this.myStartMarker.drop();
    }

    @Nullable
    private TokenParser findParser() {
        IElementType tokenType = this.getTokenType();
        for (Trinity<Integer, PathPattern, TokenParser> trinity : PrattRegistry.getParsers(tokenType)) {
            if ((Integer)trinity.first <= this.myPriority || !((PathPattern)trinity.second).accepts(this)) continue;
            return (TokenParser)trinity.third;
        }
        return null;
    }

    @Override
    public void advance() {
        this.myLeftSiblings.addLast(this.getTokenType());
        this.myBuilder.advanceLexer();
    }

    @Override
    public void error(String errorText) {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.error(errorText);
        marker.drop();
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        return this.myBuilder.getTokenType();
    }

    @Override
    @Nullable
    public String getTokenText() {
        return this.myBuilder.getTokenText();
    }

    @Override
    public void reduce(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/pratt/PrattBuilderImpl.reduce must not be null");
        }
        this.myStartMarker.finish(type);
        this.myStartMarker = this.myStartMarker.precede();
    }

    @Override
    @NotNull
    public LinkedList<IElementType> getResultTypes() {
        this.checkParsed();
        LinkedList<IElementType> linkedList = this.myLeftSiblings;
        if (linkedList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/pratt/PrattBuilderImpl.getResultTypes must not return null");
        }
        return linkedList;
    }

    private void checkParsed() {
        if (!this.myParsingStarted) {
            this.myParsingStarted = true;
            this.doParse();
        }
    }

    @Override
    public PrattBuilder getParent() {
        return this.myParentBuilder;
    }

    @Override
    public int getPriority() {
        return this.myPriority;
    }

    @Override
    public int getCurrentOffset() {
        return this.myBuilder.getCurrentOffset();
    }
}

