/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.ide.DataManager;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.notification.impl.ui.NotificationComponent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.impl.status.StatusBarImpl;
import com.intellij.openapi.wm.impl.status.StatusBarPatch;
import com.intellij.openapi.wm.impl.status.StatusBarTooltipper;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class IdeNotificationArea
implements StatusBarPatch {
    private NotificationComponent myNotificationComponent = new NotificationComponent(this);

    public IdeNotificationArea(StatusBarImpl statusBar) {
        StatusBarTooltipper.install(this, statusBar);
    }

    @Override
    public JComponent getComponent() {
        return this.myNotificationComponent;
    }

    @Override
    @Nullable
    public String updateStatusBar(Editor selected, JComponent componentSelected) {
        NotificationsManagerImpl manager = NotificationsManagerImpl.getNotificationsManagerImpl();
        if (manager.hasNotifications(this.getProject())) {
            int count = manager.count(this.getProject());
            return String.format("%s notification%s pending", count, count == 1 ? "" : "s");
        }
        return null;
    }

    @Override
    public void clear() {
    }

    @Nullable
    public Project getProject() {
        return (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myNotificationComponent));
    }
}

