/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.changes.Change;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.command.impl.ChangeRangeRevertionVisitor;
import java.io.IOException;

public class ChangeRange {
    private final IdeaGateway myGateway;
    private final LocalVcs myVcs;
    private final Change myFromChange;
    private final Change myToChange;

    public ChangeRange(IdeaGateway gw, LocalVcs vcs, Change change) {
        this(gw, vcs, change, change);
    }

    public ChangeRange(IdeaGateway gw, LocalVcs vcs, Change from, Change to) {
        this.myGateway = gw;
        this.myVcs = vcs;
        this.myFromChange = from;
        this.myToChange = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeRange revert(ChangeRange reverse) throws IOException {
        final Change[] first = new Change[]{null};
        final Change[] last = new Change[]{null};
        LocalVcs.Listener l = new LocalVcs.Listener(){

            @Override
            public void onChange(Change c) {
                if (first[0] == null) {
                    first[0] = c;
                }
                last[0] = c;
            }
        };
        this.myVcs.addListener(l);
        try {
            this.myVcs.acceptWrite(new ChangeRangeRevertionVisitor(this.myGateway, this.myToChange, this.myFromChange));
        }
        finally {
            this.myVcs.removeListener(l);
        }
        if (reverse != null) {
            if (first[0] == null) {
                first[0] = reverse.myFromChange;
            }
            if (last[0] == null) {
                last[0] = reverse.myToChange;
            }
        }
        return new ChangeRange(this.myGateway, this.myVcs, first[0], last[0]);
    }
}

