/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.ProjectStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.options.StreamProvider;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.fs.IFile;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultProjectStoreImpl
extends ProjectStoreImpl {
    @Nullable
    private final Element myElement;
    private final ProjectManagerImpl myProjectManager;
    @NonNls
    private static final String ROOT_TAG_NAME = "defaultProject";

    public DefaultProjectStoreImpl(ProjectImpl project, ProjectManagerImpl projectManager) {
        super(project);
        this.myProjectManager = projectManager;
        this.myElement = projectManager.getDefaultProjectRootElement();
    }

    @Nullable
    Element getStateCopy() {
        Element element = this.myProjectManager.getDefaultProjectRootElement();
        return element != null ? (Element)element.clone() : null;
    }

    @Override
    protected StateStorageManager createStateStorageManager() {
        Document _d = null;
        if (this.myElement != null) {
            this.myElement.detach();
            _d = new Document(this.myElement);
        }
        ComponentManager componentManager = this.getComponentManager();
        PathMacroManager pathMacroManager = PathMacroManager.getInstance(componentManager);
        final Document document = _d;
        final XmlElementStorage storage = new XmlElementStorage(pathMacroManager.createTrackingSubstitutor(), (Disposable)componentManager, ROOT_TAG_NAME, StreamProvider.DEFAULT, "", ComponentRoamingManager.getInstance(), ComponentVersionProvider.EMPTY){

            @Override
            @Nullable
            protected Document loadDocument() throws StateStorage.StateStorageException {
                return document;
            }

            @Override
            protected XmlElementStorage.MySaveSession createSaveSession(XmlElementStorage.MyExternalizationSession externalizationSession) {
                return new DefaultSaveSession(externalizationSession);
            }

            @Override
            @NotNull
            protected XmlElementStorage.StorageData createStorageData() {
                BaseFileConfigurableStoreImpl.BaseStorageData baseStorageData = new BaseFileConfigurableStoreImpl.BaseStorageData(DefaultProjectStoreImpl.ROOT_TAG_NAME);
                if (baseStorageData == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$1.createStorageData must not return null");
                }
                return baseStorageData;
            }

            class DefaultSaveSession
            extends XmlElementStorage.MySaveSession {
                public DefaultSaveSession(XmlElementStorage.MyExternalizationSession externalizationSession) {
                    super(this, externalizationSession);
                }

                @Override
                protected void doSave() throws StateStorage.StateStorageException {
                    DefaultProjectStoreImpl.this.myProjectManager.setDefaultProjectRootElement(this.getDocumentToSave().getRootElement());
                }

                public Collection<IFile> getStorageFilesToSave() throws StateStorage.StateStorageException {
                    return Collections.emptyList();
                }

                public List<IFile> getAllStorageFiles() {
                    return Collections.emptyList();
                }
            }
        };
        return new StateStorageManager(){

            @Override
            public void addMacro(String macro, String expansion) {
                throw new UnsupportedOperationException("Method addMacro not implemented in " + this.getClass());
            }

            @Override
            @Nullable
            public TrackingPathMacroSubstitutor getMacroSubstitutor() {
                return null;
            }

            @Override
            @Nullable
            public StateStorage getStateStorage(@NotNull Storage storageSpec) throws StateStorage.StateStorageException {
                if (storageSpec == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2.getStateStorage must not be null");
                }
                return storage;
            }

            @Override
            @Nullable
            public StateStorage getFileStateStorage(String fileName) {
                return storage;
            }

            @Override
            public void clearStateStorage(@NotNull String file) {
                if (file == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$2.clearStateStorage must not be null");
                }
            }

            @Override
            public StateStorageManager.ExternalizationSession startExternalization() {
                return new MyExternalizationSession(storage);
            }

            @Override
            public StateStorageManager.SaveSession startSave(StateStorageManager.ExternalizationSession externalizationSession) {
                return new MySaveSession(storage, externalizationSession);
            }

            @Override
            public void finishSave(StateStorageManager.SaveSession saveSession) {
                storage.finishSave(((MySaveSession)saveSession).saveSession);
            }

            @Override
            public String expandMacroses(String file) {
                throw new UnsupportedOperationException("Method expandMacroses not implemented in " + this.getClass());
            }

            @Override
            @Nullable
            public StateStorage getOldStorage(Object component, String componentName, StateStorageOperation operation) throws StateStorage.StateStorageException {
                return storage;
            }

            @Override
            public void registerStreamProvider(StreamProvider streamProvider, RoamingType type) {
                throw new UnsupportedOperationException("Method registerStreamProvider not implemented in " + this.getClass());
            }

            @Override
            public void unregisterStreamProvider(StreamProvider streamProvider, RoamingType roamingType) {
                throw new UnsupportedOperationException("Method unregisterStreamProvider not implemented in " + this.getClass());
            }

            @Override
            public StreamProvider[] getStreamProviders(RoamingType roamingType) {
                throw new UnsupportedOperationException("Method getStreamProviders not implemented in " + this.getClass());
            }

            @Override
            public Collection<String> getStorageFileNames() {
                throw new UnsupportedOperationException("Method getStorageFileNames not implemented in " + this.getClass());
            }

            @Override
            public void reset() {
            }
        };
    }

    @Override
    public String getLocation() {
        throw new UnsupportedOperationException("Method getLocation not implemented in " + this.getClass());
    }

    @Override
    public void load() throws IOException, StateStorage.StateStorageException {
        if (this.myElement == null) {
            return;
        }
        super.load();
    }

    private static class MySaveSession
    implements StateStorageManager.SaveSession {
        StateStorage.SaveSession saveSession;

        public MySaveSession(XmlElementStorage storage, StateStorageManager.ExternalizationSession externalizationSession) {
            this.saveSession = storage.startSave(((MyExternalizationSession)externalizationSession).externalizationSession);
        }

        @Override
        @Nullable
        public Set<String> analyzeExternalChanges(Set<Pair<VirtualFile, StateStorage>> files) {
            throw new UnsupportedOperationException("Method analyzeExternalChanges not implemented in " + this.getClass());
        }

        @Override
        public List<IFile> getAllStorageFilesToSave() throws StateStorage.StateStorageException {
            return Collections.emptyList();
        }

        @Override
        public List<IFile> getAllStorageFiles() {
            return Collections.emptyList();
        }

        @Override
        public void save() throws StateStorage.StateStorageException {
            this.saveSession.save();
        }
    }

    private static class MyExternalizationSession
    implements StateStorageManager.ExternalizationSession {
        StateStorage.ExternalizationSession externalizationSession;

        public MyExternalizationSession(XmlElementStorage storage) {
            this.externalizationSession = storage.startExternalization();
        }

        @Override
        public void setState(@NotNull Storage[] storageSpecs, Object component, String componentName, Object state) throws StateStorage.StateStorageException {
            if (storageSpecs == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/DefaultProjectStoreImpl$MyExternalizationSession.setState must not be null");
            }
            this.externalizationSession.setState(component, componentName, state, null);
        }

        @Override
        public void setStateInOldStorage(Object component, String componentName, Object state) throws StateStorage.StateStorageException {
            this.externalizationSession.setState(component, componentName, state, null);
        }
    }
}

