/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.StreamProvider;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class FileBasedStorage
extends XmlElementStorage {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.FileBasedStorage");
    private final String myFilePath;
    private final IFile myFile;
    protected final String myRootElementName;
    private static final byte[] BUFFER = new byte[10];
    private static boolean myConfigDirectoryRefreshed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBasedStorage(@Nullable TrackingPathMacroSubstitutor pathMacroManager, StreamProvider streamProvider, String filePath, String fileSpec, String rootElementName, @NotNull Disposable parentDisposable, PicoContainer picoContainer, ComponentRoamingManager componentRoamingManager, ComponentVersionProvider localComponentVersionProvider) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/openapi/components/impl/stores/FileBasedStorage.<init> must not be null");
        }
        super(pathMacroManager, parentDisposable, rootElementName, streamProvider, fileSpec, componentRoamingManager, localComponentVersionProvider);
        Application app = ApplicationManager.getApplication();
        if (!myConfigDirectoryRefreshed && (app.isUnitTestMode() || app.isDispatchThread())) {
            try {
                FileBasedStorage.syncRefreshPathRecursively(PathManager.getConfigPath((boolean)true), "componentVersions");
            }
            finally {
                myConfigDirectoryRefreshed = true;
            }
        }
        this.myRootElementName = rootElementName;
        this.myFilePath = filePath;
        this.myFile = FileSystem.FILE_SYSTEM.createFile(this.myFilePath);
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)picoContainer.getComponentInstanceOfType(VirtualFileTracker.class);
        MessageBus messageBus = (MessageBus)picoContainer.getComponentInstanceOfType(MessageBus.class);
        if (virtualFileTracker != null && messageBus != null) {
            String path = this.myFile.getAbsolutePath();
            String fileUrl = "file://" + path.replace(File.separatorChar, '/');
            final StateStorage.Listener listener = (StateStorage.Listener)messageBus.syncPublisher(STORAGE_TOPIC);
            virtualFileTracker.addTracker(fileUrl, (VirtualFileListener)new VirtualFileAdapter(){

                public void contentsChanged(VirtualFileEvent event) {
                    listener.storageFileChanged(event, (StateStorage)FileBasedStorage.this);
                }
            }, false, (Disposable)this);
        }
    }

    public static void syncRefreshPathRecursively(String configDirectoryPath, @Nullable String excludeDir) {
        VirtualFile configDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(configDirectoryPath);
        if (configDir != null) {
            FileBasedStorage.requestAllChildren(configDir, excludeDir);
            if (configDir instanceof NewVirtualFile) {
                ((NewVirtualFile)configDir).markDirtyRecursively();
            }
            configDir.refresh(false, true);
        }
    }

    private static void requestAllChildren(VirtualFile configDir, @Nullable String excludeDir) {
        if (excludeDir == null || !excludeDir.equals(configDir.getName())) {
            for (VirtualFile file : configDir.getChildren()) {
                FileBasedStorage.requestAllChildren(file, excludeDir);
            }
        }
    }

    private static boolean isOptionsFile(String filePath) {
        try {
            return FileUtil.isAncestor((File)new File(PathManager.getOptionsPath()), (File)new File(filePath), (boolean)false);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected XmlElementStorage.MySaveSession createSaveSession(XmlElementStorage.MyExternalizationSession externalizationSession) {
        return new FileSaveSession(externalizationSession);
    }

    public void resetProviderCache() {
        this.myProviderUpToDateHash = null;
        this.myProviderVersions = null;
    }

    @Override
    protected void loadState(XmlElementStorage.StorageData result, Element element) throws StateStorage.StateStorageException {
        ((FileStorageData)result).myFileName = this.myFile.getAbsolutePath();
        ((FileStorageData)result).myFilePath = this.myFile.getAbsolutePath();
        super.loadState(result, element);
    }

    @Override
    @NotNull
    protected XmlElementStorage.StorageData createStorageData() {
        FileStorageData fileStorageData = new FileStorageData(this.myRootElementName);
        if (fileStorageData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/FileBasedStorage.createStorageData must not return null");
        }
        return fileStorageData;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return StorageUtil.getVirtualFile(this.myFile);
    }

    public IFile getFile() {
        return this.myFile;
    }

    @Override
    @Nullable
    protected Document loadDocument() throws StateStorage.StateStorageException {
        this.myBlockSavingTheContent = false;
        try {
            VirtualFile file = this.getVirtualFile();
            if (file == null || file.isDirectory()) {
                LOG.info("Document was not loaded for " + this.myFileSpec + " file is " + (file == null ? "null" : "directory"));
                return null;
            }
            return this.loadDocumentImpl(file);
        }
        catch (JDOMException e) {
            return this.processReadException((Exception)((Object)e));
        }
        catch (IOException e) {
            return this.processReadException(e);
        }
    }

    private Document processReadException(final Exception e) {
        this.myBlockSavingTheContent = this.isProjectOrModuleFile();
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Cannot load settings from file '" + FileBasedStorage.this.myFile.getPath() + "': " + e.getLocalizedMessage() + "\n" + FileBasedStorage.this.getInvalidContentMessage(), "Load Settings", 0);
                }
            });
        }
        return null;
    }

    private boolean isProjectOrModuleFile() {
        return this.myIsProjectSettings || this.myFileSpec.equals("$MODULE_FILE$");
    }

    private String getInvalidContentMessage() {
        return this.isProjectOrModuleFile() ? "Please correct the file content" : "File content will be recreated";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Document loadDocumentImpl(VirtualFile file) throws IOException, JDOMException {
        int bytesToSkip = FileBasedStorage.skipBom(file);
        InputStream stream = file.getInputStream();
        try {
            Object object;
            if (bytesToSkip > 0) {
                int r;
                object = BUFFER;
                // MONITORENTER : BUFFER
                for (int read = 0; read < bytesToSkip; read += r) {
                    r = stream.read(BUFFER, 0, bytesToSkip - read);
                    if (r >= 0) continue;
                    throw new IOException("Can't skip BOM for file: " + this.myFile.getPath());
                }
                // MONITOREXIT : object
            }
            object = JDOMUtil.loadDocument((InputStream)stream);
            return object;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int skipBom(VirtualFile virtualFile) {
        byte[] byArray = BUFFER;
        synchronized (BUFFER) {
            try {
                int read;
                InputStream input = virtualFile.getInputStream();
                try {
                    read = input.read(BUFFER);
                }
                finally {
                    input.close();
                }
                if (FileBasedStorage.startsWith(BUFFER, read, CharsetToolkit.UTF8_BOM)) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return CharsetToolkit.UTF8_BOM.length;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
            catch (IOException e) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
        }
    }

    private static boolean startsWith(byte[] buffer, int read, byte[] bom) {
        return read >= bom.length && ArrayUtil.startsWith((byte[])buffer, (byte[])bom);
    }

    public String getFileName() {
        return this.myFile.getName();
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    @Override
    public void setDefaultState(Element element) {
        element.setName(this.myRootElementName);
        super.setDefaultState(element);
    }

    protected boolean physicalContentNeedsSave(Document doc) {
        if (!this.myFile.exists()) {
            return true;
        }
        return !StorageUtil.contentEquals(doc, this.myFile);
    }

    @Nullable
    public File updateFileExternallyFromStreamProviders() throws IOException {
        XmlElementStorage.StorageData loadedData = this.loadData(true, this.myListener);
        Document document = this.getDocument(loadedData);
        if (this.physicalContentNeedsSave(document)) {
            File file = new File(this.myFile.getAbsolutePath());
            JDOMUtil.writeDocument((Document)document, (File)file, (String)"\n");
            return file;
        }
        return null;
    }

    public static class FileStorageData
    extends XmlElementStorage.StorageData {
        String myFilePath;
        String myFileName;

        public FileStorageData(String rootElementName) {
            super(rootElementName);
        }

        protected FileStorageData(FileStorageData storageData) {
            super(storageData);
            this.myFileName = storageData.myFileName;
            this.myFilePath = storageData.myFilePath;
        }

        @Override
        public XmlElementStorage.StorageData clone() {
            return new FileStorageData(this);
        }

        public String toString() {
            return "FileStorageData[" + this.myFileName + "]";
        }
    }

    protected class FileSaveSession
    extends XmlElementStorage.MySaveSession {
        protected FileSaveSession(XmlElementStorage.MyExternalizationSession externalizationSession) {
            super(FileBasedStorage.this, externalizationSession);
        }

        @Override
        protected boolean physicalContentNeedsSave() {
            if (!FileBasedStorage.this.myFile.exists()) {
                return !this.myStorageData.isEmpty();
            }
            return !StorageUtil.contentEquals(this.getDocumentToSave(), FileBasedStorage.this.myFile);
        }

        @Override
        protected Integer calcHash() {
            int hash = this.myStorageData.getHash();
            if (FileBasedStorage.this.myPathMacroSubstitutor != null) {
                hash = 31 * hash + FileBasedStorage.this.myPathMacroSubstitutor.hashCode();
            }
            return hash;
        }

        @Override
        protected void doSave() throws StateStorage.StateStorageException {
            if (!FileBasedStorage.this.myBlockSavingTheContent) {
                StorageUtil.save(FileBasedStorage.this.myFile, (Parent)this.getDocumentToSave(), this);
            }
        }

        public Collection<IFile> getStorageFilesToSave() throws StateStorage.StateStorageException {
            boolean needsSave = this.needsSave();
            if (needsSave) {
                if (LOG.isDebugEnabled()) {
                    LOG.info("File " + FileBasedStorage.this.myFileSpec + " needs save; hash=" + FileBasedStorage.this.myUpToDateHash + "; currentHash=" + this.calcHash() + "; content needs save=" + this.physicalContentNeedsSave());
                }
                return this.getAllStorageFiles();
            }
            return Collections.emptyList();
        }

        public List<IFile> getAllStorageFiles() {
            return Collections.singletonList(FileBasedStorage.this.myFile);
        }
    }
}

