/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooser;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageAnnotationsDefaultValues;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.components.impl.stores.DefaultProjectStoreImpl;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.ProjectStateStorageManager;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectStoreImpl
extends BaseFileConfigurableStoreImpl
implements IProjectStore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.ProjectStoreImpl");
    @NonNls
    private static final String OLD_PROJECT_SUFFIX = "_old.";
    @NonNls
    static final String OPTION_WORKSPACE = "workspace";
    protected ProjectEx myProject;
    @NonNls
    static final String PROJECT_FILE_MACRO = "PROJECT_FILE";
    @NonNls
    static final String WS_FILE_MACRO = "WORKSPACE_FILE";
    @NonNls
    private static final String PROJECT_CONFIG_DIR = "PROJECT_CONFIG_DIR";
    static final String PROJECT_FILE_STORAGE = "$PROJECT_FILE$";
    static final String WS_FILE_STORAGE = "$WORKSPACE_FILE$";
    static final String DEFAULT_STATE_STORAGE = "$PROJECT_FILE$";
    static final Storage DEFAULT_STORAGE_ANNOTATION = new MyStorage();
    private static int originalVersion = -1;
    private StorageScheme myScheme = StorageScheme.DEFAULT;
    private String myCachedLocation;
    private final StateStorageChooser myStateStorageChooser = new StateStorageChooser(){

        public Storage[] selectStorages(Storage[] storages, Object component, StateStorageOperation operation) {
            if (operation == StateStorageOperation.READ) {
                OrderedSet result = new OrderedSet();
                for (Storage storage : storages) {
                    if (storage.scheme() != ProjectStoreImpl.this.myScheme) continue;
                    result.add(0, (Object)storage);
                }
                for (Storage storage : storages) {
                    if (storage.scheme() != StorageScheme.DEFAULT) continue;
                    result.add((Object)storage);
                }
                return (Storage[])result.toArray((Object[])new Storage[result.size()]);
            }
            if (operation == StateStorageOperation.WRITE) {
                ArrayList<Storage> result = new ArrayList<Storage>();
                for (Storage storage : storages) {
                    if (storage.scheme() != ProjectStoreImpl.this.myScheme) continue;
                    result.add(storage);
                }
                if (!result.isEmpty()) {
                    return result.toArray(new Storage[result.size()]);
                }
                for (Storage storage : storages) {
                    if (storage.scheme() != StorageScheme.DEFAULT) continue;
                    result.add(storage);
                }
                return result.toArray(new Storage[result.size()]);
            }
            return new Storage[0];
        }
    };

    ProjectStoreImpl(ProjectEx project) {
        super((ComponentManager)project);
        this.myProject = project;
    }

    @Override
    public boolean checkVersion() {
        String message;
        ApplicationNamesInfo appNamesInfo = ApplicationNamesInfo.getInstance();
        if (originalVersion >= 0 && originalVersion < 4) {
            final VirtualFile projectFile = this.getProjectFile();
            LOG.assertTrue(projectFile != null);
            String name = projectFile.getNameWithoutExtension();
            String message2 = ProjectBundle.message((String)"project.convert.old.prompt", (Object[])new Object[]{projectFile.getName(), appNamesInfo.getProductName(), name + OLD_PROJECT_SUFFIX + projectFile.getExtension()});
            if (Messages.showYesNoDialog((String)message2, (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            ArrayList<String> conversionProblems = ProjectStoreImpl.getConversionProblemsStorage();
            if (conversionProblems != null && !conversionProblems.isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(ProjectBundle.message((String)"project.convert.problems.detected", (Object[])new Object[0]));
                for (String s : conversionProblems) {
                    buffer.append('\n');
                    buffer.append(s);
                }
                buffer.append(ProjectBundle.message((String)"project.convert.problems.help", (Object[])new Object[0]));
                int result = Messages.showDialog((Project)this.myProject, (String)buffer.toString(), (String)ProjectBundle.message((String)"project.convert.problems.title", (Object[])new Object[0]), (String[])new String[]{ProjectBundle.message((String)"project.convert.problems.help.button", (Object[])new Object[0]), CommonBundle.getCloseButtonText()}, (int)0, (Icon)Messages.getWarningIcon());
                if (result == 0) {
                    HelpManager.getInstance().invokeHelp("project.migrationProblems");
                }
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        VirtualFile projectDir = projectFile.getParent();
                        assert (projectDir != null);
                        this.backup(projectDir, projectFile);
                        VirtualFile workspaceFile = ProjectStoreImpl.this.getWorkspaceFile();
                        if (workspaceFile != null) {
                            this.backup(projectDir, workspaceFile);
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }

                private void backup(VirtualFile projectDir, VirtualFile vile) throws IOException {
                    String oldName = vile.getNameWithoutExtension() + ProjectStoreImpl.OLD_PROJECT_SUFFIX + vile.getExtension();
                    VirtualFile oldFile = projectDir.findOrCreateChildData((Object)this, oldName);
                    VfsUtil.saveText((VirtualFile)oldFile, (String)VfsUtil.loadText((VirtualFile)vile));
                }
            });
        }
        return originalVersion <= 4 || Messages.showYesNoDialog((String)(message = ProjectBundle.message((String)"project.load.new.version.warning", (Object[])new Object[]{this.myProject.getName(), appNamesInfo.getProductName()})), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    public TrackingPathMacroSubstitutor[] getSubstitutors() {
        return new TrackingPathMacroSubstitutor[]{this.getStateStorageManager().getMacroSubstitutor()};
    }

    @Override
    protected boolean optimizeTestLoading() {
        return this.myProject.isOptimiseTestLoadSpeed();
    }

    @Override
    protected Project getProject() {
        return this.myProject;
    }

    @Override
    public void setProjectFilePath(String filePath) {
        if (filePath == null) {
            return;
        }
        IFile iFile = FileSystem.FILE_SYSTEM.createFile(filePath);
        IFile dir_store = iFile.isDirectory() ? iFile.getChild(".idea") : iFile.getParentFile().getChild(".idea");
        StateStorageManager stateStorageManager = this.getStateStorageManager();
        if (dir_store.exists() && iFile.isDirectory()) {
            FileBasedStorage.syncRefreshPathRecursively(dir_store.getPath(), null);
            this.myScheme = StorageScheme.DIRECTORY_BASED;
            stateStorageManager.addMacro(PROJECT_FILE_MACRO, dir_store.getChild("misc.xml").getPath());
            IFile ws = dir_store.getChild("workspace.xml");
            stateStorageManager.addMacro(WS_FILE_MACRO, ws.getPath());
            if (!ws.exists() && !iFile.isDirectory()) {
                ProjectStoreImpl.useOldWsContent(filePath, ws);
            }
            stateStorageManager.addMacro(PROJECT_CONFIG_DIR, dir_store.getPath());
        } else {
            this.myScheme = StorageScheme.DEFAULT;
            stateStorageManager.addMacro(PROJECT_FILE_MACRO, filePath);
            LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath);
            int lastDot = filePath.lastIndexOf(".");
            String filePathWithoutExt = lastDot > 0 ? filePath.substring(0, lastDot) : filePath;
            String workspacePath = filePathWithoutExt + ".iws";
            LocalFileSystem.getInstance().refreshAndFindFileByPath(workspacePath);
            stateStorageManager.addMacro(WS_FILE_MACRO, workspacePath);
        }
        this.myCachedLocation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void useOldWsContent(String filePath, IFile ws) {
        int lastDot = filePath.lastIndexOf(".");
        String filePathWithoutExt = lastDot > 0 ? filePath.substring(0, lastDot) : filePath;
        String workspacePath = filePathWithoutExt + ".iws";
        IFile oldWs = FileSystem.FILE_SYSTEM.createFile(workspacePath);
        if (oldWs.exists()) {
            try {
                byte[] bytes;
                InputStream is = oldWs.openInputStream();
                try {
                    bytes = FileUtil.loadBytes((InputStream)is, (int)((int)oldWs.length()));
                }
                finally {
                    is.close();
                }
                OutputStream os = ws.openOutputStream();
                try {
                    os.write(bytes);
                }
                finally {
                    os.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public VirtualFile getProjectBaseDir() {
        VirtualFile projectFile = this.getProjectFile();
        if (projectFile != null) {
            return this.myScheme == StorageScheme.DEFAULT ? projectFile.getParent() : projectFile.getParent().getParent();
        }
        StateStorage s = this.getStateStorageManager().getFileStateStorage("$PROJECT_FILE$");
        if (!(s instanceof FileBasedStorage)) {
            return null;
        }
        FileBasedStorage storage = (FileBasedStorage)s;
        IFile file = storage.getFile();
        if (file == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByIoFile(this.myScheme == StorageScheme.DEFAULT ? file.getParentFile() : file.getParentFile().getParentFile());
    }

    @Override
    @Nullable
    public String getLocation() {
        if (this.myCachedLocation == null) {
            VirtualFile baseDir;
            this.myCachedLocation = this.myScheme == StorageScheme.DEFAULT ? this.getProjectFilePath() : ((baseDir = this.getProjectBaseDir()) == null ? null : baseDir.getPath());
        }
        return this.myCachedLocation;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getProjectName() {
        int i;
        String string;
        if (this.myScheme == StorageScheme.DIRECTORY_BASED) {
            VirtualFile baseDir = this.getProjectBaseDir();
            if (!$assertionsDisabled && baseDir == null) {
                String string2;
                StringBuilder stringBuilder = new StringBuilder().append("project file: ");
                if (this.getProjectFile() == null) {
                    string2 = "[NULL]";
                    throw new AssertionError((Object)stringBuilder.append(string2).toString());
                }
                string2 = this.getProjectFile().getPath();
                throw new AssertionError((Object)stringBuilder.append(string2).toString());
            }
            String string3 = baseDir.getName().replace(":", "");
            string = string3;
            if (string3 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ProjectStoreImpl.getProjectName must not return null");
        }
        String temp = this.getProjectFileName();
        if (temp.endsWith(".ipr")) {
            temp = temp.substring(0, temp.length() - ".ipr".length());
        }
        if ((i = temp.lastIndexOf(File.separatorChar)) >= 0) {
            temp = temp.substring(i + 1, temp.length() - i + 1);
        }
        String string4 = temp;
        string = string4;
        if (string4 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ProjectStoreImpl.getProjectName must not return null");
        return string;
    }

    @Override
    @NotNull
    public StorageScheme getStorageScheme() {
        StorageScheme storageScheme = this.myScheme;
        if (storageScheme == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ProjectStoreImpl.getStorageScheme must not return null");
        }
        return storageScheme;
    }

    @Override
    @Nullable
    public String getPresentableUrl() {
        if (this.myProject.isDefault()) {
            return null;
        }
        if (this.myScheme == StorageScheme.DIRECTORY_BASED) {
            VirtualFile baseDir = this.getProjectBaseDir();
            return baseDir != null ? baseDir.getPresentableUrl() : null;
        }
        if (this.myProject.isDefault()) {
            return null;
        }
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage("$PROJECT_FILE$");
        assert (storage != null);
        return storage.getFilePath().replace('/', File.separatorChar);
    }

    @Override
    public void loadProject() throws IOException, JDOMException, InvalidDataException, StateStorage.StateStorageException {
        this.myProject.init();
    }

    @Override
    @Nullable
    public VirtualFile getProjectFile() {
        if (this.myProject.isDefault()) {
            return null;
        }
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage("$PROJECT_FILE$");
        assert (storage != null);
        return storage.getVirtualFile();
    }

    @Override
    @Nullable
    public VirtualFile getWorkspaceFile() {
        if (this.myProject.isDefault()) {
            return null;
        }
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage(WS_FILE_STORAGE);
        assert (storage != null);
        return storage.getVirtualFile();
    }

    @Override
    public void loadProjectFromTemplate(ProjectImpl defaultProject) {
        StateStorage stateStorage = this.getStateStorageManager().getFileStateStorage("$PROJECT_FILE$");
        assert (stateStorage instanceof XmlElementStorage);
        XmlElementStorage xmlElementStorage = (XmlElementStorage)stateStorage;
        defaultProject.save();
        IProjectStore projectStore = defaultProject.getStateStore();
        assert (projectStore instanceof DefaultProjectStoreImpl);
        DefaultProjectStoreImpl defaultProjectStore = (DefaultProjectStoreImpl)projectStore;
        Element element = defaultProjectStore.getStateCopy();
        if (element != null) {
            xmlElementStorage.setDefaultState(element);
        }
    }

    @Override
    @NotNull
    public String getProjectFileName() {
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage("$PROJECT_FILE$");
        assert (storage != null);
        String string = storage.getFileName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ProjectStoreImpl.getProjectFileName must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getProjectFilePath() {
        if (this.myProject.isDefault()) {
            return "";
        }
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage("$PROJECT_FILE$");
        assert (storage != null);
        String string = storage.getFilePath();
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ProjectStoreImpl.getProjectFilePath must not return null");
        return string2;
    }

    @Override
    protected XmlElementStorage getMainStorage() {
        XmlElementStorage storage = (XmlElementStorage)this.getStateStorageManager().getFileStateStorage("$PROJECT_FILE$");
        assert (storage != null);
        return storage;
    }

    @Override
    protected StateStorageManager createStateStorageManager() {
        return new ProjectStateStorageManager(PathMacroManager.getInstance(this.getComponentManager()).createTrackingSubstitutor(), this.myProject);
    }

    @Override
    protected ComponentStoreImpl.SaveSessionImpl createSaveSession() throws StateStorage.StateStorageException {
        return new ProjectSaveSession();
    }

    @Override
    @Nullable
    protected StateStorageChooser getDefaultStateStorageChooser() {
        return this.myStateStorageChooser;
    }

    @Override
    @NotNull
    protected <T> Storage[] getComponentStorageSpecs(@NotNull PersistentStateComponent<T> persistentStateComponent, StateStorageOperation operation) throws StateStorage.StateStorageException {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ProjectStoreImpl.getComponentStorageSpecs must not be null");
        }
        Storage[] result = super.getComponentStorageSpecs(persistentStateComponent, operation);
        if (operation == StateStorageOperation.READ) {
            Storage[] upd = new Storage[result.length + 1];
            System.arraycopy(result, 0, upd, 0, result.length);
            upd[result.length] = DEFAULT_STORAGE_ANNOTATION;
            result = upd;
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/ProjectStoreImpl.getComponentStorageSpecs must not return null");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reload(Set<Pair<VirtualFile, StateStorage>> changedFiles) throws IOException, StateStorage.StateStorageException {
        Set<String> componentNames;
        IComponentStore.SaveSession saveSession = this.startSave();
        try {
            componentNames = saveSession.analyzeExternalChanges(changedFiles);
            if (componentNames == null) {
                boolean bl = false;
                return bl;
            }
            for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
                if (pair.second != null) continue;
                boolean bl = false;
                return bl;
            }
            if (!componentNames.isEmpty()) {
                StorageUtil.logStateDiffInfo(changedFiles, componentNames);
            }
            if (!this.isReloadPossible(componentNames)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.finishSave(saveSession);
        }
        if (!componentNames.isEmpty()) {
            ((BatchUpdateListener)this.myProject.getMessageBus().syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateStarted();
            try {
                this.doReload(changedFiles, componentNames);
                this.reinitComponents(componentNames, false);
            }
            finally {
                ((BatchUpdateListener)this.myProject.getMessageBus().syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateFinished();
            }
        }
        return true;
    }

    private static class MyStorage
    implements Storage {
        private MyStorage() {
        }

        public String id() {
            return "___Default___";
        }

        public boolean isDefault() {
            return true;
        }

        public String file() {
            return "$PROJECT_FILE$";
        }

        public StorageScheme scheme() {
            return StorageScheme.DEFAULT;
        }

        public Class<? extends StateStorage> storageClass() {
            return StorageAnnotationsDefaultValues.NullStateStorage.class;
        }

        public Class<? extends StateSplitter> stateSplitter() {
            return StorageAnnotationsDefaultValues.NullStateSplitter.class;
        }

        public Class<? extends Annotation> annotationType() {
            throw new UnsupportedOperationException("Method annotationType not implemented in " + this.getClass());
        }
    }

    protected class ProjectSaveSession
    extends ComponentStoreImpl.SaveSessionImpl {
        ProjectSaveSession() throws StateStorage.StateStorageException {
        }

        @Override
        public List<IFile> getAllStorageFilesToSave(boolean includingSubStructures) throws IOException {
            ArrayList<IFile> result = new ArrayList<IFile>();
            if (includingSubStructures) {
                this.collectSubfilesToSave(result);
            }
            result.addAll(super.getAllStorageFilesToSave(false));
            return result;
        }

        protected void collectSubfilesToSave(List<IFile> result) throws IOException {
        }

        @Override
        public IComponentStore.SaveSession save() throws IOException {
            ReadonlyStatusHandler.OperationStatus operationStatus = this.ensureConfigFilesWritable();
            if (operationStatus == null) {
                throw new IOException();
            }
            if (operationStatus.hasReadonlyFiles()) {
                MessagesEx.error(ProjectStoreImpl.this.myProject, ProjectBundle.message((String)"project.save.error", (Object[])new Object[]{operationStatus.getReadonlyFilesMessage()})).showLater();
                throw new IComponentStore.SaveCancelledException();
            }
            this.beforeSave();
            super.save();
            return this;
        }

        protected void beforeSave() throws IOException {
        }

        private ReadonlyStatusHandler.OperationStatus ensureConfigFilesWritable() {
            return (ReadonlyStatusHandler.OperationStatus)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ReadonlyStatusHandler.OperationStatus>(){

                public ReadonlyStatusHandler.OperationStatus compute() {
                    List<IFile> filesToSave;
                    try {
                        filesToSave = ProjectSaveSession.this.getAllStorageFilesToSave(true);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                        return null;
                    }
                    ArrayList<VirtualFile> readonlyFiles = new ArrayList<VirtualFile>();
                    for (IFile file : filesToSave) {
                        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                        if (virtualFile == null) continue;
                        virtualFile.refresh(false, false);
                        if (!virtualFile.isValid() || virtualFile.isWritable()) continue;
                        readonlyFiles.add(virtualFile);
                    }
                    return ReadonlyStatusHandler.getInstance((Project)ProjectStoreImpl.this.myProject).ensureFilesWritable(readonlyFiles);
                }
            });
        }
    }

    static class IprStorageData
    extends ProjectStorageData {
        IprStorageData(String rootElementName, Project project) {
            super(rootElementName, project);
        }

        IprStorageData(IprStorageData storageData) {
            super(storageData);
        }

        @Override
        protected void load(@NotNull Element root) throws IOException {
            if (root == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ProjectStoreImpl$IprStorageData.load must not be null");
            }
            String v = root.getAttributeValue("version");
            originalVersion = v != null ? Integer.parseInt(v) : 0;
            if (originalVersion != 4) {
                this.convert(root, originalVersion);
            }
            super.load(root);
        }

        protected void convert(Element root, int originalVersion) {
        }

        @Override
        public XmlElementStorage.StorageData clone() {
            return new IprStorageData(this);
        }
    }

    static class WsStorageData
    extends ProjectStorageData {
        WsStorageData(String rootElementName, Project project) {
            super(rootElementName, project);
        }

        WsStorageData(WsStorageData storageData) {
            super(storageData);
        }

        @Override
        public XmlElementStorage.StorageData clone() {
            return new WsStorageData(this);
        }
    }

    static class ProjectStorageData
    extends BaseFileConfigurableStoreImpl.BaseStorageData {
        protected final Project myProject;

        ProjectStorageData(String rootElementName, Project project) {
            super(rootElementName);
            this.myProject = project;
        }

        protected ProjectStorageData(ProjectStorageData storageData) {
            super(storageData);
            this.myProject = storageData.myProject;
        }

        @Override
        public XmlElementStorage.StorageData clone() {
            return new ProjectStorageData(this);
        }
    }
}

