/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class IgnoreWhiteSpacesAction
extends ComboBoxAction
implements DumbAware {
    private final Map<ComparisonPolicy, AnAction> myActions = new HashMap();
    private static final ComparisonPolicy[] ourActionOrder = new ComparisonPolicy[]{ComparisonPolicy.DEFAULT, ComparisonPolicy.TRIM_SPACE, ComparisonPolicy.IGNORE_SPACE};

    public IgnoreWhiteSpacesAction() {
        this.myActions.put(ComparisonPolicy.DEFAULT, new IgnoringPolicyAction(DiffBundle.message((String)"diff.acton.ignore.qhitespace.policy.do.not.ignore", (Object[])new Object[0]), ComparisonPolicy.DEFAULT));
        this.myActions.put(ComparisonPolicy.TRIM_SPACE, new IgnoringPolicyAction(DiffBundle.message((String)"diff.acton.ignore.qhitespace.policy.leading.and.trailing", (Object[])new Object[0]), ComparisonPolicy.TRIM_SPACE));
        this.myActions.put(ComparisonPolicy.IGNORE_SPACE, new IgnoringPolicyAction(DiffBundle.message((String)"diff.acton.ignore.qhitespace.policy.all", (Object[])new Object[0]), ComparisonPolicy.IGNORE_SPACE));
    }

    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(DiffBundle.message((String)"comparison.ignore.whitespace.acton.name", (Object[])new Object[0])), "West");
        panel.add((Component)super.createCustomComponent(presentation), "Center");
        return panel;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (ComparisonPolicy comparisonPolicy : ourActionOrder) {
            actionGroup.add(this.myActions.get(comparisonPolicy));
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/diff/actions/IgnoreWhiteSpacesAction.createPopupActionGroup must not return null");
        }
        return defaultActionGroup;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DiffPanelImpl diffPanel = DiffPanelImpl.fromDataContext(e.getDataContext());
        if (diffPanel != null && diffPanel.getComponent().isDisplayable()) {
            AnAction actoin = this.myActions.get(diffPanel.getComparisonPolicy());
            Presentation templatePresentation = actoin.getTemplatePresentation();
            presentation.setIcon(templatePresentation.getIcon());
            presentation.setText(templatePresentation.getText());
            presentation.setEnabled(true);
        } else {
            presentation.setIcon(null);
            presentation.setText(DiffBundle.message((String)"ignore.whitespace.action.not.avaliable.action.name", (Object[])new Object[0]));
            presentation.setEnabled(false);
        }
    }

    private static class IgnoringPolicyAction
    extends AnAction {
        private final ComparisonPolicy myPolicy;

        public IgnoringPolicyAction(String text, ComparisonPolicy policy) {
            super(text);
            this.myPolicy = policy;
        }

        public void actionPerformed(AnActionEvent e) {
            DiffPanelImpl diffPanel = DiffPanelImpl.fromDataContext(e.getDataContext());
            if (diffPanel != null) {
                diffPanel.setComparisonPolicy(this.myPolicy);
            }
        }
    }
}

