/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.actions.MergeActionGroup;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.ContentChangeListener;
import com.intellij.openapi.diff.impl.DiffHighlighterFactory;
import com.intellij.openapi.diff.impl.DiffHighlighterFactoryImpl;
import com.intellij.openapi.diff.impl.DiffSideView;
import com.intellij.openapi.diff.impl.DiffSplitter;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.EditorSource;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.diff.impl.Rediffers;
import com.intellij.openapi.diff.impl.TwoSidesContainer;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.fragments.FragmentList;
import com.intellij.openapi.diff.impl.highlighting.DiffPanelState;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.splitter.DiffDividerPaint;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.diff.impl.util.DiffPanelOutterComponent;
import com.intellij.openapi.diff.impl.util.FocusDiffSide;
import com.intellij.openapi.diff.impl.util.FontSizeSynchronizer;
import com.intellij.openapi.diff.impl.util.SyncScrollSupport;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import java.awt.Window;
import java.security.InvalidParameterException;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffPanelImpl
implements DiffPanelEx,
ContentChangeListener,
TwoSidesContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.DiffPanelImpl");
    private final DiffSplitter mySplitter;
    private final DiffPanelOutterComponent myPanel;
    private final Window myOwnerWindow;
    private final DiffPanelOptions myOptions;
    private final DiffPanelState myData;
    private final Rediffers myDiffUpdater;
    private final DiffSideView myLeftSide;
    private final DiffSideView myRightSide;
    private DiffSideView myCurrentSide;
    private LineBlocks myLineBlocks = LineBlocks.EMPTY;
    private final SyncScrollSupport myScrollSupport = new SyncScrollSupport();
    private final FontSizeSynchronizer myFontSizeSynchronizer = new FontSizeSynchronizer();
    private DiffRequest myDiffRequest;
    private final DiffRequest.ToolbarAddons TOOL_BAR = new DiffRequest.ToolbarAddons(){

        public void customize(DiffToolbar toolbar) {
            ActionManager actionManager = ActionManager.getInstance();
            toolbar.addAction(actionManager.getAction("DiffPanel.Toolbar"));
        }
    };
    private boolean myDisposed = false;
    private final GenericDataProvider myDataProvider;

    public DiffPanelImpl(Window owner, Project project, boolean enableToolbar) {
        this.myOptions = new DiffPanelOptions(this);
        this.myPanel = new DiffPanelOutterComponent(TextDiffType.DIFF_TYPES, this.TOOL_BAR);
        this.myPanel.disableToolbar(!enableToolbar);
        if (enableToolbar) {
            this.myPanel.resetToolbar();
        }
        this.myOwnerWindow = owner;
        this.myLeftSide = new DiffSideView(DiffBundle.message((String)"diff.left.side.default.title", (Object[])new Object[0]), this);
        this.myRightSide = new DiffSideView(DiffBundle.message((String)"diff.right.side.default.title", (Object[])new Object[0]), this);
        this.myLeftSide.becomeMaster();
        this.myDiffUpdater = new Rediffers(this);
        this.myData = new DiffPanelState(this, project);
        this.mySplitter = new DiffSplitter(this.myLeftSide.getComponent(), this.myRightSide.getComponent(), new DiffDividerPaint(this, FragmentSide.SIDE1));
        this.myPanel.insertDiffComponent((JComponent)((Object)this.mySplitter), new MyScrollingPanel());
        this.myDataProvider = new MyGenericDataProvider(this);
        this.myPanel.setDataProvider(this.myDataProvider);
        ComparisonPolicy comparisonPolicy = this.getComparisonPolicy();
        ComparisonPolicy defaultComparisonPolicy = DiffManagerImpl.getInstanceEx().getComparisonPolicy();
        if (defaultComparisonPolicy != null && comparisonPolicy != defaultComparisonPolicy) {
            this.setComparisonPolicy(defaultComparisonPolicy);
        }
    }

    @Override
    public Editor getEditor1() {
        return this.myLeftSide.getEditor();
    }

    @Override
    public Editor getEditor2() {
        Editor editor;
        if (this.myDisposed) {
            LOG.error("Disposed");
        }
        if ((editor = this.myRightSide.getEditor()) != null) {
            return editor;
        }
        if (this.myData.getContent2() == null) {
            LOG.error("No content 2");
        }
        return editor;
    }

    public void setContents(DiffContent content1, DiffContent content2) {
        String path;
        LOG.assertTrue(!this.myDisposed);
        this.myData.setContents(content1, content2);
        Project project = this.myData.getProject();
        FileType[] types = DiffUtil.chooseContentTypes(new DiffContent[]{content1, content2});
        VirtualFile baseFile = content1.getFile();
        if (baseFile == null && this.myDiffRequest != null && (path = this.myDiffRequest.getWindowTitle()) != null) {
            baseFile = LocalFileSystem.getInstance().findFileByPath(path);
        }
        this.myLeftSide.setHighlighterFactory(DiffPanelImpl.createHighlighter(types[0], baseFile, project));
        this.myRightSide.setHighlighterFactory(DiffPanelImpl.createHighlighter(types[1], baseFile, project));
        this.rediff();
        this.myPanel.requestScrollEditors();
    }

    private static DiffHighlighterFactory createHighlighter(FileType contentType, VirtualFile file, Project project) {
        return new DiffHighlighterFactoryImpl(contentType, file, project);
    }

    void rediff() {
        this.setLineBlocks(this.myData.updateEditors());
    }

    public void setTitle1(String title) {
        this.myLeftSide.setTitle(title);
    }

    public void setTitle2(String title) {
        this.myRightSide.setTitle(title);
    }

    private void setLineBlocks(LineBlocks blocks) {
        this.myLineBlocks = blocks;
        this.mySplitter.redrawDiffs();
        this.updateStatusBar();
    }

    public void invalidateDiff() {
        this.setLineBlocks(LineBlocks.EMPTY);
        this.myData.removeActions();
    }

    public FragmentList getFragments() {
        return this.myData.getFragmentList();
    }

    private int[] getFragmentBeginnings() {
        return this.getFragmentBeginnings(this.myCurrentSide.getSide());
    }

    int[] getFragmentBeginnings(FragmentSide side) {
        return this.getLineBlocks().getBegginings(side);
    }

    public void dispose() {
        this.myDisposed = true;
        this.myDiffUpdater.dispose();
        Disposer.dispose((Disposable)this.myScrollSupport);
        Disposer.dispose((Disposable)this.myData);
        this.myPanel.cancelScrollEditors();
        JComponent component = this.myPanel.getBottomComponent();
        if (component instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)component));
        }
        this.myPanel.setBottomComponent(null);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private void updateStatusBar() {
        int differentLineBlocks = this.getLineBlocks().getCount();
        this.myPanel.setStatusBarText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{differentLineBlocks}));
    }

    public boolean hasDifferences() {
        return this.getLineBlocks().getCount() > 0;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCurrentSide.getFocusableComponent();
    }

    public int getContentsNumber() {
        return 2;
    }

    @Override
    public ComparisonPolicy getComparisonPolicy() {
        return this.myData.getComparisonPolicy();
    }

    private void setComparisonPolicy(ComparisonPolicy policy, boolean notifyManager) {
        this.myData.setComparisonPolicy(policy);
        this.rediff();
        if (notifyManager) {
            DiffManagerImpl.getInstanceEx().setComparisonPolicy(policy);
        }
    }

    @Override
    public void setComparisonPolicy(ComparisonPolicy comparisonPolicy) {
        this.setComparisonPolicy(comparisonPolicy, true);
    }

    public Rediffers getDiffUpdater() {
        return this.myDiffUpdater;
    }

    @Override
    public void onContentChangedIn(EditorSource source) {
        this.myDiffUpdater.contentRemoved(source);
        final EditorEx editor = source.getEditor();
        if (source.getSide() == FragmentSide.SIDE1 && editor != null) {
            editor.setVerticalScrollbarOrientation(0);
        }
        DiffSideView viewSide = this.getSideView(source.getSide());
        viewSide.setEditorSource(source);
        Disposer.dispose((Disposable)this.myScrollSupport);
        if (editor == null) {
            if (!this.myDisposed) {
                this.rediff();
            }
            return;
        }
        PopupHandler.installUnknownPopupHandler((JComponent)editor.getContentComponent(), (ActionGroup)new MergeActionGroup(this, source.getSide()), (ActionManager)ActionManager.getInstance());
        this.myDiffUpdater.contentAdded(source);
        editor.getSettings().setLineNumbersShown(true);
        editor.getSettings().setFoldingOutlineShown(false);
        ((FoldingModelEx)editor.getFoldingModel()).setFoldingEnabled(false);
        ((EditorMarkupModel)editor.getMarkupModel()).setErrorStripeVisible(true);
        Editor editor1 = this.getEditor(FragmentSide.SIDE1);
        Editor editor2 = this.getEditor(FragmentSide.SIDE2);
        if (editor1 != null && editor2 != null) {
            this.myScrollSupport.install(new EditingSides[]{this});
        }
        final VisibleAreaListener visibleAreaListener = this.mySplitter.getVisibleAreaListener();
        final ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.addVisibleAreaListener(visibleAreaListener);
        this.myFontSizeSynchronizer.synchronize(editor);
        source.addDisposable(new Disposable(){

            public void dispose() {
                DiffPanelImpl.this.myFontSizeSynchronizer.stopSynchronize(editor);
            }
        });
        source.addDisposable(new Disposable(){

            public void dispose() {
                scrollingModel.removeVisibleAreaListener(visibleAreaListener);
            }
        });
    }

    @Override
    public void setCurrentSide(@NotNull DiffSideView viewSide) {
        if (viewSide == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/DiffPanelImpl.setCurrentSide must not be null");
        }
        LOG.assertTrue(viewSide != this.myCurrentSide);
        if (this.myCurrentSide != null) {
            this.myCurrentSide.beSlave();
        }
        this.myCurrentSide = viewSide;
    }

    private DiffSideView getCurrentSide() {
        return this.myCurrentSide;
    }

    @Override
    public Project getProject() {
        return this.myData.getProject();
    }

    @Override
    public void showSource(OpenFileDescriptor descriptor) {
        this.myOptions.showSource(descriptor);
    }

    @Override
    public DiffPanelOptions getOptions() {
        return this.myOptions;
    }

    @Override
    public Editor getEditor(FragmentSide side) {
        return this.getSideView(side).getEditor();
    }

    private DiffSideView getSideView(FragmentSide side) {
        if (side == FragmentSide.SIDE1) {
            return this.myLeftSide;
        }
        if (side == FragmentSide.SIDE2) {
            return this.myRightSide;
        }
        throw new InvalidParameterException(String.valueOf(side));
    }

    @Override
    public LineBlocks getLineBlocks() {
        return this.myLineBlocks;
    }

    public void setDiffRequest(DiffRequest data) {
        this.myDiffRequest = data;
        if (data.getHints().contains(DiffTool.HINT_DO_NOT_IGNORE_WHITESPACES)) {
            this.setComparisonPolicy(ComparisonPolicy.DEFAULT, false);
        }
        this.myDataProvider.putData(this.myDiffRequest.getGenericData());
        this.setContents(data.getContents()[0], data.getContents()[1]);
        this.setTitle1(data.getContentTitles()[0]);
        this.setTitle2(data.getContentTitles()[1]);
        DiffPanelImpl.setWindowTitle(this.myOwnerWindow, data.getWindowTitle());
        data.customizeToolbar(this.myPanel.resetToolbar());
        this.myPanel.registerToolbarActions();
        JComponent oldBottomComponent = this.myPanel.getBottomComponent();
        if (oldBottomComponent instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)oldBottomComponent));
        }
        JComponent newBottomComponent = data.getBottomComponent();
        this.myPanel.setBottomComponent(newBottomComponent);
    }

    private static void setWindowTitle(Window window, String title) {
        if (window instanceof JDialog) {
            ((JDialog)window).setTitle(title);
        } else if (window instanceof JFrame) {
            ((JFrame)window).setTitle(title);
        }
    }

    @Nullable
    public static DiffPanelImpl fromDataContext(DataContext dataContext) {
        DiffViewer viewer = (DiffViewer)PlatformDataKeys.DIFF_VIEWER.getData(dataContext);
        return viewer instanceof DiffPanelImpl ? (DiffPanelImpl)viewer : null;
    }

    public Window getOwnerWindow() {
        return this.myOwnerWindow;
    }

    public void focusOppositeSide() {
        if (this.myCurrentSide == this.myLeftSide) {
            this.myRightSide.getEditor().getContentComponent().requestFocus();
        } else {
            this.myLeftSide.getEditor().getContentComponent().requestFocus();
        }
    }

    private class MyGenericDataProvider
    extends GenericDataProvider {
        private DiffPanelImpl myDiffPanel;
        private final FocusDiffSide myFocusDiffSide = new FocusDiffSide(){

            @Override
            public Editor getEditor() {
                return MyGenericDataProvider.this.myDiffPanel.getCurrentSide().getEditor();
            }

            @Override
            public int[] getFragmentStartingLines() {
                return MyGenericDataProvider.this.myDiffPanel.getFragmentBeginnings();
            }
        };

        private MyGenericDataProvider(DiffPanelImpl diffPanel) {
            this.myDiffPanel = diffPanel;
        }

        @Override
        public Object getData(String dataId) {
            if (PlatformDataKeys.DIFF_VIEWER.is(dataId)) {
                return this.myDiffPanel;
            }
            if (FocusDiffSide.DATA_KEY.is(dataId)) {
                return this.myDiffPanel.myCurrentSide == null ? null : this.myFocusDiffSide;
            }
            return super.getData(dataId);
        }
    }

    private class MyScrollingPanel
    implements DiffPanelOutterComponent.ScrollingPanel {
        private MyScrollingPanel() {
        }

        @Override
        public void scrollEditors() {
            DiffPanelImpl.this.getOptions().onNewContent(DiffPanelImpl.this.myCurrentSide);
            int[] fragments = DiffPanelImpl.this.getFragmentBeginnings();
            if (fragments.length > 0) {
                DiffPanelImpl.this.myCurrentSide.scrollToFirstDiff(fragments[0]);
            }
        }
    }
}

