/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeConflict;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;

class ConflictChange
extends Change
implements DiffRangeMarker.RangeInvalidListener {
    private Change.Side myOriginalSide;
    private MergeConflict myConflict;

    public ConflictChange(MergeConflict conflict, FragmentSide mergeSide, TextRange range) {
        this.myConflict = conflict;
        this.myOriginalSide = new Change.Side(mergeSide, new DiffRangeMarker((DocumentEx)conflict.getOriginalDocument(mergeSide), range, this));
    }

    @Override
    protected void removeFromList() {
        this.myConflict.conflictRemoved();
        this.myConflict = null;
    }

    @Override
    public ChangeType.ChangeSide getChangeSide(FragmentSide side) {
        return this.isBranch(side) ? this.myOriginalSide : this.myConflict;
    }

    private boolean isBranch(FragmentSide side) {
        return MergeList.BRANCH_SIDE == side;
    }

    public Change.Side getOriginalSide() {
        return this.myOriginalSide;
    }

    @Override
    public ChangeType getType() {
        return ChangeType.CONFLICT;
    }

    @Override
    public ChangeList getChangeList() {
        return this.myConflict.getMergeList().getChanges(this.myOriginalSide.getFragmentSide());
    }

    @Override
    public void onRemovedFromList() {
        this.myConflict.onChangeRemoved(this.myOriginalSide.getFragmentSide(), this);
        this.myOriginalSide.getRange().removeListener(this);
        this.myConflict = null;
        this.myOriginalSide = null;
    }

    @Override
    public boolean isValid() {
        return this.myConflict != null;
    }

    @Override
    public void onRangeInvalidated() {
        this.removeFromList();
    }
}

