/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.splitter;

import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.splitter.DividerPoligon;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class DiffDividerPaint {
    private final EditingSides mySides;
    private final FragmentSide myLeftSide;

    public DiffDividerPaint(EditingSides sides, FragmentSide leftSide) {
        this.mySides = sides;
        this.myLeftSide = leftSide;
    }

    public void paint(Graphics g, JComponent component) {
        if (!this.hasAllEditors()) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        int editorHeight = this.mySides.getEditor(this.myLeftSide).getComponent().getHeight();
        DividerPoligon.paintPoligons(DividerPoligon.createVisiblePoligons(this.mySides, this.myLeftSide), (Graphics2D)g.create(0, height - editorHeight, width, editorHeight), width);
    }

    public EditingSides getSides() {
        return this.mySides;
    }

    public FragmentSide getLeftSide() {
        return this.myLeftSide;
    }

    private boolean hasAllEditors() {
        return this.mySides.getEditor(FragmentSide.SIDE1) != null && this.mySides.getEditor(FragmentSide.SIDE2) != null;
    }
}

