/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.util.Pair;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;

public class SyncScrollSupport
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.util.SyncScrollSupport");
    private boolean myDuringVerticalScroll = false;
    private final ArrayList<ScrollListener> myScrollers = new ArrayList();

    public void install(EditingSides[] sideContainers) {
        this.dispose();
        Editor[] editors = new Editor[sideContainers.length + 1];
        editors[0] = sideContainers[0].getEditor(FragmentSide.SIDE1);
        for (int i = 0; i < sideContainers.length; ++i) {
            EditingSides sideContainer = sideContainers[i];
            LOG.assertTrue(sideContainer.getEditor(FragmentSide.SIDE1) == editors[i]);
            editors[i + 1] = sideContainer.getEditor(FragmentSide.SIDE2);
        }
        if (editors.length == 3) {
            this.install3(editors, sideContainers);
        } else if (editors.length == 2) {
            this.install2(editors, sideContainers);
        } else {
            LOG.error(String.valueOf(editors.length));
        }
    }

    public void dispose() {
        for (ScrollListener scrollListener : this.myScrollers) {
            scrollListener.dispose();
        }
        this.myScrollers.clear();
    }

    private void install2(Editor[] editors, EditingSides[] sideContainers) {
        this.addSlavesScroller(editors[0], new Pair((Object)FragmentSide.SIDE1, (Object)sideContainers[0]));
        this.addSlavesScroller(editors[1], new Pair((Object)FragmentSide.SIDE2, (Object)sideContainers[0]));
    }

    private void install3(Editor[] editors, EditingSides[] sideContainers) {
        this.addSlavesScroller(editors[0], new Pair((Object)FragmentSide.SIDE1, (Object)sideContainers[0]), new Pair((Object)FragmentSide.SIDE1, (Object)sideContainers[1]));
        this.addSlavesScroller(editors[1], new Pair((Object)FragmentSide.SIDE2, (Object)sideContainers[0]), new Pair((Object)FragmentSide.SIDE1, (Object)sideContainers[1]));
        this.addSlavesScroller(editors[2], new Pair((Object)FragmentSide.SIDE2, (Object)sideContainers[1]), new Pair((Object)FragmentSide.SIDE2, (Object)sideContainers[0]));
    }

    private void addSlavesScroller(Editor editor, Pair<FragmentSide, EditingSides> ... contexts) {
        ScrollListener scroller = new ScrollListener(contexts, editor);
        scroller.install();
        this.myScrollers.add(scroller);
    }

    private static void syncHorizontalScroll(Pair<FragmentSide, EditingSides> context, Rectangle newRectangle, Rectangle oldRectangle) {
        FragmentSide masterSide;
        int newScrollOffset = newRectangle.x;
        if (newScrollOffset == oldRectangle.x) {
            return;
        }
        EditingSides sidesContainer = (EditingSides)context.getSecond();
        Editor slaveEditor = sidesContainer.getEditor((masterSide = (FragmentSide)context.getFirst()).otherSide());
        if (slaveEditor == null) {
            return;
        }
        ScrollingModel scrollingModel = slaveEditor.getScrollingModel();
        scrollingModel.disableAnimation();
        scrollingModel.scrollHorizontally(newScrollOffset);
        scrollingModel.enableAnimation();
    }

    private static void syncVerticalScroll(Pair<FragmentSide, EditingSides> context, Rectangle newRectangle, Rectangle oldRectangle) {
        if (newRectangle.y == oldRectangle.y && newRectangle.height == oldRectangle.height) {
            return;
        }
        EditingSides sidesContainer = (EditingSides)context.getSecond();
        FragmentSide masterSide = (FragmentSide)context.getFirst();
        Editor master = sidesContainer.getEditor(masterSide);
        Editor slave = sidesContainer.getEditor(masterSide.otherSide());
        if (master == null || slave == null) {
            return;
        }
        Rectangle viewRect = master.getScrollingModel().getVisibleArea();
        int middleY = viewRect.height / 3;
        int masterVerticalScrollOffset = SyncScrollSupport.getScrollOffset(master);
        int slaveVerticalScrollOffset = SyncScrollSupport.getScrollOffset(slave);
        LogicalPosition masterPos = master.xyToLogicalPosition(new Point(viewRect.x, masterVerticalScrollOffset + middleY));
        int masterCenterLine = masterPos.line;
        if (masterCenterLine > master.getDocument().getLineCount()) {
            masterCenterLine = master.getDocument().getLineCount();
        }
        int scrollToLine = sidesContainer.getLineBlocks().transform(masterSide, masterCenterLine) + 1;
        int actualLine = scrollToLine - 1;
        slave.getScrollingModel().disableAnimation();
        if (scrollToLine <= 0) {
            int offset = newRectangle.y - oldRectangle.y;
            slave.getScrollingModel().scrollVertically(slaveVerticalScrollOffset + offset);
        }
        int correction = (masterVerticalScrollOffset + middleY) % master.getLineHeight();
        int scrollOffset = actualLine * slave.getLineHeight() - middleY;
        slave.getScrollingModel().scrollVertically(scrollOffset + correction);
        slave.getScrollingModel().enableAnimation();
    }

    private static int getScrollOffset(Editor editor) {
        JComponent header = editor.getHeaderComponent();
        int headerOffset = header == null ? 0 : header.getHeight();
        return editor.getScrollingModel().getVerticalScrollOffset() - headerOffset;
    }

    public static void scrollEditor(Editor editor, int logicalLine) {
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(logicalLine, 0));
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        scrollingModel.scrollToCaret(ScrollType.CENTER);
        scrollingModel.enableAnimation();
    }

    private class ScrollListener
    implements VisibleAreaListener,
    Disposable {
        private final Pair<FragmentSide, EditingSides>[] myScrollContexts;
        private final Editor myEditor;

        public ScrollListener(Pair<FragmentSide, EditingSides>[] scrollContexts, Editor editor) {
            this.myScrollContexts = scrollContexts;
            this.myEditor = editor;
            this.install();
        }

        public void install() {
            this.myEditor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this);
        }

        public void dispose() {
            this.myEditor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (SyncScrollSupport.this.myDuringVerticalScroll) {
                return;
            }
            Rectangle newRectangle = e.getNewRectangle();
            Rectangle oldRectangle = e.getOldRectangle();
            if (newRectangle == null || oldRectangle == null) {
                return;
            }
            SyncScrollSupport.this.myDuringVerticalScroll = true;
            try {
                for (Pair<FragmentSide, EditingSides> context : this.myScrollContexts) {
                    SyncScrollSupport.syncVerticalScroll((Pair<FragmentSide, EditingSides>)context, newRectangle, oldRectangle);
                    SyncScrollSupport.syncHorizontalScroll((Pair<FragmentSide, EditingSides>)context, newRectangle, oldRectangle);
                }
            }
            finally {
                SyncScrollSupport.this.myDuringVerticalScroll = false;
            }
        }
    }
}

