/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Array;

public class SegmentArray {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.ex.util.SegmentArray");
    private int[] myStarts = new int[64];
    private int[] myEnds = new int[64];
    protected int mySegmentCount = 0;
    protected static final int INITIAL_SIZE = 64;

    protected SegmentArray() {
    }

    protected void setElementAt(int i, int startOffset, int endOffset) {
        if (startOffset < 0) {
            LOG.error("Invalid startOffset:" + startOffset);
        }
        if (endOffset < 0) {
            LOG.error("Invalid endOffset:" + endOffset);
        }
        if (i >= this.mySegmentCount) {
            this.mySegmentCount = i + 1;
        }
        this.myStarts = SegmentArray.reallocateArray(this.myStarts, i);
        this.myStarts[i] = startOffset;
        this.myEnds = SegmentArray.reallocateArray(this.myEnds, i);
        this.myEnds[i] = endOffset;
    }

    public void replace(int startOffset, SegmentArray data, int len) {
        System.arraycopy(data.myStarts, 0, this.myStarts, startOffset, len);
        System.arraycopy(data.myEnds, 0, this.myEnds, startOffset, len);
    }

    protected static int[] reallocateArray(int[] array, int index) {
        if (index < array.length) {
            return array;
        }
        int newArraySize = array.length;
        if (newArraySize == 0) {
            newArraySize = 16;
        }
        while (newArraySize <= index) {
            newArraySize = newArraySize * 120 / 100;
        }
        int[] newArray = new int[newArraySize];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    protected static <T> T[] reallocateArray(T[] array, int index) {
        if (index < array.length) {
            return array;
        }
        int newArraySize = array.length;
        if (newArraySize == 0) {
            newArraySize = 16;
        }
        while (newArraySize <= index) {
            newArraySize = newArraySize * 120 / 100;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), newArraySize);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    protected static short[] reallocateArray(short[] array, int index) {
        if (index < array.length) {
            return array;
        }
        int newArraySize = array.length;
        if (newArraySize == 0) {
            newArraySize = 16;
        }
        while (newArraySize <= index) {
            newArraySize = newArraySize * 120 / 100;
        }
        short[] newArray = new short[newArraySize];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public final int findSegmentIndex(int offset) {
        if (this.mySegmentCount <= 0) {
            if (offset == 0) {
                return 0;
            }
            throw new IllegalStateException("no segments avaliable");
        }
        int lastValidOffset = this.getLastValidOffset();
        if (offset > lastValidOffset || offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + ". Should be in range: [0, " + lastValidOffset + "]");
        }
        int lastValidIndex = this.mySegmentCount - 1;
        if (offset == lastValidOffset) {
            return lastValidIndex;
        }
        int start = 0;
        int end = lastValidIndex;
        while (start < end) {
            int i = (start + end) / 2;
            if (offset < this.myStarts[i]) {
                end = i - 1;
                continue;
            }
            if (offset >= this.myEnds[i]) {
                start = i + 1;
                continue;
            }
            return i;
        }
        assert (this.myStarts[start] <= offset && offset < this.myEnds[start]) : start;
        return start;
    }

    public int getLastValidOffset() {
        return this.mySegmentCount == 0 ? 0 : this.myEnds[this.mySegmentCount - 1];
    }

    public final void changeSegmentLength(int startIndex, int change) {
        if (startIndex >= 0 && startIndex < this.mySegmentCount) {
            int n = startIndex;
            this.myEnds[n] = this.myEnds[n] + change;
        }
        this.shiftSegments(startIndex + 1, change);
    }

    public final void shiftSegments(int startIndex, int shift) {
        for (int i = startIndex; i < this.mySegmentCount; ++i) {
            int n = i;
            this.myStarts[n] = this.myStarts[n] + shift;
            int n2 = i;
            this.myEnds[n2] = this.myEnds[n2] + shift;
            if (this.myStarts[i] >= 0 && this.myEnds[i] >= 0) continue;
            LOG.error("Error shifting segments: myStarts[" + i + "] = " + this.myStarts[i] + ", myEnds[" + i + "] = " + this.myEnds[i]);
        }
    }

    public void removeAll() {
        this.mySegmentCount = 0;
    }

    public void remove(int startIndex, int endIndex) {
        this.myStarts = this.remove(this.myStarts, startIndex, endIndex);
        this.myEnds = this.remove(this.myEnds, startIndex, endIndex);
        this.mySegmentCount -= endIndex - startIndex;
    }

    protected int[] remove(int[] array, int startIndex, int endIndex) {
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        return array;
    }

    protected <T> T[] remove(T[] array, int startIndex, int endIndex) {
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        return array;
    }

    protected short[] remove(short[] array, int startIndex, int endIndex) {
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        return array;
    }

    protected long[] remove(long[] array, int startIndex, int endIndex) {
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        return array;
    }

    protected void insert(SegmentArray segmentArray, int startIndex) {
        this.myStarts = this.insert(this.myStarts, segmentArray.myStarts, startIndex, segmentArray.getSegmentCount());
        this.myEnds = this.insert(this.myEnds, segmentArray.myEnds, startIndex, segmentArray.getSegmentCount());
        this.mySegmentCount += segmentArray.getSegmentCount();
    }

    protected int[] insert(int[] array, int[] insertArray, int startIndex, int insertLength) {
        int[] newArray = SegmentArray.reallocateArray(array, this.mySegmentCount + insertLength);
        if (startIndex < this.mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        return newArray;
    }

    protected <T> T[] insert(T[] array, T[] insertArray, int startIndex, int insertLength) {
        T[] newArray = SegmentArray.reallocateArray(array, this.mySegmentCount + insertLength);
        if (startIndex < this.mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        return newArray;
    }

    protected short[] insert(short[] array, short[] insertArray, int startIndex, int insertLength) {
        short[] newArray = SegmentArray.reallocateArray(array, this.mySegmentCount + insertLength);
        if (startIndex < this.mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        return newArray;
    }

    public int getSegmentStart(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong line: " + index);
        }
        return this.myStarts[index];
    }

    public int getSegmentEnd(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong line: " + index);
        }
        return this.myEnds[index];
    }

    public int getSegmentCount() {
        return this.mySegmentCount;
    }
}

