/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;

public class FileDropHandler
implements EditorDropHandler {
    @Override
    public boolean canHandleDrop(DataFlavor[] transferFlavors) {
        for (DataFlavor transferFlavor : transferFlavors) {
            if (!transferFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleDrop(Transferable t, Project project) {
        List fileList;
        if (project == null) {
            return;
        }
        try {
            fileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (Exception ex) {
            return;
        }
        if (fileList != null) {
            for (File file : fileList) {
                VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                if (vFile == null) continue;
                new OpenFileDescriptor(project, vFile).navigate(true);
            }
        }
    }
}

