/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.RecursiveFileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;

public class SwitchedFileHolder
extends RecursiveFileHolder {
    public SwitchedFileHolder(Project project, FileHolder.HolderType holderType) {
        super(project, holderType);
    }

    public void takeFrom(SwitchedFileHolder holder) {
        this.myFiles.clear();
        this.myFiles.putAll(holder.myFiles);
        if (this.mySwitchRoots != null) {
            this.mySwitchRoots.clear();
            this.mySwitchRoots.addAll(holder.mySwitchRoots);
        }
    }

    @Override
    public SwitchedFileHolder copy() {
        SwitchedFileHolder copyHolder = new SwitchedFileHolder(this.myProject, this.myHolderType);
        copyHolder.myFiles.putAll(this.myFiles);
        return copyHolder;
    }

    @Override
    protected boolean isFileDirty(VcsDirtyScope scope, VirtualFile file) {
        if (scope == null) {
            return true;
        }
        if (this.fileDropped(file)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && scope.isRecursivelyDirty(parent);
    }

    public Map<VirtualFile, String> getFilesMapCopy() {
        return new HashMap<VirtualFile, String>(this.myFiles);
    }
}

