/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;

public class EditAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        List files = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        EditAction.editFilesAndShowErrors(project, files);
    }

    public static void editFilesAndShowErrors(Project project, List<VirtualFile> files) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        EditAction.editFiles(project, files, exceptions);
        if (!exceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, VcsBundle.message((String)"edit.errors", (Object[])new Object[0]));
        }
    }

    public static void editFiles(final Project project, List<VirtualFile> files, final List<VcsException> exceptions) {
        ChangesUtil.processVirtualFilesByVcs((Project)project, files, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<VirtualFile>(){

            public void process(AbstractVcs vcs, List<VirtualFile> items) {
                EditFileProvider provider = vcs.getEditFileProvider();
                if (provider != null) {
                    try {
                        provider.editFiles(VfsUtil.toVirtualFileArray(items));
                    }
                    catch (VcsException e1) {
                        exceptions.add(e1);
                    }
                    for (VirtualFile file : items) {
                        VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
                        FileStatusManager.getInstance((Project)project).fileStatusChanged(file);
                    }
                }
            }
        });
    }

    public void update(AnActionEvent e) {
        List files = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        boolean enabled = files != null && !files.isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }
}

