/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CommittedChangesTableModel
extends ListTableModel<CommittedChangeList> {
    private final boolean myAsynchLoad;
    private static final ChangeListColumn[] ourDefaultColumns = new ChangeListColumn[]{ChangeListColumn.DATE, ChangeListColumn.NAME};

    public CommittedChangesTableModel(List<CommittedChangeList> changeLists, boolean asynchLoad) {
        super(CommittedChangesTableModel.buildColumnInfos(ourDefaultColumns), changeLists, 0);
        this.myAsynchLoad = asynchLoad;
    }

    public CommittedChangesTableModel(List<CommittedChangeList> changeLists, ChangeListColumn[] columns, boolean asynchLoad) {
        super(CommittedChangesTableModel.buildColumnInfos(columns), changeLists, 0);
        this.myAsynchLoad = asynchLoad;
    }

    public void sortByChangesColumn(ChangeListColumn column, int sortingType) {
        if (column == null) {
            return;
        }
        ColumnInfo[] columnInfos = this.getColumnInfos();
        for (int i = 0; i < columnInfos.length; ++i) {
            ColumnInfoAdapter adapter = (ColumnInfoAdapter)columnInfos[i];
            if (adapter.getColumn() != column) continue;
            this.sortByColumn(i, sortingType);
            break;
        }
    }

    @Nullable
    public ChangeListColumn getSortColumn() {
        int index = this.getSortedColumnIndex();
        if (index < 0) {
            return null;
        }
        return ((ColumnInfoAdapter)this.getColumnInfos()[index]).getColumn();
    }

    private static ColumnInfo[] buildColumnInfos(ChangeListColumn[] columns) {
        ColumnInfo[] result = new ColumnInfo[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            result[i] = new ColumnInfoAdapter(columns[i]);
        }
        return result;
    }

    public boolean isAsynchLoad() {
        return this.myAsynchLoad;
    }

    private static class ColumnInfoAdapter
    extends ColumnInfo {
        private final ChangeListColumn myColumn;

        public ColumnInfoAdapter(ChangeListColumn column) {
            super(column.getTitle());
            this.myColumn = column;
        }

        public Object valueOf(Object o) {
            return this.myColumn.getValue((ChangeList)o);
        }

        public Comparator getComparator() {
            return this.myColumn.getComparator();
        }

        public ChangeListColumn getColumn() {
            return this.myColumn;
        }
    }
}

