/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.CommonBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.configurable.ModuleVcsListener;
import com.intellij.openapi.vcs.configurable.VcsConfigurationsDialog;
import com.intellij.openapi.vcs.configurable.VcsMappingConfigurationDialog;
import com.intellij.openapi.vcs.configurable.VcsWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.PanelWithButtons;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;

public class VcsDirectoryConfigurationPanel
extends PanelWithButtons
implements Configurable {
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final TableView<VcsDirectoryMapping> myDirectoryMappingTable;
    private final ComboboxWithBrowseButton myVcsComboBox = new ComboboxWithBrowseButton();
    private final List<ModuleVcsListener> myListeners = new ArrayList<ModuleVcsListener>();
    private final ColumnInfo<VcsDirectoryMapping, String> DIRECTORY = new ColumnInfo<VcsDirectoryMapping, String>(VcsBundle.message((String)"column.info.configure.vcses.directory", (Object[])new Object[0])){

        public String valueOf(VcsDirectoryMapping mapping) {
            String directory = mapping.getDirectory();
            if (directory.length() == 0) {
                return "<Project Root>";
            }
            VirtualFile baseDir = VcsDirectoryConfigurationPanel.this.myProject.getBaseDir();
            if (baseDir != null) {
                return FileUtil.getRelativePath((File)new File(baseDir.getPath()), (File)new File(directory));
            }
            return directory;
        }
    };
    private final ColumnInfo<VcsDirectoryMapping, String> VCS_SETTING = new ColumnInfo<VcsDirectoryMapping, String>(VcsBundle.message((String)"comumn.name.configure.vcses.vcs", (Object[])new Object[0])){

        public String valueOf(VcsDirectoryMapping object) {
            return object.getVcs();
        }

        public boolean isCellEditable(VcsDirectoryMapping o) {
            return true;
        }

        public void setValue(VcsDirectoryMapping o, String aValue) {
            Collection<AbstractVcs> activeVcses = VcsDirectoryConfigurationPanel.this.getActiveVcses();
            o.setVcs(aValue);
            VcsDirectoryConfigurationPanel.this.checkNotifyListeners(activeVcses);
        }

        public TableCellRenderer getRenderer(final VcsDirectoryMapping p0) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    AbstractVcs vcs;
                    String vcsName = p0.getVcs();
                    String text = vcsName.length() == 0 ? VcsBundle.message((String)"none.vcs.presentation", (Object[])new Object[0]) : ((vcs = VcsDirectoryConfigurationPanel.this.myVcsManager.findVcsByName(vcsName)) != null ? vcs.getDisplayName() : VcsBundle.message((String)"unknown.vcs.presentation", (Object[])new Object[]{vcsName}));
                    this.append(text, new SimpleTextAttributes(0, table.getForeground()));
                }
            };
        }

        public TableCellEditor getEditor(VcsDirectoryMapping o) {
            return new AbstractTableCellEditor(){

                public Object getCellEditorValue() {
                    VcsWrapper selectedVcs = (VcsWrapper)VcsDirectoryConfigurationPanel.this.myVcsComboBox.getComboBox().getSelectedItem();
                    return selectedVcs == null || selectedVcs.getOriginal() == null ? "" : selectedVcs.getOriginal().getName();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    String vcsName = (String)value;
                    VcsDirectoryConfigurationPanel.this.myVcsComboBox.getComboBox().setSelectedItem(VcsWrapper.fromName(VcsDirectoryConfigurationPanel.this.myProject, vcsName));
                    return VcsDirectoryConfigurationPanel.this.myVcsComboBox;
                }
            };
        }
    };
    private ListTableModel<VcsDirectoryMapping> myModel;
    private JButton myAddButton;
    private JButton myEditButton;
    private JButton myRemoveButton;

    public VcsDirectoryConfigurationPanel(final Project project) {
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myDirectoryMappingTable = new TableView();
        this.initializeModel();
        this.myVcsComboBox.getComboBox().setModel(VcsDirectoryConfigurationPanel.buildVcsWrappersModel(this.myProject));
        this.myVcsComboBox.getComboBox().setRenderer(new EditorComboBoxRenderer(this.myVcsComboBox.getComboBox().getEditor()));
        this.myVcsComboBox.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable != null && VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable.isEditing()) {
                    VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable.stopEditing();
                }
            }
        });
        this.myVcsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsWrapper vcsWrapper = (VcsWrapper)VcsDirectoryConfigurationPanel.this.myVcsComboBox.getComboBox().getSelectedItem();
                AbstractVcs abstractVcs = null;
                if (vcsWrapper != null) {
                    abstractVcs = vcsWrapper.getOriginal();
                }
                new VcsConfigurationsDialog(project, VcsDirectoryConfigurationPanel.this.myVcsComboBox.getComboBox(), abstractVcs).show();
            }
        });
        this.myDirectoryMappingTable.setRowHeight(this.myVcsComboBox.getPreferredSize().height);
        this.myDirectoryMappingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VcsDirectoryConfigurationPanel.this.updateButtons();
            }
        });
        this.initPanel();
        this.updateButtons();
    }

    private void initializeModel() {
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>();
        for (VcsDirectoryMapping mapping : ProjectLevelVcsManager.getInstance((Project)this.myProject).getDirectoryMappings()) {
            mappings.add(new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings()));
        }
        this.myModel = new ListTableModel(new ColumnInfo[]{this.DIRECTORY, this.VCS_SETTING}, mappings, 0);
        this.myDirectoryMappingTable.setModel(this.myModel);
    }

    private void updateButtons() {
        boolean hasSelection = this.myDirectoryMappingTable.getSelectedObject() != null;
        this.myEditButton.setEnabled(hasSelection);
        this.myRemoveButton.setEnabled(hasSelection);
    }

    public static DefaultComboBoxModel buildVcsWrappersModel(Project project) {
        AbstractVcs[] vcss = ProjectLevelVcsManager.getInstance((Project)project).getAllVcss();
        VcsWrapper[] vcsWrappers = new VcsWrapper[vcss.length + 1];
        vcsWrappers[0] = new VcsWrapper(null);
        for (int i = 0; i < vcss.length; ++i) {
            vcsWrappers[i + 1] = new VcsWrapper(vcss[i]);
        }
        return new DefaultComboBoxModel<VcsWrapper>(vcsWrappers);
    }

    protected String getLabelText() {
        return null;
    }

    protected JButton[] createButtons() {
        this.myAddButton = new JButton(CommonBundle.message((String)"button.add", (Object[])new Object[0]));
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsDirectoryConfigurationPanel.this.addMapping();
            }
        });
        this.myEditButton = new JButton(CommonBundle.message((String)"button.edit", (Object[])new Object[0]));
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsDirectoryConfigurationPanel.this.editMapping();
            }
        });
        this.myRemoveButton = new JButton(CommonBundle.message((String)"button.remove", (Object[])new Object[0]));
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsDirectoryConfigurationPanel.this.removeMapping();
            }
        });
        return new JButton[]{this.myAddButton, this.myEditButton, this.myRemoveButton};
    }

    private void addMapping() {
        Collection<AbstractVcs> activeVcses = this.getActiveVcses();
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message((String)"directory.mapping.add.title", (Object[])new Object[0]));
        dlg.show();
        if (dlg.isOK()) {
            VcsDirectoryMapping mapping = new VcsDirectoryMapping();
            dlg.saveToMapping(mapping);
            ArrayList<VcsDirectoryMapping> items = new ArrayList<VcsDirectoryMapping>(this.myModel.getItems());
            items.add(mapping);
            this.myModel.setItems(items);
            this.checkNotifyListeners(activeVcses);
        }
    }

    private void editMapping() {
        Collection<AbstractVcs> activeVcses = this.getActiveVcses();
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message((String)"directory.mapping.remove.title", (Object[])new Object[0]));
        VcsDirectoryMapping mapping = (VcsDirectoryMapping)this.myDirectoryMappingTable.getSelectedObject();
        dlg.setMapping(mapping);
        dlg.show();
        if (dlg.isOK()) {
            dlg.saveToMapping(mapping);
            this.myModel.fireTableDataChanged();
            this.checkNotifyListeners(activeVcses);
        }
    }

    private void removeMapping() {
        Collection<AbstractVcs> activeVcses = this.getActiveVcses();
        ArrayList mappings = new ArrayList(this.myModel.getItems());
        int index = this.myDirectoryMappingTable.getSelectionModel().getMinSelectionIndex();
        Collection selection = this.myDirectoryMappingTable.getSelection();
        mappings.removeAll(selection);
        this.myModel.setItems(mappings);
        if (mappings.size() > 0) {
            if (index >= mappings.size()) {
                index = mappings.size() - 1;
            }
            this.myDirectoryMappingTable.getSelectionModel().setSelectionInterval(index, index);
        }
        this.checkNotifyListeners(activeVcses);
    }

    protected JComponent createMainComponent() {
        return new JScrollPane((Component)this.myDirectoryMappingTable);
    }

    public void reset() {
        this.initializeModel();
    }

    public void apply() {
        this.myVcsManager.setDirectoryMappings(this.myModel.getItems());
        this.initializeModel();
    }

    public boolean isModified() {
        return !((Object)this.myModel.getItems()).equals(this.myVcsManager.getDirectoryMappings());
    }

    public void addVcsListener(ModuleVcsListener moduleVcsListener) {
        this.myListeners.add(moduleVcsListener);
    }

    public void removeVcsListener(ModuleVcsListener moduleVcsListener) {
        this.myListeners.remove(moduleVcsListener);
    }

    private void checkNotifyListeners(Collection<AbstractVcs> oldVcses) {
        Collection<AbstractVcs> vcses = this.getActiveVcses();
        if (!((Object)vcses).equals(oldVcses)) {
            for (ModuleVcsListener listener : this.myListeners) {
                listener.activeVcsSetChanged(vcses);
            }
        }
    }

    public Collection<AbstractVcs> getActiveVcses() {
        HashSet<AbstractVcs> vcses = new HashSet<AbstractVcs>();
        for (VcsDirectoryMapping mapping : this.myModel.getItems()) {
            if (mapping.getVcs().length() <= 0) continue;
            vcses.add(this.myVcsManager.findVcsByName(mapping.getVcs()));
        }
        return vcses;
    }

    @Nls
    public String getDisplayName() {
        return "Mappings";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
    }
}

