/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.configurable.VcsConfigurationsDialog;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VcsMappingConfigurationDialog
extends DialogWrapper {
    private final Project myProject;
    private JComboBox myVCSComboBox;
    private TextFieldWithBrowseButton myDirectoryTextField;
    private JPanel myPanel;
    private JPanel myVcsConfigurablePlaceholder;
    private UnnamedConfigurable myVcsConfigurable;
    private VcsDirectoryMapping myMappingCopy;
    private JComponent myVcsConfigurableComponent;

    public VcsMappingConfigurationDialog(Project project, String title) {
        super(project, false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myVCSComboBox.setModel(VcsDirectoryConfigurationPanel.buildVcsWrappersModel(project));
        this.myDirectoryTextField.addActionListener((ActionListener)((Object)new MyBrowseFolderListener("Select Directory", "Select directory to map to a VCS", this.myDirectoryTextField, project, new FileChooserDescriptor(false, true, false, false, false, false))));
        this.myMappingCopy = new VcsDirectoryMapping("", "");
        this.setTitle(title);
        this.init();
        this.myVCSComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsMappingConfigurationDialog.this.updateVcsConfigurable();
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public void setMapping(VcsDirectoryMapping mapping) {
        this.myMappingCopy = new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings());
        this.myVCSComboBox.setSelectedItem(VcsWrapper.fromName(this.myProject, mapping.getVcs()));
        this.myDirectoryTextField.setText(FileUtil.toSystemDependentName((String)mapping.getDirectory()));
        this.updateVcsConfigurable();
    }

    public void saveToMapping(VcsDirectoryMapping mapping) {
        VcsWrapper wrapper = (VcsWrapper)this.myVCSComboBox.getSelectedItem();
        mapping.setVcs(wrapper.getOriginal() == null ? "" : wrapper.getOriginal().getName());
        mapping.setDirectory(FileUtil.toSystemIndependentName((String)this.myDirectoryTextField.getText()));
        mapping.setRootSettings(this.myMappingCopy.getRootSettings());
    }

    private void updateVcsConfigurable() {
        UnnamedConfigurable configurable;
        VcsWrapper wrapper;
        if (this.myVcsConfigurable != null) {
            this.myVcsConfigurablePlaceholder.remove(this.myVcsConfigurableComponent);
            this.myVcsConfigurable.disposeUIResources();
            this.myVcsConfigurable = null;
        }
        if ((wrapper = (VcsWrapper)this.myVCSComboBox.getSelectedItem()).getOriginal() != null && (configurable = wrapper.getOriginal().getRootConfigurable(this.myMappingCopy)) != null) {
            this.myVcsConfigurable = configurable;
            this.myVcsConfigurableComponent = this.myVcsConfigurable.createComponent();
            this.myVcsConfigurablePlaceholder.add((Component)this.myVcsConfigurableComponent, "Center");
        }
        this.pack();
    }

    protected Action[] createLeftSideActions() {
        return new Action[]{new ConfigureVcsAction()};
    }

    protected void doOKAction() {
        if (this.myVcsConfigurable != null) {
            try {
                this.myVcsConfigurable.apply();
            }
            catch (ConfigurationException ex) {
                Messages.showErrorDialog((Component)this.myPanel, (String)("Invalid VCS options: " + ex.getMessage()));
            }
        }
        super.doOKAction();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Directory:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("VCS:");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(300, -1), null));
        this.myVCSComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myVcsConfigurablePlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class ConfigureVcsAction
    extends AbstractAction {
        public ConfigureVcsAction() {
            super(VcsBundle.message((String)"button.configure", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VcsWrapper wrapper = (VcsWrapper)VcsMappingConfigurationDialog.this.myVCSComboBox.getSelectedItem();
            new VcsConfigurationsDialog(VcsMappingConfigurationDialog.this.myProject, null, wrapper.getOriginal()).show();
        }
    }

    private class MyBrowseFolderListener
    extends ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> {
        public MyBrowseFolderListener(String title, String description, TextFieldWithBrowseButton textField, Project project, FileChooserDescriptor fileChooserDescriptor) {
            super(title, description, (ComponentWithBrowseButton)textField, project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        }

        protected VirtualFile getInitialFile() {
            VirtualFile file;
            String text = this.getComponentText();
            if (text.length() == 0 && (file = VcsMappingConfigurationDialog.this.myProject.getBaseDir()) != null) {
                return file;
            }
            return super.getInitialFile();
        }

        protected void onFileChoosen(VirtualFile chosenFile) {
            String oldText = VcsMappingConfigurationDialog.this.myDirectoryTextField.getText();
            super.onFileChoosen(chosenFile);
            VcsWrapper wrapper = (VcsWrapper)VcsMappingConfigurationDialog.this.myVCSComboBox.getSelectedItem();
            if (oldText.length() == 0 && wrapper.getOriginal() == null) {
                for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance((Project)VcsMappingConfigurationDialog.this.myProject).getAllVcss()) {
                    if (!vcs.isVersionedDirectory(chosenFile)) continue;
                    VcsMappingConfigurationDialog.this.myVCSComboBox.setSelectedItem(new VcsWrapper(vcs));
                    break;
                }
            }
        }
    }
}

