/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.FragmentContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.ShowNextChangeMarkerAction;
import com.intellij.openapi.vcs.actions.ShowPrevChangeMarkerAction;
import com.intellij.openapi.vcs.ex.DocumentWrapper;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SideBorder2;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.ex.LineStatusTracker");
    private final Document myDocument;
    private final Document myUpToDateDocument;
    private List<Range> myRanges = new ArrayList<Range>();
    private final Project myProject;
    private int myHighlighterCount = 0;
    private MyDocumentListener myDocumentListener;
    private boolean myIsReleased = false;
    private boolean myIsInitialized = false;
    private boolean myBulkUpdate;

    public LineStatusTracker(Document document, Document upToDateDocument, Project project) {
        this.myDocument = document;
        this.myUpToDateDocument = upToDateDocument;
        this.myUpToDateDocument.putUserData(UndoManager.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize(final @NotNull String upToDateContent) {
        if (upToDateContent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/ex/LineStatusTracker.initialize must not be null");
        }
        if (this.myIsReleased) {
            return;
        }
        LOG.assertTrue(!this.myIsInitialized);
        try {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    LineStatusTracker.this.myUpToDateDocument.replaceString(0, LineStatusTracker.this.myUpToDateDocument.getTextLength(), (CharSequence)StringUtil.convertLineSeparators((String)upToDateContent));
                }
            });
            this.myUpToDateDocument.setReadOnly(true);
            this.reinstallRanges();
            this.myDocumentListener = new MyDocumentListener();
            this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener);
        }
        finally {
            this.myIsInitialized = true;
        }
    }

    private synchronized void reinstallRanges() {
        this.reinstallRanges(new RangesBuilder(this.myDocument, this.myUpToDateDocument).getRanges());
    }

    private void reinstallRanges(List<Range> ranges) {
        this.removeHighlighters();
        this.myRanges = ranges;
        this.addHighlighters();
    }

    private void addHighlighters() {
        for (Range range : this.myRanges) {
            if (range.hasHighlighter()) continue;
            range.setHighlighter(this.createHighlighter(range));
        }
    }

    private synchronized RangeHighlighter createHighlighter(Range range) {
        int first = range.getOffset1() >= this.myDocument.getLineCount() ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getOffset1());
        int second = range.getOffset2() >= this.myDocument.getLineCount() ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getOffset2());
        RangeHighlighter highlighter = this.myDocument.getMarkupModel(this.myProject).addRangeHighlighter(first, second, 999, null, HighlighterTargetArea.LINES_IN_RANGE);
        ++this.myHighlighterCount;
        TextAttributes attr = LineStatusTracker.getAttributesFor(range);
        highlighter.setErrorStripeMarkColor(attr.getErrorStripeColor());
        highlighter.setThinErrorStripeMark(true);
        highlighter.setGreedyToLeft(true);
        highlighter.setGreedyToRight(true);
        highlighter.setLineMarkerRenderer(this.createRenderer(range));
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
        int line1 = this.myDocument.getLineNumber(first);
        int line2 = this.myDocument.getLineNumber(second);
        String tooltip = line1 == line2 ? VcsBundle.message((String)"tooltip.text.line.changed", (Object[])new Object[]{line1}) : VcsBundle.message((String)"tooltip.text.lines.changed", (Object[])new Object[]{line1, line2});
        highlighter.setErrorStripeTooltip((Object)tooltip);
        return highlighter;
    }

    private void removeHighlighters() {
        for (Range oldRange : this.myRanges) {
            this.removeHighlighter(oldRange.getHighlighter());
            oldRange.setHighlighter(null);
        }
    }

    synchronized void removeHighlighter(RangeHighlighter highlighter) {
        if (highlighter == null) {
            return;
        }
        MarkupModel markupModel = this.myDocument.getMarkupModel(this.myProject);
        if (markupModel == null) {
            return;
        }
        markupModel.removeHighlighter(highlighter);
        --this.myHighlighterCount;
    }

    private static TextAttributesKey getDiffColor(Range range) {
        switch (range.getType()) {
            case 2: {
                return DiffColors.DIFF_INSERTED;
            }
            case 3: {
                return DiffColors.DIFF_DELETED;
            }
            case 1: {
                return DiffColors.DIFF_MODIFIED;
            }
        }
        assert (false);
        return null;
    }

    private static ColorKey getEditorColorNameFor(Range range) {
        switch (range.getType()) {
            case 1: {
                return EditorColors.MODIFIED_LINES_COLOR;
            }
        }
        return EditorColors.ADDED_LINES_COLOR;
    }

    private static TextAttributes getAttributesFor(Range range) {
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = globalScheme.getColor(LineStatusTracker.getEditorColorNameFor(range));
        TextAttributes textAttributes = new TextAttributes(null, color, null, EffectType.BOXED, 0);
        textAttributes.setErrorStripeColor(color);
        return textAttributes;
    }

    private static void paintGutterFragment(Editor editor, Graphics g, Rectangle r, TextAttributesKey diffAttributeKey) {
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        g.setColor(editor.getColorsScheme().getAttributes(diffAttributeKey).getBackgroundColor());
        int endX = gutter.getWhitespaceSeparatorOffset();
        int x = r.x + r.width - 2;
        int width = endX - x;
        if (r.height > 0) {
            g.fillRect(x, r.y + 2, width, r.height - 4);
            g.setColor(gutter.getFoldingColor(false));
            UIUtil.drawLine((Graphics)g, (int)x, (int)(r.y + 2), (int)(x + width), (int)(r.y + 2));
            UIUtil.drawLine((Graphics)g, (int)x, (int)(r.y + 2), (int)x, (int)(r.y + r.height - 3));
            UIUtil.drawLine((Graphics)g, (int)x, (int)(r.y + r.height - 3), (int)(x + width), (int)(r.y + r.height - 3));
        } else {
            int[] xPoints = new int[]{x, x, x + width - 1};
            int[] yPoints = new int[]{r.y - 4, r.y + 4, r.y};
            g.fillPolygon(xPoints, yPoints, 3);
            g.setColor(gutter.getFoldingColor(false));
            g.drawPolygon(xPoints, yPoints, 3);
        }
    }

    private LineMarkerRenderer createRenderer(final Range range) {
        return new ActiveGutterRenderer(){

            public void paint(Editor editor, Graphics g, Rectangle r) {
                LineStatusTracker.paintGutterFragment(editor, g, r, LineStatusTracker.getDiffColor(range));
            }

            public void doAction(Editor editor, MouseEvent e) {
                e.consume();
                JComponent comp = (JComponent)e.getComponent();
                JLayeredPane layeredPane = comp.getRootPane().getLayeredPane();
                Point point = SwingUtilities.convertPoint(comp, ((EditorEx)editor).getGutterComponentEx().getWidth(), e.getY(), layeredPane);
                LineStatusTracker.this.showActiveHint(range, editor, point);
            }

            public boolean canDoAction(MouseEvent e) {
                EditorGutterComponentEx gutter = (EditorGutterComponentEx)e.getComponent();
                return e.getX() > gutter.getLineMarkerAreaOffset() + gutter.getIconsAreaWidth();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        try {
            if (!this.myIsInitialized) {
                return;
            }
            LOG.assertTrue(!this.myIsReleased);
            this.removeHighlighters();
            if (this.myDocumentListener != null) {
                this.myDocument.removeDocumentListener((DocumentListener)this.myDocumentListener);
                this.myDocumentListener = null;
            }
        }
        finally {
            this.myIsReleased = true;
        }
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public VirtualFile getVirtualFile() {
        return FileDocumentManager.getInstance().getFile(this.getDocument());
    }

    public List<Range> getRanges() {
        return this.myRanges;
    }

    public Document getUpToDateDocument() {
        return this.myUpToDateDocument;
    }

    public void startBulkUpdate() {
        this.myBulkUpdate = true;
        for (Range oldRange : this.myRanges) {
            this.removeHighlighter(oldRange.getHighlighter());
            oldRange.setHighlighter(null);
        }
        this.myRanges.clear();
    }

    public void finishBulkUpdate() {
        if (this.myBulkUpdate) {
            this.myBulkUpdate = false;
            this.reinstallRanges();
        }
    }

    private List<Range> getChangedRanges(int from, int to) {
        return LineStatusTracker.getChangedRanges(this.myRanges, from, to);
    }

    public static List<Range> getChangedRanges(List<Range> ranges, int from, int to) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (Range range : ranges) {
            if (range.getOffset1() > to || range.getOffset2() < from) continue;
            result.add(range);
        }
        return result;
    }

    private List<Range> getRangesBefore(int line) {
        return LineStatusTracker.getRangesBefore(this.myRanges, line);
    }

    public static List<Range> getRangesBefore(List<Range> ranges, int line) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (Range range : ranges) {
            if (range.getOffset2() >= line) continue;
            result.add(range);
        }
        return result;
    }

    private List<Range> getRangesAfter(int line) {
        return LineStatusTracker.getRangesAfter(this.myRanges, line);
    }

    public static List<Range> getRangesAfter(List<Range> ranges, int line) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (Range range : ranges) {
            if (range.getOffset1() <= line) continue;
            result.add(range);
        }
        return result;
    }

    public void moveToRange(final Range range, final Editor editor) {
        final int firstOffset = this.myDocument.getLineStartOffset(Math.min(range.getOffset1(), this.myDocument.getLineCount() - 1));
        editor.getCaretModel().moveToOffset(firstOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        editor.getScrollingModel().runActionOnScrollingFinished(new Runnable(){

            @Override
            public void run() {
                Point p = editor.visualPositionToXY(editor.offsetToVisualPosition(firstOffset));
                JComponent editorComponent = editor.getContentComponent();
                JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
                p = SwingUtilities.convertPoint(editorComponent, 0, p.y, layeredPane);
                LineStatusTracker.this.showActiveHint(range, editor, p);
            }
        });
    }

    @Nullable
    private Range getNextRange(Range range) {
        int index = this.myRanges.indexOf(range);
        if (index == this.myRanges.size() - 1) {
            return null;
        }
        return this.myRanges.get(index + 1);
    }

    @Nullable
    private Range getPrevRange(Range range) {
        int index = this.myRanges.indexOf(range);
        if (index <= 0) {
            return null;
        }
        return this.myRanges.get(index - 1);
    }

    @Nullable
    public Range getNextRange(int line) {
        Range currentRange = this.getRangeForLine(line);
        if (currentRange != null) {
            return this.getNextRange(currentRange);
        }
        for (Range range : this.myRanges) {
            if (line > range.getOffset1() || line > range.getOffset2()) continue;
            return range;
        }
        return null;
    }

    @Nullable
    public Range getPrevRange(int line) {
        Range currentRange = this.getRangeForLine(line);
        if (currentRange != null) {
            return this.getPrevRange(currentRange);
        }
        ListIterator<Range> iterator = this.myRanges.listIterator(this.myRanges.size());
        while (iterator.hasPrevious()) {
            Range range = iterator.previous();
            if (range.getOffset1() > line) continue;
            return range;
        }
        return null;
    }

    @Nullable
    public Range getRangeForLine(int line) {
        for (Range range : this.myRanges) {
            if (range.getType() == 3 && line == range.getOffset1()) {
                return range;
            }
            if (line < range.getOffset1() || line >= range.getOffset2()) continue;
            return range;
        }
        return null;
    }

    public void rollbackChanges(Range range) {
        TextRange currentTextRange = this.getCurrentTextRange(range);
        if (range.getType() == 2) {
            this.myDocument.replaceString(currentTextRange.getStartOffset(), Math.min(currentTextRange.getEndOffset() + 1, this.myDocument.getTextLength()), (CharSequence)"");
        } else if (range.getType() == 3) {
            String upToDateContent = this.getUpToDateContent(range);
            this.myDocument.insertString(currentTextRange.getStartOffset(), (CharSequence)upToDateContent);
        } else {
            String upToDateContent = this.getUpToDateContent(range);
            this.myDocument.replaceString(currentTextRange.getStartOffset(), Math.min(currentTextRange.getEndOffset() + 1, this.myDocument.getTextLength()), (CharSequence)upToDateContent);
        }
    }

    public String getUpToDateContent(Range range) {
        TextRange textRange = this.getUpToDateRange(range);
        int startOffset = textRange.getStartOffset();
        int endOffset = Math.min(textRange.getEndOffset() + 1, this.myUpToDateDocument.getTextLength());
        return ((Object)this.myUpToDateDocument.getCharsSequence().subSequence(startOffset, endOffset)).toString();
    }

    private Project getProject() {
        return this.myProject;
    }

    private TextRange getCurrentTextRange(Range range) {
        return LineStatusTracker.getRange(range.getType(), range.getOffset1(), range.getOffset2(), (byte)3, this.myDocument);
    }

    private TextRange getUpToDateRange(Range range) {
        return LineStatusTracker.getRange(range.getType(), range.getUOffset1(), range.getUOffset2(), (byte)2, this.myUpToDateDocument);
    }

    private static TextRange getRange(byte rangeType, int offset1, int offset2, byte emptyRangeCondition, Document document) {
        if (rangeType == emptyRangeCondition) {
            int lineStartOffset = offset1 == 0 ? 0 : document.getLineEndOffset(offset1 - 1);
            return new TextRange(lineStartOffset, lineStartOffset);
        }
        int startOffset = document.getLineStartOffset(offset1);
        int endOffset = document.getLineEndOffset(offset2 - 1);
        if (startOffset > 0) {
            --startOffset;
            --endOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    public void showActiveHint(Range range, Editor editor, Point point) {
        DefaultActionGroup group = new DefaultActionGroup();
        final AnAction globalShowNextAction = ActionManager.getInstance().getAction("VcsShowNextChangeMarker");
        final AnAction globalShowPrevAction = ActionManager.getInstance().getAction("VcsShowPrevChangeMarker");
        final ShowPrevChangeMarkerAction localShowPrevAction = new ShowPrevChangeMarkerAction(this.getPrevRange(range), this, editor);
        final ShowNextChangeMarkerAction localShowNextAction = new ShowNextChangeMarkerAction(this.getNextRange(range), this, editor);
        JComponent editorComponent = editor.getComponent();
        localShowNextAction.registerCustomShortcutSet(localShowNextAction.getShortcutSet(), editorComponent);
        localShowPrevAction.registerCustomShortcutSet(localShowPrevAction.getShortcutSet(), editorComponent);
        group.add((AnAction)localShowPrevAction);
        group.add((AnAction)localShowNextAction);
        localShowNextAction.copyFrom(globalShowNextAction);
        localShowPrevAction.copyFrom(globalShowPrevAction);
        group.add((AnAction)new RollbackAction(this, range, editor));
        group.add((AnAction)new ShowDiffAction(this, range, editor));
        group.add((AnAction)new CopyAction(this, range));
        final List actionList = (List)editorComponent.getClientProperty("AnAction.shortcutSet");
        actionList.remove(globalShowPrevAction);
        actionList.remove(globalShowNextAction);
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", (ActionGroup)group, true).getComponent();
        Color background = ((EditorEx)editor).getBackroundColor();
        Color foreground = editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        toolbar.setBackground(background);
        toolbar.setBorder(new SideBorder2(foreground, foreground, range.getType() != 2 ? null : foreground, foreground, 1));
        JPanel component = new JPanel(new BorderLayout());
        component.setOpaque(false);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.setOpaque(false);
        toolbarPanel.add((Component)toolbar, "West");
        component.add((Component)toolbarPanel, "North");
        if (range.getType() != 2) {
            DocumentEx doc = (DocumentEx)this.myUpToDateDocument;
            EditorEx uEditor = (EditorEx)EditorFactory.getInstance().createViewer((Document)doc, this.myProject);
            EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.getFileName());
            uEditor.setHighlighter(highlighter);
            EditorFragmentComponent editorFragmentComponent = EditorFragmentComponent.createEditorFragmentComponent(uEditor, range.getUOffset1(), range.getUOffset2(), false, false);
            component.add((Component)editorFragmentComponent, "Center");
            EditorFactory.getInstance().releaseEditor((Editor)uEditor);
        }
        LightweightHint lightweightHint = new LightweightHint(component);
        lightweightHint.addHintListener(new HintListener(){

            @Override
            public void hintHidden(EventObject event) {
                actionList.remove((Object)localShowPrevAction);
                actionList.remove((Object)localShowNextAction);
                actionList.add(globalShowPrevAction);
                actionList.add(globalShowNextAction);
            }
        });
        HintManagerImpl.getInstanceImpl().showEditorHint(lightweightHint, editor, point, 58, -1, false);
    }

    private String getFileName() {
        VirtualFile file = FileDocumentManager.getInstance().getFile(this.myDocument);
        if (file == null) {
            return "";
        }
        return file.getName();
    }

    public static LineStatusTracker createOn(Document doc, String upToDateContent, Project project) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)upToDateContent));
        LineStatusTracker tracker = new LineStatusTracker(doc, document, project);
        tracker.initialize(upToDateContent);
        return tracker;
    }

    public static LineStatusTracker createOn(Document doc, Project project) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        return new LineStatusTracker(doc, document, project);
    }

    public class CopyAction
    extends MyAction {
        protected CopyAction(LineStatusTracker lineStatusTracker2, Range range) {
            super(VcsBundle.message((String)"action.name.copy.old.text", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/copy.png"), lineStatusTracker2, range);
        }

        @Override
        public boolean isEnabled() {
            return this.myRange.getType() == 3 || this.myRange.getType() == 1;
        }

        public void actionPerformed(AnActionEvent e) {
            String content = this.myLineStatusTracker.getUpToDateContent(this.myRange);
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(content));
        }
    }

    public class ShowDiffAction
    extends MyAction {
        public ShowDiffAction(LineStatusTracker lineStatusTracker2, Range range, Editor editor) {
            super(VcsBundle.message((String)"action.name.show.difference", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/diff.png"), lineStatusTracker2, range);
        }

        @Override
        public boolean isEnabled() {
            return this.isModifiedRange() || this.isDeletedRange();
        }

        private boolean isDeletedRange() {
            return this.myRange.getType() == 3;
        }

        private boolean isModifiedRange() {
            return this.myRange.getType() == 1;
        }

        public void actionPerformed(AnActionEvent e) {
            DiffManager.getInstance().getDiffTool().show(this.createDiffData());
        }

        private DiffRequest createDiffData() {
            return new DiffRequest(this.myLineStatusTracker.getProject()){

                public DiffContent[] getContents() {
                    return new DiffContent[]{ShowDiffAction.this.createDiffContent(ShowDiffAction.this.myLineStatusTracker.getUpToDateDocument(), ShowDiffAction.this.myLineStatusTracker.getUpToDateRange(ShowDiffAction.this.myRange), null), ShowDiffAction.this.createDiffContent(ShowDiffAction.this.myLineStatusTracker.getDocument(), ShowDiffAction.this.myLineStatusTracker.getCurrentTextRange(ShowDiffAction.this.myRange), ShowDiffAction.this.myLineStatusTracker.getVirtualFile())};
                }

                public String[] getContentTitles() {
                    return new String[]{VcsBundle.message((String)"diff.content.title.up.to.date", (Object[])new Object[0]), VcsBundle.message((String)"diff.content.title.current.range", (Object[])new Object[0])};
                }

                public String getWindowTitle() {
                    return VcsBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]);
                }
            };
        }

        private DiffContent createDiffContent(Document uDocument, TextRange textRange, VirtualFile file) {
            DocumentContent diffContent = new DocumentContent(LineStatusTracker.this.myProject, uDocument);
            return new FragmentContent((DiffContent)diffContent, textRange, this.myLineStatusTracker.getProject(), file);
        }
    }

    public static class RollbackAction
    extends MyAction {
        public RollbackAction(LineStatusTracker lineStatusTracker, Range range, Editor editor) {
            super(VcsBundle.message((String)"action.name.rollback", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/reset.png"), lineStatusTracker, range);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(AnActionEvent e) {
            CommandProcessor.getInstance().executeCommand(this.myLineStatusTracker.getProject(), new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            ReadonlyStatusHandler.OperationStatus operationStatus;
                            if (!RollbackAction.this.myLineStatusTracker.getDocument().isWritable() && (operationStatus = ReadonlyStatusHandler.getInstance((Project)RollbackAction.this.myLineStatusTracker.getProject()).ensureFilesWritable(new VirtualFile[]{RollbackAction.this.myLineStatusTracker.getVirtualFile()})).hasReadonlyFiles()) {
                                return;
                            }
                            RollbackAction.this.myLineStatusTracker.rollbackChanges(RollbackAction.this.myRange);
                        }
                    });
                }
            }, VcsBundle.message((String)"command.name.rollback.change", (Object[])new Object[0]), null);
        }
    }

    public static abstract class MyAction
    extends AnAction
    implements DumbAware {
        protected final LineStatusTracker myLineStatusTracker;
        protected final Range myRange;

        protected MyAction(String text, Icon icon, LineStatusTracker lineStatusTracker, Range range) {
            super(text, null, icon);
            this.myLineStatusTracker = lineStatusTracker;
            this.myRange = range;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public abstract boolean isEnabled();

        protected int getMyRangeIndex() {
            List<Range> ranges = this.myLineStatusTracker.getRanges();
            for (int i = 0; i < ranges.size(); ++i) {
                Range range = ranges.get(i);
                if (range.getOffset1() != this.myRange.getOffset1() || range.getOffset2() != this.myRange.getOffset2()) continue;
                return i;
            }
            return -1;
        }
    }

    private class MyDocumentListener
    extends DocumentAdapter {
        private int myFirstChangedLine;
        private int myUpToDateFirstLine;
        private int myUpToDateLastLine;
        private int myLastChangedLine;
        private int myLinesBeforeChange;

        private MyDocumentListener() {
        }

        public void beforeDocumentChange(DocumentEvent e) {
            if (LineStatusTracker.this.myBulkUpdate) {
                return;
            }
            this.myFirstChangedLine = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset());
            this.myLastChangedLine = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset() + e.getOldLength());
            if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n')) {
                ++this.myLastChangedLine;
            }
            this.myLinesBeforeChange = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset() + e.getOldLength()) - LineStatusTracker.this.myDocument.getLineNumber(e.getOffset());
            Range firstChangedRange = this.getLastRangeBeforeLine(this.myFirstChangedLine);
            if (firstChangedRange == null) {
                this.myUpToDateFirstLine = this.myFirstChangedLine;
            } else if (firstChangedRange.containsLine(this.myFirstChangedLine)) {
                this.myFirstChangedLine = firstChangedRange.getOffset1();
                this.myUpToDateFirstLine = firstChangedRange.getUOffset1();
            } else {
                this.myUpToDateFirstLine = firstChangedRange.getUOffset2() + (this.myFirstChangedLine - firstChangedRange.getOffset2());
            }
            Range myLastChangedRange = this.getLastRangeBeforeLine(this.myLastChangedLine);
            if (myLastChangedRange == null) {
                this.myUpToDateLastLine = this.myLastChangedLine;
            } else if (myLastChangedRange.containsLine(this.myLastChangedLine)) {
                this.myUpToDateLastLine = myLastChangedRange.getUOffset2();
                this.myLastChangedLine = myLastChangedRange.getOffset2();
            } else {
                this.myUpToDateLastLine = myLastChangedRange.getUOffset2() + (this.myLastChangedLine - myLastChangedRange.getOffset2());
            }
        }

        @Nullable
        private Range getLastRangeBeforeLine(int line) {
            Range result = null;
            for (Range range : LineStatusTracker.this.myRanges) {
                if (range.isMoreThen(line)) {
                    return result;
                }
                result = range;
            }
            return result;
        }

        public void documentChanged(DocumentEvent e) {
            if (LineStatusTracker.this.myBulkUpdate) {
                return;
            }
            int line = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset() + e.getNewLength());
            int linesAfterChange = line - LineStatusTracker.this.myDocument.getLineNumber(e.getOffset());
            int linesShift = linesAfterChange - this.myLinesBeforeChange;
            List rangesAfterChange = LineStatusTracker.this.getRangesAfter(this.myLastChangedLine);
            List rangesBeforeChange = LineStatusTracker.this.getRangesBefore(this.myFirstChangedLine);
            List changedRanges = LineStatusTracker.this.getChangedRanges(this.myFirstChangedLine, this.myLastChangedLine);
            int newSize = rangesBeforeChange.size() + changedRanges.size() + rangesAfterChange.size();
            if (LineStatusTracker.this.myRanges.size() != newSize) {
                LOG.info("Ranges: " + LineStatusTracker.this.myRanges + "; first changed line: " + this.myFirstChangedLine + "; last changed line: " + this.myLastChangedLine);
                LOG.assertTrue(false);
            }
            this.myLastChangedLine += linesShift;
            List<Range> newChangedRanges = this.getNewChangedRanges();
            this.shiftRanges(rangesAfterChange, linesShift);
            if (!((Object)changedRanges).equals(newChangedRanges)) {
                this.replaceRanges(changedRanges, newChangedRanges);
                LineStatusTracker.this.myRanges = new ArrayList();
                LineStatusTracker.this.myRanges.addAll(rangesBeforeChange);
                LineStatusTracker.this.myRanges.addAll(newChangedRanges);
                LineStatusTracker.this.myRanges.addAll(rangesAfterChange);
                if (LineStatusTracker.this.myHighlighterCount != LineStatusTracker.this.myRanges.size()) {
                    LOG.error("Highlighters: " + LineStatusTracker.this.myHighlighterCount + ", ranges: " + LineStatusTracker.this.myRanges.size());
                }
                LineStatusTracker.this.myRanges = this.mergeRanges(LineStatusTracker.this.myRanges);
                for (Range range : LineStatusTracker.this.myRanges) {
                    if (range.hasHighlighter()) continue;
                    range.setHighlighter(LineStatusTracker.this.createHighlighter(range));
                }
                if (LineStatusTracker.this.myHighlighterCount != LineStatusTracker.this.myRanges.size()) {
                    LOG.error("Highlighters: " + LineStatusTracker.this.myHighlighterCount + ", ranges: " + LineStatusTracker.this.myRanges.size());
                }
            }
        }

        private List<Range> getNewChangedRanges() {
            List<String> lines = new DocumentWrapper(LineStatusTracker.this.myDocument).getLines(this.myFirstChangedLine, this.myLastChangedLine);
            List<String> uLines = new DocumentWrapper(LineStatusTracker.this.myUpToDateDocument).getLines(this.myUpToDateFirstLine, this.myUpToDateLastLine);
            return new RangesBuilder(lines, uLines, this.myFirstChangedLine, this.myUpToDateFirstLine).getRanges();
        }

        private List<Range> mergeRanges(List<Range> ranges) {
            ArrayList<Range> result = new ArrayList<Range>();
            Iterator<Range> iterator = ranges.iterator();
            if (!iterator.hasNext()) {
                return result;
            }
            Range prev = iterator.next();
            while (iterator.hasNext()) {
                Range range = iterator.next();
                if (prev.canBeMergedWith(range)) {
                    prev = prev.mergeWith(range, LineStatusTracker.this);
                    continue;
                }
                result.add(prev);
                prev = range;
            }
            result.add(prev);
            return result;
        }

        private void replaceRanges(List<Range> rangesInChange, List<Range> newRangesInChange) {
            for (Range range : rangesInChange) {
                LineStatusTracker.this.removeHighlighter(range.getHighlighter());
                range.setHighlighter(null);
            }
            for (Range range : newRangesInChange) {
                range.setHighlighter(LineStatusTracker.this.createHighlighter(range));
            }
        }

        private void shiftRanges(List<Range> rangesAfterChange, int shift) {
            for (Range aRangesAfterChange : rangesAfterChange) {
                aRangesAfterChange.shift(shift);
            }
        }
    }
}

