/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.io.SafeFileOutputStream;
import com.intellij.util.io.fs.IFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystemBase
extends LocalFileSystem {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl");
    private final List<LocalFileOperationsHandler> myHandlers = new ArrayList<LocalFileOperationsHandler>();

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.findFileByPath must not be null");
        }
        String canonicalPath = LocalFileSystemBase.getVfsCanonicalPath(path);
        if (canonicalPath == null) {
            return null;
        }
        return super.findFileByPath(canonicalPath);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.findFileByPathIfCached must not be null");
        }
        String canonicalPath = LocalFileSystemBase.getVfsCanonicalPath(path);
        if (canonicalPath == null) {
            return null;
        }
        return super.findFileByPathIfCached(canonicalPath);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.refreshAndFindFileByPath must not be null");
        }
        String canonicalPath = LocalFileSystemBase.getVfsCanonicalPath(path);
        if (canonicalPath == null) {
            return null;
        }
        return super.refreshAndFindFileByPath(canonicalPath);
    }

    public VirtualFile findFileByIoFile(File file) {
        String path = file.getAbsolutePath();
        if (path == null) {
            return null;
        }
        return this.findFileByPath(path.replace(File.separatorChar, '/'));
    }

    @Nullable
    public VirtualFile findFileByIoFile(IFile file) {
        String path = file.getPath();
        if (path == null) {
            return null;
        }
        return this.findFileByPath(path.replace(File.separatorChar, '/'));
    }

    @Nullable
    protected static String getVfsCanonicalPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.getVfsCanonicalPath must not be null");
        }
        if (path.length() == 0) {
            try {
                return new File("").getCanonicalPath();
            }
            catch (IOException e) {
                return path;
            }
        }
        if (SystemInfo.isWindows) {
            if (path.startsWith("//") || path.startsWith("\\\\")) {
                return path;
            }
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.contains("~")) {
                try {
                    return new File(path.replace('/', File.separatorChar)).getCanonicalPath().replace(File.separatorChar, '/');
                }
                catch (IOException e) {
                    return null;
                }
            }
        } else if (!path.startsWith("/")) {
            path = new File(path).getAbsolutePath();
        }
        return path.replace(File.separatorChar, '/');
    }

    protected static File convertToIOFile(VirtualFile file) {
        String path = file.getPath();
        if (path.endsWith(":") && path.length() == 2 && (SystemInfo.isWindows || SystemInfo.isOS2)) {
            path = path + "/";
        }
        return new File(path);
    }

    public boolean exists(VirtualFile fileOrDirectory) {
        if (fileOrDirectory.getParent() == null) {
            return true;
        }
        return LocalFileSystemBase.convertToIOFile(fileOrDirectory).exists();
    }

    public long getLength(VirtualFile file) {
        return LocalFileSystemBase.convertToIOFile(file).length();
    }

    public long getTimeStamp(VirtualFile file) {
        return LocalFileSystemBase.convertToIOFile(file).lastModified();
    }

    public boolean isDirectory(VirtualFile file) {
        return LocalFileSystemBase.convertToIOFile(file).isDirectory();
    }

    public boolean isWritable(VirtualFile file) {
        return LocalFileSystemBase.convertToIOFile(file).canWrite();
    }

    public String[] list(VirtualFile file) {
        String[] names;
        if (file.getParent() == null) {
            File[] roots = File.listRoots();
            if (roots.length == 1 && roots[0].getName().length() == 0) {
                return roots[0].list();
            }
            if ("".equals(file.getName())) {
                String[] names2 = new String[roots.length];
                for (int i = 0; i < names2.length; ++i) {
                    String name = roots[i].getPath();
                    if (name.endsWith(File.separator)) {
                        name = name.substring(0, name.length() - File.separator.length());
                    }
                    names2[i] = name;
                }
                return names2;
            }
        }
        return (names = LocalFileSystemBase.convertToIOFile(file).list()) != null ? names : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public String getProtocol() {
        if ("file" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.getProtocol must not return null");
        }
        return "file";
    }

    @Nullable
    public String normalize(String path) {
        return LocalFileSystemBase.getVfsCanonicalPath(path);
    }

    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.refreshAndFindFileByIoFile must not be null");
        }
        String path = file.getAbsolutePath();
        if (path == null) {
            return null;
        }
        return this.refreshAndFindFileByPath(path.replace(File.separatorChar, '/'));
    }

    @Nullable
    public VirtualFile refreshAndFindFileByIoFile(IFile ioFile) {
        String path = ioFile.getPath();
        if (path == null) {
            return null;
        }
        return this.refreshAndFindFileByPath(path.replace(File.separatorChar, '/'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIoFiles(Iterable<File> files) {
        boolean fireCommonRefreshSession;
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        Application app = ApplicationManager.getApplication();
        boolean bl = fireCommonRefreshSession = app.isDispatchThread() || app.isWriteAccessAllowed();
        if (fireCommonRefreshSession) {
            manager.fireBeforeRefreshStart(false);
        }
        try {
            ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
            for (File file : files) {
                VirtualFile virtualFile = this.refreshAndFindFileByIoFile(file);
                if (virtualFile == null) continue;
                filesToRefresh.add(virtualFile);
            }
            RefreshQueue.getInstance().refresh(false, false, null, VfsUtil.toVirtualFileArray(filesToRefresh));
        }
        finally {
            if (fireCommonRefreshSession) {
                manager.fireAfterRefreshFinish(false);
            }
        }
    }

    public void refreshFiles(Iterable<VirtualFile> files) {
        LocalFileSystemBase.refreshFiles(files, false, false);
    }

    protected static void refreshFiles(Iterable<VirtualFile> files, boolean recursive, boolean async) {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            list.add(file);
        }
        RefreshQueue.getInstance().refresh(async, recursive, null, VfsUtil.toVirtualFileArray(list));
    }

    public byte[] physicalContentsToByteArray(VirtualFile virtualFile) throws IOException {
        return virtualFile.contentsToByteArray();
    }

    public long physicalLength(VirtualFile virtualFile) {
        return virtualFile.getLength();
    }

    public void registerAuxiliaryFileOperationsHandler(LocalFileOperationsHandler handler) {
        if (this.myHandlers.contains(handler)) {
            LOG.error("Handler " + handler + " already registered.");
        }
        this.myHandlers.add(handler);
    }

    public void unregisterAuxiliaryFileOperationsHandler(LocalFileOperationsHandler handler) {
        if (!this.myHandlers.remove(handler)) {
            LOG.error("Handler" + handler + " haven't been registered or already unregistered.");
        }
    }

    public boolean processCachedFilesInSubtree(VirtualFile file, Processor<VirtualFile> processor) {
        if (file.getFileSystem() != this) {
            return true;
        }
        return LocalFileSystemBase.processFile((NewVirtualFile)file, processor);
    }

    private static boolean processFile(NewVirtualFile file, Processor<VirtualFile> processor) {
        if (!processor.process((Object)file)) {
            return false;
        }
        if (file.isDirectory()) {
            for (VirtualFile child : file.getCachedChildren()) {
                if (LocalFileSystemBase.processFile((NewVirtualFile)child, processor)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean auxDelete(VirtualFile file) throws IOException {
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            if (!handler.delete(file)) continue;
            return true;
        }
        return false;
    }

    private boolean auxMove(VirtualFile file, VirtualFile toDir) throws IOException {
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            if (!handler.move(file, toDir)) continue;
            return true;
        }
        return false;
    }

    private void auxNotifyCompleted(ThrowableConsumer<LocalFileOperationsHandler, IOException> consumer) {
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            handler.afterDone(consumer);
        }
    }

    @Nullable
    private File auxCopy(VirtualFile file, VirtualFile toDir, String copyName) throws IOException {
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            File copy = handler.copy(file, toDir, copyName);
            if (copy == null) continue;
            return copy;
        }
        return null;
    }

    private boolean auxRename(VirtualFile file, String newName) throws IOException {
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            if (!handler.rename(file, newName)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateFile(VirtualFile dir, String name) throws IOException {
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            if (!handler.createFile(dir, name)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateDirectory(VirtualFile dir, String name) throws IOException {
        for (LocalFileOperationsHandler handler : this.myHandlers) {
            if (!handler.createDirectory(dir, name)) continue;
            return true;
        }
        return false;
    }

    private static void delete(File physicalFile) throws IOException {
        File[] list = physicalFile.listFiles();
        if (list != null) {
            for (File aList : list) {
                LocalFileSystemBase.delete(aList);
            }
        }
        if (!physicalFile.delete()) {
            throw new IOException(VfsBundle.message((String)"file.delete.error", (Object[])new Object[]{physicalFile.getPath()}));
        }
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, final @NotNull VirtualFile parent, final @NotNull String dir) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.createChildDirectory must not be null");
        }
        if (dir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.createChildDirectory must not be null");
        }
        File ioDir = new File(LocalFileSystemBase.convertToIOFile(parent), dir);
        boolean succ = this.auxCreateDirectory(parent, dir) || ioDir.mkdirs();
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.createDirectory(parent, dir);
            }
        });
        if (!succ) {
            throw new IOException("Failed to create directory: " + ioDir.getPath());
        }
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(parent, dir);
        if (fakeVirtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.createChildDirectory must not return null");
        }
        return fakeVirtualFile;
    }

    public VirtualFile createChildFile(Object requestor, final @NotNull VirtualFile parent, final @NotNull String file) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.createChildFile must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.createChildFile must not be null");
        }
        File ioFile = new File(LocalFileSystemBase.convertToIOFile(parent), file);
        boolean succ = this.auxCreateFile(parent, file) || FileUtil.createIfDoesntExist((File)ioFile);
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.createFile(parent, file);
            }
        });
        if (!succ) {
            throw new IOException("Failed to create child file at " + ioFile.getPath());
        }
        return new FakeVirtualFile(parent, file);
    }

    public void deleteFile(Object requestor, final @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.deleteFile must not be null");
        }
        if (!this.auxDelete(file)) {
            LocalFileSystemBase.delete(LocalFileSystemBase.convertToIOFile(file));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.delete(file);
            }
        });
    }

    public boolean isCaseSensitive() {
        return SystemInfo.isFileSystemCaseSensitive;
    }

    @NotNull
    public InputStream getInputStream(VirtualFile file) throws FileNotFoundException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(LocalFileSystemBase.convertToIOFile(file)));
        if (bufferedInputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.getInputStream must not return null");
        }
        return bufferedInputStream;
    }

    @NotNull
    public byte[] contentsToByteArray(VirtualFile file) throws IOException {
        byte[] byArray = FileUtil.loadFileBytes((File)LocalFileSystemBase.convertToIOFile(file));
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.contentsToByteArray must not return null");
        }
        return byArray;
    }

    @NotNull
    public OutputStream getOutputStream(VirtualFile file, Object requestor, long modStamp, final long timeStamp) throws FileNotFoundException {
        final File ioFile = LocalFileSystemBase.convertToIOFile(file);
        Object stream = LocalFileSystemBase.shallUseSafeStream(requestor, ioFile) ? new SafeFileOutputStream(ioFile) : new FileOutputStream(ioFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)stream){

            @Override
            public void close() throws IOException {
                super.close();
                if (timeStamp > 0L) {
                    ioFile.setLastModified(timeStamp);
                }
            }
        };
        if (bufferedOutputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.getOutputStream must not return null");
        }
        return bufferedOutputStream;
    }

    private static boolean shallUseSafeStream(Object requestor, File file) {
        return requestor instanceof SafeWriteRequestor && FileUtil.canCallCanExecute() && !FileUtil.canExecute((File)file);
    }

    public void moveFile(Object requestor, final @NotNull VirtualFile file, final @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.moveFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.moveFile must not be null");
        }
        if (!this.auxMove(file, newParent)) {
            File ioFrom = LocalFileSystemBase.convertToIOFile(file);
            File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
            ioFrom.renameTo(new File(ioParent, file.getName()));
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.move(file, newParent);
            }
        });
    }

    public void renameFile(Object requestor, final @NotNull VirtualFile file, final @NotNull String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.renameFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.renameFile must not be null");
        }
        if (!file.exists()) {
            throw new IOException("File to move does not exist: " + file.getPath());
        }
        VirtualFile parent = file.getParent();
        assert (parent != null);
        if (!this.auxRename(file, newName) && !LocalFileSystemBase.convertToIOFile(file).renameTo(new File(LocalFileSystemBase.convertToIOFile(parent), newName))) {
            throw new IOException("Destination already exists: " + parent.getPath() + "/" + newName);
        }
        this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(){

            public void consume(LocalFileOperationsHandler handler) throws IOException {
                handler.rename(file, newName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.copyFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.copyFile must not be null");
        }
        if (copyName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.copyFile must not be null");
        }
        File physicalCopy = this.auxCopy(vFile, newParent, copyName);
        try {
            if (physicalCopy == null) {
                File physicalFile = LocalFileSystemBase.convertToIOFile(vFile);
                File newPhysicalParent = LocalFileSystemBase.convertToIOFile(newParent);
                physicalCopy = new File(newPhysicalParent, copyName);
                try {
                    if (physicalFile.isDirectory()) {
                        FileUtil.copyDir((File)physicalFile, (File)physicalCopy);
                    } else {
                        FileUtil.copy((File)physicalFile, (File)physicalCopy);
                    }
                }
                catch (IOException e) {
                    FileUtil.delete((File)physicalCopy);
                    throw e;
                }
            }
            this.auxNotifyCompleted(new ThrowableConsumer<LocalFileOperationsHandler, IOException>(vFile, newParent, copyName){
                final /* synthetic */ VirtualFile val$vFile;
                final /* synthetic */ VirtualFile val$newParent;
                final /* synthetic */ String val$copyName;
                {
                    this.val$vFile = virtualFile;
                    this.val$newParent = virtualFile2;
                    this.val$copyName = string;
                }

                public void consume(LocalFileOperationsHandler handler) throws IOException {
                    handler.copy(this.val$vFile, this.val$newParent, this.val$copyName);
                }
            });
        }
        catch (Throwable throwable) {
            this.auxNotifyCompleted(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        return new FakeVirtualFile(newParent, copyName);
    }

    public void setTimeStamp(VirtualFile file, long modstamp) {
        LocalFileSystemBase.convertToIOFile(file).setLastModified(modstamp);
    }

    public void setWritable(VirtualFile file, boolean writableFlag) throws IOException {
        FileUtil.setReadOnlyAttribute((String)file.getPath(), (!writableFlag ? 1 : 0) != 0);
        File ioFile = LocalFileSystemBase.convertToIOFile(file);
        if (ioFile.canWrite() != writableFlag) {
            throw new IOException("Failed to change read-only flag for " + ioFile.getPath());
        }
    }

    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/local/LocalFileSystemBase.extractRootPath must not be null");
        }
        if (path.length() == 0) {
            try {
                return this.extractRootPath(new File("").getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (SystemInfo.isWindows) {
            if (path.length() >= 2 && path.charAt(1) == ':') {
                return path.substring(0, 2).toUpperCase(Locale.US);
            }
            if (path.startsWith("//") || path.startsWith("\\\\")) {
                int idx;
                int slashCount = 0;
                for (idx = 2; idx < path.length() && slashCount < 2; ++idx) {
                    char c = path.charAt(idx);
                    if (c != '\\' && c != '/') continue;
                    ++slashCount;
                    --idx;
                }
                return path.substring(0, idx);
            }
            return "";
        }
        return path.startsWith("/") ? "/" : "";
    }

    public int getRank() {
        return 1;
    }

    public boolean markNewFilesAsDirty() {
        return true;
    }

    public String getCanonicallyCasedName(VirtualFile file) {
        if (this.isCaseSensitive()) {
            return super.getCanonicallyCasedName(file);
        }
        try {
            return LocalFileSystemBase.convertToIOFile(file).getCanonicalFile().getName();
        }
        catch (IOException e) {
            return file.getName();
        }
    }
}

