/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ResizeToolWindowAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.ex.WeakKeymapManagerListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.InternalDecoratorListener;
import com.intellij.openapi.wm.impl.TitlePanel;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NonNls;

public final class InternalDecorator
extends JPanel
implements Queryable,
TypeSafeDataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.InternalDecorator");
    private static final int DIVIDER_WIDTH = 5;
    private static final Icon ourSlidingIcon = IconLoader.getIcon((String)"/general/sliding.png");
    private static final Icon ourSlidingInactiveIcon = IconLoader.getIcon((String)"/general/slidingInactive.png");
    private static final Icon ourDockedIcon = IconLoader.getIcon((String)"/general/docked.png");
    private static final Icon ourDockedInactiveIcon = IconLoader.getIcon((String)"/general/dockedInactive.png");
    private static final Icon ourAuthoHideOnIcon = IconLoader.getIcon((String)"/general/autohideOn.png");
    private static final Icon ourAuthoHideOnInactiveIcon = IconLoader.getIcon((String)"/general/autohideOnInactive.png");
    private static final Icon ourAuthoHideOffIcon = IconLoader.getIcon((String)"/general/autohideOff.png");
    private static final Icon ourAuthoHideOffInactiveIcon = IconLoader.getIcon((String)"/general/autohideOffInactive.png");
    private static final Icon ourHideIcon = IconLoader.getIcon((String)"/general/hideToolWindow.png");
    private static final Icon ourHideInactiveIcon = IconLoader.getIcon((String)"/general/hideToolWindowInactive.png");
    private static final Icon ourFloatingIcon = IconLoader.getIcon((String)"/general/floating.png");
    private static final Icon ourFloatingInactiveIcon = IconLoader.getIcon((String)"/general/floatingInactive.png");
    private static final Icon ourFixIcon = IconLoader.getIcon((String)"/general/fix.png");
    private static final Icon ourFixInactiveIcon = IconLoader.getIcon((String)"/general/fixInactive.png");
    private static final Icon ourHideSideUp = IconLoader.getIcon((String)"/general/hideSideUp.png");
    private static final Icon ourHideSideUpInactive = IconLoader.getIcon((String)"/general/hideSideUpInactive.png");
    private static final Icon ourHideSideDown = IconLoader.getIcon((String)"/general/hideSideDown.png");
    private static final Icon ourHideSideDownInactive = IconLoader.getIcon((String)"/general/hideSideDownInactive.png");
    private static final Icon ourHideSideLeft = IconLoader.getIcon((String)"/general/hideSideLeft.png");
    private static final Icon ourHideSideLeftInactive = IconLoader.getIcon((String)"/general/hideSideLeftInactive.png");
    private static final Icon ourHideSideRight = IconLoader.getIcon((String)"/general/hideSideRight.png");
    private static final Icon ourHideSideRightInactive = IconLoader.getIcon((String)"/general/hideSideRightInactive.png");
    private Project myProject;
    private WindowInfoImpl myInfo;
    private final ToolWindowImpl myToolWindow;
    private final MyDivider myDivider;
    private final TitlePanel myTitlePanel;
    private final MyTitleButton myToggleFloatingModeButton;
    private final Separator myFloatingDockSeparator;
    private final MyTitleButton myToggleDockModeButton;
    private final Separator myDockAutoHideSeparator;
    private final MyTitleButton myToggleAutoHideModeButton;
    private final Separator myAutoHideHideSeparator;
    private final MyTitleButton myHideButton;
    private final EventListenerList myListenerList;
    private final TogglePinnedModeAction myToggleAutoHideModeAction;
    private final HideAction myHideAction;
    private final HideSideAction myHideSideAction;
    private final ToggleDockModeAction myToggleDockModeAction;
    private final ToggleFloatingModeAction myToggleFloatingModeAction;
    private final ToggleSideModeAction myToggleSideModeAction;
    private final ToggleContentUiTypeAction myToggleContentUiTypeAction;
    private final ToolWindowHandler myToolWindowHandler;
    private final MyKeymapManagerListener myKeymapManagerListener;
    private final WeakKeymapManagerListener myWeakKeymapManagerListener;
    @NonNls
    protected static final String TOGGLE_PINNED_MODE_ACTION_ID = "TogglePinnedMode";
    @NonNls
    protected static final String TOGGLE_DOCK_MODE_ACTION_ID = "ToggleDockMode";
    @NonNls
    protected static final String TOGGLE_FLOATING_MODE_ACTION_ID = "ToggleFloatingMode";
    @NonNls
    protected static final String TOGGLE_SIDE_MODE_ACTION_ID = "ToggleSideMode";
    @NonNls
    protected static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";
    @NonNls
    protected static final String HIDE_ACTIVE_SIDE_WINDOW_ACTION_ID = "HideSideWindows";
    @NonNls
    protected static final String TOGGLE_CONTENT_UI_TYPE_ACTION_ID = "ToggleContentUiTypeMode";
    private final MyTitleButton myHideSideButton;
    private final JComponent myTitleTabs;

    InternalDecorator(Project project, WindowInfoImpl info, ToolWindowImpl toolWindow) {
        super(new BorderLayout());
        this.myProject = project;
        this.myToolWindow = toolWindow;
        this.myToolWindow.setDecorator(this);
        this.myDivider = new MyDivider();
        this.myTitlePanel = new TitlePanel();
        this.myTitleTabs = toolWindow.getContentUI().getTabComponent();
        this.myToggleFloatingModeAction = new ToggleFloatingModeAction();
        this.myToggleSideModeAction = new ToggleSideModeAction();
        this.myFloatingDockSeparator = new Separator();
        this.myFloatingDockSeparator.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.myToggleDockModeAction = new ToggleDockModeAction();
        this.myDockAutoHideSeparator = new Separator();
        this.myToggleAutoHideModeAction = new TogglePinnedModeAction();
        this.myAutoHideHideSeparator = new Separator();
        this.myHideAction = new HideAction();
        this.myHideSideAction = new HideSideAction();
        this.myToggleContentUiTypeAction = new ToggleContentUiTypeAction();
        this.myToggleFloatingModeButton = new MyTitleButton((AnAction)this.myToggleFloatingModeAction);
        this.myToggleDockModeButton = new MyTitleButton((AnAction)this.myToggleDockModeAction);
        this.myToggleAutoHideModeButton = new MyTitleButton((AnAction)this.myToggleAutoHideModeAction);
        this.myHideButton = new MyTitleButton(this.myHideAction);
        this.myHideSideButton = new MyTitleButton(this.myHideSideAction);
        this.myListenerList = new EventListenerList();
        this.myKeymapManagerListener = new MyKeymapManagerListener();
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        this.myWeakKeymapManagerListener = new WeakKeymapManagerListener(keymapManager, this.myKeymapManagerListener);
        keymapManager.addKeymapManagerListener(this.myWeakKeymapManagerListener);
        this.init();
        this.myToolWindowHandler = new ToolWindowHandler();
        this.myToolWindow.addPropertyChangeListener(this.myToolWindowHandler);
        this.apply(info);
    }

    public final void apply(WindowInfoImpl info) {
        FloatingDecorator floatingDecorator;
        if (Comparing.equal((Object)this.myInfo, (Object)info) || this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        this.myInfo = info;
        boolean active = info.isActive();
        this.myTitlePanel.setActive(active, !info.isSliding());
        this.myFloatingDockSeparator.setActive(active);
        this.myDockAutoHideSeparator.setActive(active);
        this.myAutoHideHideSeparator.setActive(active);
        ToolWindowAnchor anchor = this.myInfo.getAnchor();
        if (info.isSliding()) {
            this.myDivider.invalidate();
            if (ToolWindowAnchor.TOP == anchor) {
                this.add((Component)this.myDivider, "South");
            } else if (ToolWindowAnchor.LEFT == anchor) {
                this.add((Component)this.myDivider, "East");
            } else if (ToolWindowAnchor.BOTTOM == anchor) {
                this.add((Component)this.myDivider, "North");
            } else if (ToolWindowAnchor.RIGHT == anchor) {
                this.add((Component)this.myDivider, "West");
            }
            this.myDivider.setPreferredSize(new Dimension(5, 5));
        } else {
            this.remove(this.myDivider);
        }
        if (!info.isFloating()) {
            this.myHideSideButton.setVisible(true);
            if (ToolWindowAnchor.TOP == anchor) {
                this.myHideSideButton.setIcon(active ? ourHideSideUp : ourHideSideUpInactive);
            } else if (ToolWindowAnchor.LEFT == anchor) {
                this.myHideSideButton.setIcon(active ? ourHideSideLeft : ourHideSideLeftInactive);
            } else if (ToolWindowAnchor.BOTTOM == anchor) {
                this.myHideSideButton.setIcon(active ? ourHideSideDown : ourHideSideDownInactive);
            } else if (ToolWindowAnchor.RIGHT == anchor) {
                this.myHideSideButton.setIcon(active ? ourHideSideRight : ourHideSideRightInactive);
            }
        } else {
            this.myHideSideButton.setVisible(false);
        }
        this.validate();
        this.repaint();
        if (this.myInfo.isDocked()) {
            this.myToggleFloatingModeButton.setIcon(active ? ourFloatingIcon : ourFloatingInactiveIcon);
            this.myToggleDockModeButton.setVisible(true);
            this.myDockAutoHideSeparator.setVisible(true);
            this.myToggleDockModeButton.setIcon(active ? ourSlidingIcon : ourSlidingInactiveIcon);
            this.myToggleAutoHideModeButton.setVisible(true);
            this.myAutoHideHideSeparator.setVisible(true);
            this.myToggleAutoHideModeButton.setIcon(active ? (this.myInfo.isAutoHide() ? ourAuthoHideOnIcon : ourAuthoHideOffIcon) : (this.myInfo.isAutoHide() ? ourAuthoHideOnInactiveIcon : ourAuthoHideOffInactiveIcon));
            this.myHideButton.setVisible(true);
        } else if (this.myInfo.isFloating()) {
            this.myToggleFloatingModeButton.setIcon(active ? ourFixIcon : ourFixInactiveIcon);
            this.myToggleDockModeButton.setVisible(false);
            this.myDockAutoHideSeparator.setVisible(false);
            this.myToggleAutoHideModeButton.setVisible(true);
            this.myAutoHideHideSeparator.setVisible(true);
            this.myToggleAutoHideModeButton.setIcon(active ? (this.myInfo.isAutoHide() ? ourAuthoHideOnIcon : ourAuthoHideOffIcon) : (this.myInfo.isAutoHide() ? ourAuthoHideOnInactiveIcon : ourAuthoHideOffInactiveIcon));
            this.myHideButton.setVisible(true);
        } else if (this.myInfo.isSliding()) {
            this.myToggleFloatingModeButton.setIcon(active ? ourFloatingIcon : ourFloatingInactiveIcon);
            this.myToggleDockModeButton.setVisible(true);
            this.myDockAutoHideSeparator.setVisible(true);
            this.myToggleDockModeButton.setIcon(active ? ourDockedIcon : ourDockedInactiveIcon);
            this.myToggleAutoHideModeButton.setVisible(false);
            this.myAutoHideHideSeparator.setVisible(false);
            this.myHideButton.setVisible(true);
        }
        this.myHideButton.setIcon(active ? ourHideIcon : ourHideInactiveIcon);
        this.updateTitle();
        this.updateTooltips();
        if (this.myInfo.isFloating() && this.myInfo.isVisible() && (floatingDecorator = (FloatingDecorator)SwingUtilities.getAncestorOfClass(FloatingDecorator.class, this)) != null) {
            floatingDecorator.apply(this.myInfo);
        }
        this.myToolWindow.getContentUI().setType(this.myInfo.getContentUiType());
    }

    public void calcData(DataKey key, DataSink sink) {
        if (PlatformDataKeys.TOOL_WINDOW.equals(key)) {
            sink.put(PlatformDataKeys.TOOL_WINDOW, (Object)this.myToolWindow);
        }
    }

    final void addInternalDecoratorListener(InternalDecoratorListener l) {
        this.myListenerList.add(InternalDecoratorListener.class, l);
    }

    final void removeInternalDecoratorListener(InternalDecoratorListener l) {
        this.myListenerList.remove(InternalDecoratorListener.class, l);
    }

    final void dispose() {
        this.removeAll();
        this.myToolWindow.removePropertyChangeListener(this.myToolWindowHandler);
        KeymapManagerEx.getInstanceEx().removeKeymapManagerListener(this.myWeakKeymapManagerListener);
        this.myProject = null;
    }

    private static String getToolTipTextByAction(@NonNls String actionId, String description) {
        String text = description;
        String shortcutForAction = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction(actionId));
        if (shortcutForAction.length() > 0) {
            text = text + "  " + shortcutForAction;
        }
        return text;
    }

    private void fireAnchorChanged(ToolWindowAnchor anchor) {
        InternalDecoratorListener[] listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].anchorChanged(this, anchor);
        }
    }

    private void fireAutoHideChanged(boolean autoHide) {
        InternalDecoratorListener[] listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].autoHideChanged(this, autoHide);
        }
    }

    final void fireHidden() {
        InternalDecoratorListener[] listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].hidden(this);
        }
    }

    final void fireHiddenSide() {
        InternalDecoratorListener[] listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].hiddenSide(this);
        }
    }

    final void fireActivated() {
        InternalDecoratorListener[] listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].activated(this);
        }
    }

    private void fireTypeChanged(ToolWindowType type) {
        InternalDecoratorListener[] listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].typeChanged(this, type);
        }
    }

    final void fireResized() {
        InternalDecoratorListener[] listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].resized(this);
        }
    }

    private void fireSideStatusChanged(boolean isSide) {
        InternalDecoratorListener[] listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].sideStatusChanged(this, isSide);
        }
    }

    private void fireContentUiTypeChanges(ToolWindowContentUiType type) {
        InternalDecoratorListener[] listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].contentUiTypeChanges(this, type);
        }
    }

    private void init() {
        this.enableEvents(1L);
        this.myTitlePanel.addTitle(this.myTitleTabs);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setOpaque(false);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        buttonPanel.add((Component)((Object)this.myToggleFloatingModeButton), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.myFloatingDockSeparator, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)((Object)this.myToggleDockModeButton), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.myDockAutoHideSeparator, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)((Object)this.myToggleAutoHideModeButton), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.myAutoHideHideSeparator, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)((Object)this.myHideButton), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myTitlePanel.addButtons(buttonPanel, (JComponent)((Object)this.myHideSideButton));
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.myTitlePanel, "North");
        JPanel innerPanel = new JPanel(new BorderLayout());
        JComponent toolWindowComponent = this.myToolWindow.getComponent();
        innerPanel.add((Component)toolWindowComponent, "Center");
        NonOpaquePanel inner = new NonOpaquePanel((JComponent)innerPanel);
        inner.setBorder((Border)new InnerPanelBorder());
        contentPane.add((Component)inner, "Center");
        this.add((Component)contentPane, "Center");
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolWindowManager.getInstance((Project)InternalDecorator.this.myProject).activateEditorComponent();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public final ActionGroup createPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.myInfo.isDocked()) {
            group.add((AnAction)this.myToggleAutoHideModeAction);
            group.add((AnAction)this.myToggleDockModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
            group.add((AnAction)this.myToggleSideModeAction);
        } else if (this.myInfo.isFloating()) {
            group.add((AnAction)this.myToggleAutoHideModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
        } else if (this.myInfo.isSliding()) {
            group.add((AnAction)this.myToggleDockModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
        }
        group.add((AnAction)this.myToggleContentUiTypeAction);
        DefaultActionGroup moveGroup = new DefaultActionGroup(UIBundle.message((String)"tool.window.move.to.action.group.name", (Object[])new Object[0]), true);
        ToolWindowAnchor anchor = this.myInfo.getAnchor();
        if (anchor != ToolWindowAnchor.TOP) {
            ChangeAnchorAction topAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.top.action.name", (Object[])new Object[0]), ToolWindowAnchor.TOP);
            moveGroup.add((AnAction)topAction);
        }
        if (anchor != ToolWindowAnchor.LEFT) {
            ChangeAnchorAction leftAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.left.action.name", (Object[])new Object[0]), ToolWindowAnchor.LEFT);
            moveGroup.add((AnAction)leftAction);
        }
        if (anchor != ToolWindowAnchor.BOTTOM) {
            ChangeAnchorAction bottomAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.bottom.action.name", (Object[])new Object[0]), ToolWindowAnchor.BOTTOM);
            moveGroup.add((AnAction)bottomAction);
        }
        if (anchor != ToolWindowAnchor.RIGHT) {
            ChangeAnchorAction rightAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.right.action.name", (Object[])new Object[0]), ToolWindowAnchor.RIGHT);
            moveGroup.add((AnAction)rightAction);
        }
        group.add((AnAction)moveGroup);
        DefaultActionGroup resize = new DefaultActionGroup(ActionsBundle.groupText((String)"ResizeToolWindowGroup"), true);
        resize.add((AnAction)new ResizeToolWindowAction.Left(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Right(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Up(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Down(this.myToolWindow, this));
        group.add((AnAction)resize);
        group.addSeparator();
        group.add((AnAction)this.myHideAction);
        return group;
    }

    final ToolWindowImpl getToolWindow() {
        return this.myToolWindow;
    }

    final WindowInfoImpl getWindowInfo() {
        return this.myInfo;
    }

    @Override
    protected final void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        if (101 == e.getID()) {
            this.fireResized();
        }
    }

    private void updateTitle() {
        StringBuffer fullTitle = new StringBuffer();
        if (SystemInfo.isWindows || !this.myInfo.isFloating()) {
            fullTitle.append(this.myInfo.getId());
            String title = this.myToolWindow.getTitle();
            if (title != null && title.length() > 0) {
                fullTitle.append(" - ").append(title);
            }
        } else {
            String title = this.myToolWindow.getTitle();
            if (title != null && title.length() > 0) {
                fullTitle.append(title);
            }
        }
    }

    private void updateTooltips() {
        if (this.myInfo.isDocked()) {
            this.myToggleDockModeButton.setToolTipText(InternalDecorator.getToolTipTextByAction(TOGGLE_DOCK_MODE_ACTION_ID, UIBundle.message((String)"tool.wondow.undock.action.name", (Object[])new Object[0])));
        } else if (this.myInfo.isSliding()) {
            this.myToggleDockModeButton.setToolTipText(InternalDecorator.getToolTipTextByAction(TOGGLE_DOCK_MODE_ACTION_ID, UIBundle.message((String)"tool.wondow.dock.action.name", (Object[])new Object[0])));
        }
        this.myToggleFloatingModeButton.setToolTipText(InternalDecorator.getToolTipTextByAction(TOGGLE_FLOATING_MODE_ACTION_ID, this.myInfo.isFloating() ? UIBundle.message((String)"tool.wondow.fix.action.name", (Object[])new Object[0]) : UIBundle.message((String)"tool.wondow.float.action.name", (Object[])new Object[0])));
        this.myToggleAutoHideModeButton.setToolTipText(InternalDecorator.getToolTipTextByAction(TOGGLE_PINNED_MODE_ACTION_ID, this.myInfo.isAutoHide() ? UIBundle.message((String)"tool.wondow.pin.action.name", (Object[])new Object[0]) : UIBundle.message((String)"tool.wondow.unpin.action.name", (Object[])new Object[0])));
        this.myHideButton.setToolTipText(InternalDecorator.getToolTipTextByAction(HIDE_ACTIVE_WINDOW_ACTION_ID, UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0])));
        this.myHideSideButton.setToolTipText(InternalDecorator.getToolTipTextByAction(HIDE_ACTIVE_SIDE_WINDOW_ACTION_ID, UIBundle.message((String)"tool.window.hideSide.action.name", (Object[])new Object[0])));
    }

    public TitlePanel getTitlePanel() {
        return this.myTitlePanel;
    }

    public void putInfo(Map<String, String> info) {
        info.put("toolWindowTitle", this.myToolWindow.getTitle());
        Content selection = this.myToolWindow.getContentManager().getSelectedContent();
        if (selection != null) {
            info.put("toolWindowTab", selection.getTabName());
        }
    }

    private final class ToolWindowHandler
    implements PropertyChangeListener {
        private ToolWindowHandler() {
        }

        @Override
        public final void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("title".equals(name)) {
                InternalDecorator.this.updateTitle();
            }
        }
    }

    private static final class Separator
    extends JLabel {
        private static final Icon ourActiveSeparator = IconLoader.getIcon((String)"/general/separator.png");
        private static final Icon ourInactiveSeparator = IconLoader.getIcon((String)"/general/inactiveSeparator.png");

        private Separator() {
        }

        public final void setActive(boolean active) {
            this.setIcon(active ? ourActiveSeparator : ourInactiveSeparator);
        }

        @Override
        public final void updateUI() {
            super.updateUI();
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }
    }

    private static final class MyTitleButton
    extends Wrapper
    implements ActionListener {
        private final InplaceButton myButton;
        private final AnAction myAction;

        public MyTitleButton(AnAction action) {
            this.myAction = action;
            this.myButton = new InplaceButton(null, (Icon)new EmptyIcon(16), (ActionListener)this);
            this.setContent((JComponent)this.myButton);
            this.setOpaque(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", this.myAction.getTemplatePresentation(), ActionManager.getInstance(), 0);
            actionManager.fireBeforeActionPerformed(this.myAction, dataContext, event);
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            if (component != null && !component.isShowing()) {
                return;
            }
            this.myAction.actionPerformed(event);
        }

        public void setIcon(Icon icon) {
            this.myButton.setIcon(icon);
        }

        public void setToolTipText(String text) {
            this.myButton.setToolTipText(text);
        }
    }

    private final class MyKeymapManagerListener
    implements KeymapManagerListener {
        private MyKeymapManagerListener() {
        }

        public final void activeKeymapChanged(Keymap keymap) {
            InternalDecorator.this.updateTooltips();
        }
    }

    private final class MyDivider
    extends JPanel {
        private boolean myDragging = false;
        private Point myLastPoint;

        public MyDivider() {
            this.enableEvents(48L);
            this.setBorder(new DividerBorder());
        }

        @Override
        protected final void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (506 == e.getID()) {
                this.myDragging = true;
                ToolWindowAnchor anchor = InternalDecorator.this.myInfo.getAnchor();
                boolean isVertical = anchor == ToolWindowAnchor.TOP || anchor == ToolWindowAnchor.BOTTOM;
                this.setCursor(isVertical ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                Point point = e.getPoint();
                Container windowPane = InternalDecorator.this.getParent();
                this.myLastPoint = SwingUtilities.convertPoint(this, point, windowPane);
                this.myLastPoint.x = Math.min(Math.max(this.myLastPoint.x, 0), windowPane.getWidth());
                this.myLastPoint.y = Math.min(Math.max(this.myLastPoint.y, 0), windowPane.getHeight());
                Rectangle bounds = InternalDecorator.this.getBounds();
                if (anchor == ToolWindowAnchor.TOP) {
                    if (this.myLastPoint.y < 5) {
                        this.myLastPoint.y = 5;
                    }
                    InternalDecorator.this.setBounds(0, 0, bounds.width, this.myLastPoint.y);
                } else if (anchor == ToolWindowAnchor.LEFT) {
                    if (this.myLastPoint.x < 5) {
                        this.myLastPoint.x = 5;
                    }
                    InternalDecorator.this.setBounds(0, 0, this.myLastPoint.x, bounds.height);
                } else if (anchor == ToolWindowAnchor.BOTTOM) {
                    if (this.myLastPoint.y > windowPane.getHeight() - 5) {
                        this.myLastPoint.y = windowPane.getHeight() - 5;
                    }
                    InternalDecorator.this.setBounds(0, this.myLastPoint.y, bounds.width, windowPane.getHeight() - this.myLastPoint.y);
                } else if (anchor == ToolWindowAnchor.RIGHT) {
                    if (this.myLastPoint.x > windowPane.getWidth() - 5) {
                        this.myLastPoint.x = windowPane.getWidth() - 5;
                    }
                    InternalDecorator.this.setBounds(this.myLastPoint.x, 0, windowPane.getWidth() - this.myLastPoint.x, bounds.height);
                }
                InternalDecorator.this.validate();
            }
        }

        @Override
        protected final void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            ToolWindowAnchor anchor = InternalDecorator.this.myInfo.getAnchor();
            boolean isVerticalCursor = anchor == ToolWindowAnchor.TOP || anchor == ToolWindowAnchor.BOTTOM;
            switch (e.getID()) {
                default: {
                    break;
                }
                case 504: {
                    this.setCursor(isVerticalCursor ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                    break;
                }
                case 505: {
                    if (this.myDragging) break;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 501: {
                    this.setCursor(isVerticalCursor ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                    break;
                }
                case 502: {
                    this.myDragging = false;
                    this.myLastPoint = null;
                }
                case 500: 
            }
        }

        private final class DividerBorder
        implements Border {
            private DividerBorder() {
            }

            @Override
            public final void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                boolean isVertical;
                ToolWindowAnchor anchor = InternalDecorator.this.myInfo.getAnchor();
                boolean bl = isVertical = anchor == ToolWindowAnchor.TOP || anchor == ToolWindowAnchor.BOTTOM;
                if (isVertical) {
                    if (anchor == ToolWindowAnchor.TOP) {
                        g.setColor(Color.white);
                        UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)(x + width - 1), (int)y);
                        g.setColor(Color.darkGray);
                        UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height - 1), (int)(x + width - 1), (int)(y + height - 1));
                    } else {
                        g.setColor(Color.darkGray);
                        UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)(x + width - 1), (int)y);
                        g.setColor(Color.white);
                        UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height - 1), (int)(x + width - 1), (int)(y + height - 1));
                    }
                } else if (anchor == ToolWindowAnchor.LEFT) {
                    g.setColor(Color.white);
                    UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)x, (int)(y + height - 1));
                    g.setColor(Color.darkGray);
                    UIUtil.drawLine((Graphics)g, (int)(x + width - 1), (int)y, (int)(x + width - 1), (int)(y + height - 1));
                } else {
                    g.setColor(Color.darkGray);
                    UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)x, (int)(y + height - 1));
                    g.setColor(Color.white);
                    UIUtil.drawLine((Graphics)g, (int)(x + width - 1), (int)y, (int)(x + width - 1), (int)(y + height - 1));
                }
            }

            @Override
            public final Insets getBorderInsets(Component c) {
                if (c instanceof MyDivider) {
                    return new Insets(1, 1, 1, 1);
                }
                return new Insets(0, 0, 0, 0);
            }

            @Override
            public final boolean isBorderOpaque() {
                return true;
            }
        }
    }

    private final class ToggleContentUiTypeAction
    extends ToggleAction
    implements DumbAware {
        private ToggleContentUiTypeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_CONTENT_UI_TYPE_ACTION_ID));
        }

        public boolean isSelected(AnActionEvent e) {
            return InternalDecorator.this.myInfo.getContentUiType() == ToolWindowContentUiType.TABBED;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            InternalDecorator.this.fireContentUiTypeChanges(state ? ToolWindowContentUiType.TABBED : ToolWindowContentUiType.COMBO);
        }
    }

    private final class ToggleSideModeAction
    extends ToggleAction
    implements DumbAware {
        public ToggleSideModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_SIDE_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return InternalDecorator.this.myInfo.isSplit();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            InternalDecorator.this.fireSideStatusChanged(flag);
        }

        public void update(AnActionEvent e) {
            super.update(e);
        }
    }

    private final class ToggleFloatingModeAction
    extends ToggleAction
    implements DumbAware {
        public ToggleFloatingModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_FLOATING_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return InternalDecorator.this.myInfo.isFloating();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            if (InternalDecorator.this.myInfo.isFloating()) {
                InternalDecorator.this.fireTypeChanged(InternalDecorator.this.myInfo.getInternalType());
            } else {
                InternalDecorator.this.fireTypeChanged(ToolWindowType.FLOATING);
            }
        }
    }

    private final class ToggleDockModeAction
    extends ToggleAction
    implements DumbAware {
        public ToggleDockModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_DOCK_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return InternalDecorator.this.myInfo.isDocked();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            if (InternalDecorator.this.myInfo.isDocked()) {
                InternalDecorator.this.fireTypeChanged(ToolWindowType.SLIDING);
            } else if (InternalDecorator.this.myInfo.isSliding()) {
                InternalDecorator.this.fireTypeChanged(ToolWindowType.DOCKED);
            }
        }
    }

    private final class TogglePinnedModeAction
    extends ToggleAction
    implements DumbAware {
        public TogglePinnedModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_PINNED_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return !InternalDecorator.this.myInfo.isAutoHide();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            InternalDecorator.this.fireAutoHideChanged(!InternalDecorator.this.myInfo.isAutoHide());
        }
    }

    private final class HideSideAction
    extends AnAction
    implements DumbAware {
        @NonNls
        public static final String HIDE_ACTIVE_SIDE_WINDOW_ACTION_ID = "HideSideWindows";

        public HideSideAction() {
            this.copyFrom(ActionManager.getInstance().getAction("HideSideWindows"));
            this.getTemplatePresentation().setText(UIBundle.message((String)"tool.window.hideSide.action.name", (Object[])new Object[0]));
        }

        public final void actionPerformed(AnActionEvent e) {
            InternalDecorator.this.fireHiddenSide();
        }

        public final void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(InternalDecorator.this.myInfo.isVisible());
        }
    }

    private final class HideAction
    extends AnAction
    implements DumbAware {
        @NonNls
        public static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";

        public HideAction() {
            this.copyFrom(ActionManager.getInstance().getAction("HideActiveWindow"));
            this.getTemplatePresentation().setText(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]));
        }

        public final void actionPerformed(AnActionEvent e) {
            InternalDecorator.this.fireHidden();
        }

        public final void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(InternalDecorator.this.myInfo.isVisible());
        }
    }

    private final class ChangeAnchorAction
    extends AnAction
    implements DumbAware {
        private final ToolWindowAnchor myAnchor;

        public ChangeAnchorAction(String title, ToolWindowAnchor anchor) {
            super(title);
            this.myAnchor = anchor;
        }

        public final void actionPerformed(AnActionEvent e) {
            InternalDecorator.this.fireAnchorChanged(this.myAnchor);
        }
    }

    private static class InnerPanelBorder
    implements Border {
        private InnerPanelBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(UIUtil.getBorderInactiveColor());
            UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)x, (int)(y + height - 2));
            UIUtil.drawLine((Graphics)g, (int)(x + width - 1), (int)y, (int)(x + width - 1), (int)(y + height - 2));
            UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)(y + height - 1), (int)(x + width - 2), (int)(y + height - 1));
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

