/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.Surface;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

final class ToolWindowsPane
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.ToolWindowsPane");
    private final IdeFrameImpl myFrame;
    private final HashMap<String, StripeButton> myId2Button;
    private final HashMap<String, InternalDecorator> myId2Decorator;
    private final HashMap<StripeButton, WindowInfoImpl> myButton2Info;
    private final HashMap<InternalDecorator, WindowInfoImpl> myDecorator2Info;
    private final MyLayeredPane myLayeredPane;
    private final ThreeComponentsSplitter myVerticalSplitter;
    private final ThreeComponentsSplitter myHorizontalSplitter;
    private final Stripe myLeftStripe;
    private final Stripe myRightStripe;
    private final Stripe myBottomStripe;
    private final Stripe myTopStripe;
    private final ArrayList<Stripe> myStipes = new ArrayList();
    private final MyUISettingsListenerImpl myUISettingsListener;
    private final ToolWindowManagerImpl myManager;

    ToolWindowsPane(IdeFrameImpl frame, ToolWindowManagerImpl manager) {
        super(new BorderLayout());
        this.myManager = manager;
        this.setOpaque(false);
        this.myFrame = frame;
        this.myId2Button = new HashMap();
        this.myId2Decorator = new HashMap();
        this.myButton2Info = new HashMap();
        this.myDecorator2Info = new HashMap();
        this.myUISettingsListener = new MyUISettingsListenerImpl();
        this.myVerticalSplitter = new ThreeComponentsSplitter(true);
        this.myVerticalSplitter.setBackground(Color.gray);
        this.myHorizontalSplitter = new ThreeComponentsSplitter(false);
        this.myHorizontalSplitter.setBackground(Color.gray);
        this.myVerticalSplitter.setInnerComponent((JComponent)this.myHorizontalSplitter);
        this.myTopStripe = new Stripe(1, manager);
        this.myStipes.add(this.myTopStripe);
        this.myLeftStripe = new Stripe(2, manager);
        this.myStipes.add(this.myLeftStripe);
        this.myBottomStripe = new Stripe(3, manager);
        this.myStipes.add(this.myBottomStripe);
        this.myRightStripe = new Stripe(4, manager);
        this.myStipes.add(this.myRightStripe);
        this.updateToolStripesVisibility();
        this.myLayeredPane = new MyLayeredPane((JComponent)this.myVerticalSplitter);
        this.add((Component)this.myTopStripe, "North");
        this.add((Component)this.myLeftStripe, "West");
        this.add((Component)this.myBottomStripe, "South");
        this.add((Component)this.myRightStripe, "East");
        this.add((Component)this.myLayeredPane, "Center");
    }

    @Override
    public final void addNotify() {
        super.addNotify();
        UISettings.getInstance().addUISettingsListener((UISettingsListener)this.myUISettingsListener);
    }

    @Override
    public final void removeNotify() {
        UISettings.getInstance().removeUISettingsListener((UISettingsListener)this.myUISettingsListener);
        super.removeNotify();
    }

    final FinalizableCommand createAddButtonCmd(StripeButton button, WindowInfoImpl info, Comparator comparator, Runnable finishCallBack) {
        WindowInfoImpl copiedInfo = info.copy();
        this.myId2Button.put((Object)copiedInfo.getId(), (Object)button);
        this.myButton2Info.put((Object)button, (Object)copiedInfo);
        return new AddToolStripeButtonCmd(button, copiedInfo, comparator, finishCallBack);
    }

    final FinalizableCommand createAddDecoratorCmd(InternalDecorator decorator, WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
        WindowInfoImpl copiedInfo = info.copy();
        String id = copiedInfo.getId();
        this.myDecorator2Info.put((Object)decorator, (Object)copiedInfo);
        this.myId2Decorator.put((Object)id, (Object)decorator);
        if (info.isDocked()) {
            WindowInfoImpl sideInfo = this.getDockedInfoAt(info.getAnchor(), !info.isSplit());
            if (sideInfo == null) {
                return new AddDockedComponentCmd(decorator, info, dirtyMode, finishCallBack);
            }
            return new AddAndSplitDockedComponentCmd(decorator, info, dirtyMode, finishCallBack);
        }
        if (info.isSliding()) {
            return new AddSlidingComponentCmd(decorator, info, dirtyMode, finishCallBack);
        }
        throw new IllegalArgumentException("Unknown window type: " + info.getType());
    }

    final FinalizableCommand createRemoveButtonCmd(String id, Runnable finishCallBack) {
        StripeButton button = this.getButtonById(id);
        WindowInfoImpl info = this.getButtonInfoById(id);
        this.myButton2Info.remove((Object)button);
        this.myId2Button.remove((Object)id);
        return new RemoveToolStripeButtonCmd(button, info, finishCallBack);
    }

    final FinalizableCommand createRemoveDecoratorCmd(String id, boolean dirtyMode, Runnable finishCallBack) {
        Component decorator = this.getDecoratorById(id);
        WindowInfoImpl info = this.getDecoratorInfoById(id);
        this.myDecorator2Info.remove((Object)decorator);
        this.myId2Decorator.remove((Object)id);
        WindowInfoImpl sideInfo = this.getDockedInfoAt(info.getAnchor(), !info.isSplit());
        if (info.isDocked()) {
            if (sideInfo == null) {
                return new RemoveDockedComponentCmd(info, dirtyMode, finishCallBack);
            }
            return new RemoveSplitAndDockedComponentCmd(info, sideInfo, dirtyMode, finishCallBack);
        }
        if (info.isSliding()) {
            return new RemoveSlidingComponentCmd(decorator, info, dirtyMode, finishCallBack);
        }
        throw new IllegalArgumentException("Unknown window type");
    }

    final FinalizableCommand createSetEditorComponentCmd(JComponent component, Runnable finishCallBack) {
        return new SetEditorComponentCmd(component, finishCallBack);
    }

    final FinalizableCommand createUpdateButtonPositionCmd(String id, Runnable finishCallback) {
        return new UpdateButtonPositionCmd(id, finishCallback);
    }

    final JComponent getMyLayeredPane() {
        return this.myLayeredPane;
    }

    private StripeButton getButtonById(String id) {
        return (StripeButton)this.myId2Button.get((Object)id);
    }

    private Component getDecoratorById(String id) {
        return (Component)this.myId2Decorator.get((Object)id);
    }

    private WindowInfoImpl getButtonInfoById(String id) {
        return (WindowInfoImpl)this.myButton2Info.get(this.myId2Button.get((Object)id));
    }

    private WindowInfoImpl getDecoratorInfoById(String id) {
        return (WindowInfoImpl)this.myDecorator2Info.get(this.myId2Decorator.get((Object)id));
    }

    private void setComponent(JComponent component, ToolWindowAnchor anchor, float weight) {
        if (ToolWindowAnchor.TOP == anchor) {
            this.myVerticalSplitter.setFirstComponent(component);
            this.myVerticalSplitter.setFirstSize((int)((float)this.myLayeredPane.getHeight() * weight));
        } else if (ToolWindowAnchor.LEFT == anchor) {
            this.myHorizontalSplitter.setFirstComponent(component);
            this.myHorizontalSplitter.setFirstSize((int)((float)this.myLayeredPane.getWidth() * weight));
        } else if (ToolWindowAnchor.BOTTOM == anchor) {
            this.myVerticalSplitter.setLastComponent(component);
            this.myVerticalSplitter.setLastSize((int)((float)this.myLayeredPane.getHeight() * weight));
        } else if (ToolWindowAnchor.RIGHT == anchor) {
            this.myHorizontalSplitter.setLastComponent(component);
            this.myHorizontalSplitter.setLastSize((int)((float)this.myLayeredPane.getWidth() * weight));
        } else {
            LOG.error("unknown anchor: " + anchor);
        }
    }

    private JComponent getComponentAt(ToolWindowAnchor anchor) {
        if (ToolWindowAnchor.TOP == anchor) {
            return this.myVerticalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.LEFT == anchor) {
            return this.myHorizontalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.BOTTOM == anchor) {
            return this.myVerticalSplitter.getLastComponent();
        }
        if (ToolWindowAnchor.RIGHT == anchor) {
            return this.myHorizontalSplitter.getLastComponent();
        }
        LOG.error("unknown anchor: " + anchor);
        return null;
    }

    private WindowInfoImpl getDockedInfoAt(ToolWindowAnchor anchor, boolean side) {
        for (WindowInfoImpl info : this.myDecorator2Info.values()) {
            if (!info.isVisible() || !info.isDocked() || info.getAnchor() != anchor || side != info.isSplit()) continue;
            return info;
        }
        return null;
    }

    private void setDocumentComponent(JComponent component) {
        this.myHorizontalSplitter.setInnerComponent(component);
    }

    private void updateToolStripesVisibility() {
        boolean visible = !UISettings.getInstance().HIDE_TOOL_STRIPES;
        this.myLeftStripe.setVisible(visible);
        this.myRightStripe.setVisible(visible);
        this.myTopStripe.setVisible(visible);
        this.myBottomStripe.setVisible(visible);
    }

    Stripe getStripeFor(String id) {
        ToolWindowAnchor anchor = this.myManager.getToolWindow(id).getAnchor();
        if (ToolWindowAnchor.TOP == anchor) {
            return this.myTopStripe;
        }
        if (ToolWindowAnchor.BOTTOM == anchor) {
            return this.myBottomStripe;
        }
        if (ToolWindowAnchor.LEFT == anchor) {
            return this.myLeftStripe;
        }
        if (ToolWindowAnchor.RIGHT == anchor) {
            return this.myRightStripe;
        }
        throw new IllegalArgumentException("Anchor=" + anchor);
    }

    Stripe getStripeFor(Rectangle screenRec, Stripe preferred) {
        if (preferred.containsScreen(screenRec)) {
            return this.myStipes.get(this.myStipes.indexOf(preferred));
        }
        for (Stripe each : this.myStipes) {
            if (!each.containsScreen(screenRec)) continue;
            return this.myStipes.get(this.myStipes.indexOf(each));
        }
        return null;
    }

    void startDrag() {
        for (Stripe each : this.myStipes) {
            each.startDrag();
        }
    }

    void stopDrag() {
        for (Stripe each : this.myStipes) {
            each.stopDrag();
        }
    }

    public void stretchWidth(ToolWindow wnd, int value) {
        this.stretch(wnd, value);
    }

    public void stretchHeight(ToolWindow wnd, int value) {
        this.stretch(wnd, value);
    }

    private void stretch(ToolWindow wnd, int value) {
        int maxValue;
        if (!wnd.isVisible()) {
            return;
        }
        Resizer resizer = null;
        Container cmp = null;
        if (wnd.getType() == ToolWindowType.DOCKED && (cmp = this.getComponentAt(wnd.getAnchor())) != null) {
            if (wnd.getAnchor().isHorizontal()) {
                resizer = this.myVerticalSplitter.getFirstComponent() == cmp ? new Resizer.Splitter.FirstComponent(this.myVerticalSplitter) : new Resizer.Splitter.LastComponent(this.myVerticalSplitter);
            } else {
                Resizer resizer2 = resizer = this.myHorizontalSplitter.getFirstComponent() == cmp ? new Resizer.Splitter.FirstComponent(this.myHorizontalSplitter) : new Resizer.Splitter.LastComponent(this.myHorizontalSplitter);
            }
        }
        if (wnd.getType() == ToolWindowType.SLIDING) {
            for (cmp = wnd.getComponent(); cmp != null && cmp.getParent() != this.myLayeredPane; cmp = cmp.getParent()) {
            }
            if (cmp != null) {
                if (wnd.getAnchor() == ToolWindowAnchor.TOP) {
                    resizer = new Resizer.LayeredPane.Top(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.BOTTOM) {
                    resizer = new Resizer.LayeredPane.Bottom(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.LEFT) {
                    resizer = new Resizer.LayeredPane.Left(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.RIGHT) {
                    resizer = new Resizer.LayeredPane.Right(cmp);
                }
            }
        }
        if (resizer == null || cmp == null) {
            return;
        }
        int currentValue = wnd.getAnchor().isHorizontal() ? ((Component)cmp).getHeight() : ((Component)cmp).getWidth();
        int actualSize = currentValue + value;
        int minValue = wnd.getAnchor().isHorizontal() ? ((ToolWindowEx)wnd).getDecorator().getTitlePanel().getPreferredSize().height : 16 + this.myHorizontalSplitter.getDividerWidth();
        int n = maxValue = wnd.getAnchor().isHorizontal() ? this.myLayeredPane.getHeight() : this.myLayeredPane.getWidth();
        if (actualSize < minValue) {
            actualSize = minValue;
        }
        if (actualSize > maxValue) {
            actualSize = maxValue;
        }
        resizer.setSize(actualSize);
    }

    static int getHorizontalInsetX() {
        return 19;
    }

    private final class MyLayeredPane
    extends JLayeredPane {
        private SoftReference myBottomImageRef = new SoftReference(null);
        private SoftReference myTopImageRef = new SoftReference(null);

        public MyLayeredPane(JComponent splitter) {
            this.setOpaque(true);
            this.setBackground(Color.gray);
            this.add((Component)splitter, JLayeredPane.DEFAULT_LAYER);
            splitter.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.enableEvents(1L);
        }

        public final Image getBottomImage() {
            LOG.assertTrue(UISettings.getInstance().ANIMATE_WINDOWS);
            BufferedImage image = (BufferedImage)this.myBottomImageRef.get();
            if (image == null || image.getWidth(null) < this.getWidth() || image.getHeight(null) < this.getHeight()) {
                int width = Math.max(Math.max(1, this.getWidth()), ToolWindowsPane.this.myFrame.getWidth());
                int height = Math.max(Math.max(1, this.getHeight()), ToolWindowsPane.this.myFrame.getHeight());
                image = SystemInfo.isWindows || SystemInfo.isMac ? ToolWindowsPane.this.myFrame.getGraphicsConfiguration().createCompatibleImage(width, height) : new BufferedImage(width, height, 1);
                this.myBottomImageRef = new SoftReference((Object)image);
            }
            return image;
        }

        public final Image getTopImage() {
            LOG.assertTrue(UISettings.getInstance().ANIMATE_WINDOWS);
            BufferedImage image = (BufferedImage)this.myTopImageRef.get();
            if (image == null || image.getWidth(null) < this.getWidth() || image.getHeight(null) < this.getHeight()) {
                int width = Math.max(Math.max(1, this.getWidth()), ToolWindowsPane.this.myFrame.getWidth());
                int height = Math.max(Math.max(1, this.getHeight()), ToolWindowsPane.this.myFrame.getHeight());
                image = SystemInfo.isWindows || SystemInfo.isMac ? ToolWindowsPane.this.myFrame.getGraphicsConfiguration().createCompatibleImage(width, height) : new BufferedImage(width, height, 1);
                this.myTopImageRef = new SoftReference((Object)image);
            }
            return image;
        }

        @Override
        protected final void processComponentEvent(ComponentEvent e) {
            if (101 == e.getID()) {
                Component component;
                int i;
                int width = this.getWidth();
                int height = this.getHeight();
                if (width < 0 || height < 0) {
                    return;
                }
                Component[] components = this.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
                LOG.assertTrue(components.length <= 1);
                for (i = 0; i < components.length; ++i) {
                    component = components[i];
                    component.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
                components = this.getComponentsInLayer(JLayeredPane.PALETTE_LAYER);
                for (i = 0; i < components.length; ++i) {
                    WindowInfoImpl info;
                    component = components[i];
                    if (!(component instanceof InternalDecorator) || (info = (WindowInfoImpl)ToolWindowsPane.this.myDecorator2Info.get((Object)component)) == null) continue;
                    float weight = ToolWindowAnchor.TOP == info.getAnchor() || ToolWindowAnchor.BOTTOM == info.getAnchor() ? (float)component.getHeight() / (float)this.getHeight() : (float)component.getWidth() / (float)this.getWidth();
                    this.setBoundsInPaletteLayer(component, info.getAnchor(), weight);
                }
                this.validate();
                this.repaint();
            } else {
                super.processComponentEvent(e);
            }
        }

        public final void setBoundsInPaletteLayer(Component component, ToolWindowAnchor anchor, float weight) {
            if (weight < 0.0f) {
                weight = 0.33f;
            } else if (weight > 1.0f) {
                weight = 1.0f;
            }
            if (ToolWindowAnchor.TOP == anchor) {
                component.setBounds(0, 0, this.getWidth(), (int)((float)this.getHeight() * weight + 0.5f));
            } else if (ToolWindowAnchor.LEFT == anchor) {
                component.setBounds(0, 0, (int)((float)this.getWidth() * weight + 0.5f), this.getHeight());
            } else if (ToolWindowAnchor.BOTTOM == anchor) {
                int height = (int)((float)this.getHeight() * weight + 0.5f);
                component.setBounds(0, this.getHeight() - height, this.getWidth(), height);
            } else if (ToolWindowAnchor.RIGHT == anchor) {
                int width = (int)((float)this.getWidth() * weight + 0.5f);
                component.setBounds(this.getWidth() - width, 0, width, this.getHeight());
            } else {
                LOG.error("unknown anchor " + anchor);
            }
        }
    }

    private final class MyUISettingsListenerImpl
    implements UISettingsListener {
        private MyUISettingsListenerImpl() {
        }

        public final void uiSettingsChanged(UISettings source) {
            ToolWindowsPane.this.updateToolStripesVisibility();
        }
    }

    private final class UpdateButtonPositionCmd
    extends FinalizableCommand {
        private final String myId;

        private UpdateButtonPositionCmd(String id, Runnable finishCallBack) {
            super(finishCallBack);
            this.myId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WindowInfoImpl info = ToolWindowsPane.this.getButtonById(this.myId).getWindowInfo();
                ToolWindowAnchor anchor = info.getAnchor();
                if (ToolWindowAnchor.TOP == anchor) {
                    ToolWindowsPane.this.myTopStripe.revalidate();
                } else if (ToolWindowAnchor.LEFT == anchor) {
                    ToolWindowsPane.this.myLeftStripe.revalidate();
                } else if (ToolWindowAnchor.BOTTOM == anchor) {
                    ToolWindowsPane.this.myBottomStripe.revalidate();
                } else if (ToolWindowAnchor.RIGHT == anchor) {
                    ToolWindowsPane.this.myRightStripe.revalidate();
                } else {
                    LOG.error("unknown anchor: " + anchor);
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class SetEditorComponentCmd
    extends FinalizableCommand {
        private final JComponent myComponent;

        public SetEditorComponentCmd(JComponent component, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ToolWindowsPane.this.setDocumentComponent(this.myComponent);
                ToolWindowsPane.this.myLayeredPane.validate();
                ToolWindowsPane.this.myLayeredPane.repaint();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveSlidingComponentCmd
    extends FinalizableCommand {
        private final Component myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public RemoveSlidingComponentCmd(Component component, WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                UISettings uiSettings = UISettings.getInstance();
                if (!this.myDirtyMode && uiSettings.ANIMATE_WINDOWS && !UISettings.isRemoteDesktopConnected()) {
                    Rectangle bounds = this.myComponent.getBounds();
                    Image topImage = ToolWindowsPane.this.myLayeredPane.getTopImage();
                    Graphics topGraphics = topImage.getGraphics();
                    try {
                        this.myComponent.paint(topGraphics);
                    }
                    finally {
                        topGraphics.dispose();
                    }
                    Image bottomImage = ToolWindowsPane.this.myLayeredPane.getBottomImage();
                    Graphics bottomGraphics = bottomImage.getGraphics();
                    try {
                        ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                        bottomGraphics.clipRect(0, 0, bounds.width, bounds.height);
                        bottomGraphics.translate(-bounds.x, -bounds.y);
                        ToolWindowsPane.this.myLayeredPane.paint(bottomGraphics);
                    }
                    finally {
                        bottomGraphics.dispose();
                    }
                    Surface surface = new Surface(topImage, bottomImage, -1, this.myInfo.getAnchor(), uiSettings.ANIMATION_SPEED * 2);
                    ToolWindowsPane.this.myLayeredPane.add((Component)surface, JLayeredPane.PALETTE_LAYER);
                    surface.setBounds(bounds);
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                    surface.runMovement();
                    ToolWindowsPane.this.myLayeredPane.remove(surface);
                } else {
                    ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                }
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveSplitAndDockedComponentCmd
    extends FinalizableCommand {
        private final WindowInfoImpl myInfo;
        private final WindowInfoImpl mySideInfo;
        private final boolean myDirtyMode;

        private RemoveSplitAndDockedComponentCmd(WindowInfoImpl info, WindowInfoImpl sideInfo, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myInfo = info;
            this.mySideInfo = sideInfo;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Splitter splitter = (Splitter)ToolWindowsPane.this.getComponentAt(this.myInfo.getAnchor());
                if (this.myInfo.isSplit()) {
                    InternalDecorator component = (InternalDecorator)splitter.getFirstComponent();
                    ToolWindowsPane.this.setComponent(component, this.myInfo.getAnchor(), component.getWindowInfo().getWeight());
                } else {
                    InternalDecorator component = (InternalDecorator)splitter.getSecondComponent();
                    ToolWindowsPane.this.setComponent(component, this.myInfo.getAnchor(), component.getWindowInfo().getWeight());
                }
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveDockedComponentCmd
    extends FinalizableCommand {
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public RemoveDockedComponentCmd(WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                ToolWindowsPane.this.setComponent(null, this.myInfo.getAnchor(), 0.0f);
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveToolStripeButtonCmd
    extends FinalizableCommand {
        private final StripeButton myButton;
        private final WindowInfoImpl myInfo;

        public RemoveToolStripeButtonCmd(StripeButton button, WindowInfoImpl info, Runnable finishCallBack) {
            super(finishCallBack);
            this.myButton = button;
            this.myInfo = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                if (ToolWindowAnchor.TOP == anchor) {
                    ToolWindowsPane.this.myTopStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.LEFT == anchor) {
                    ToolWindowsPane.this.myLeftStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.BOTTOM == anchor) {
                    ToolWindowsPane.this.myBottomStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.RIGHT == anchor) {
                    ToolWindowsPane.this.myRightStripe.removeButton(this.myButton);
                } else {
                    LOG.error("unknown anchor: " + anchor);
                }
                ToolWindowsPane.this.validate();
                ToolWindowsPane.this.repaint();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class AddToolStripeButtonCmd
    extends FinalizableCommand {
        private final StripeButton myButton;
        private final WindowInfoImpl myInfo;
        private final Comparator myComparator;

        public AddToolStripeButtonCmd(StripeButton button, WindowInfoImpl info, Comparator comparator, Runnable finishCallBack) {
            super(finishCallBack);
            this.myButton = button;
            this.myInfo = info;
            this.myComparator = comparator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                if (ToolWindowAnchor.TOP == anchor) {
                    ToolWindowsPane.this.myTopStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.LEFT == anchor) {
                    ToolWindowsPane.this.myLeftStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.BOTTOM == anchor) {
                    ToolWindowsPane.this.myBottomStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.RIGHT == anchor) {
                    ToolWindowsPane.this.myRightStripe.addButton(this.myButton, this.myComparator);
                } else {
                    LOG.error("unknown anchor: " + anchor);
                }
                ToolWindowsPane.this.validate();
                ToolWindowsPane.this.repaint();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class AddSlidingComponentCmd
    extends FinalizableCommand {
        private final Component myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public AddSlidingComponentCmd(Component component, WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                UISettings uiSettings = UISettings.getInstance();
                if (!this.myDirtyMode && uiSettings.ANIMATE_WINDOWS && !UISettings.isRemoteDesktopConnected()) {
                    Rectangle bounds;
                    Image topImage = ToolWindowsPane.this.myLayeredPane.getTopImage();
                    Graphics topGraphics = topImage.getGraphics();
                    try {
                        ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                        ToolWindowsPane.this.myLayeredPane.moveToFront(this.myComponent);
                        ToolWindowsPane.this.myLayeredPane.setBoundsInPaletteLayer(this.myComponent, this.myInfo.getAnchor(), this.myInfo.getWeight());
                        bounds = this.myComponent.getBounds();
                        this.myComponent.paint(topGraphics);
                        ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                    }
                    finally {
                        topGraphics.dispose();
                    }
                    Image bottomImage = ToolWindowsPane.this.myLayeredPane.getBottomImage();
                    Graphics bottomGraphics = bottomImage.getGraphics();
                    try {
                        bottomGraphics.setClip(0, 0, bounds.width, bounds.height);
                        bottomGraphics.translate(-bounds.x, -bounds.y);
                        ToolWindowsPane.this.myLayeredPane.paint(bottomGraphics);
                    }
                    finally {
                        bottomGraphics.dispose();
                    }
                    Surface surface = new Surface(topImage, bottomImage, 1, this.myInfo.getAnchor(), uiSettings.ANIMATION_SPEED);
                    ToolWindowsPane.this.myLayeredPane.add((Component)surface, JLayeredPane.PALETTE_LAYER);
                    surface.setBounds(bounds);
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                    surface.runMovement();
                    ToolWindowsPane.this.myLayeredPane.remove(surface);
                    ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                } else {
                    ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                    ToolWindowsPane.this.myLayeredPane.setBoundsInPaletteLayer(this.myComponent, this.myInfo.getAnchor(), this.myInfo.getWeight());
                }
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class AddAndSplitDockedComponentCmd
    extends FinalizableCommand {
        private final JComponent myNewComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        private AddAndSplitDockedComponentCmd(JComponent newComponent, WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myNewComponent = newComponent;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                float newWeight;
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                Splitter splitter = new Splitter(!this.myInfo.getAnchor().isHorizontal());
                InternalDecorator oldComponent = (InternalDecorator)ToolWindowsPane.this.getComponentAt(this.myInfo.getAnchor());
                if (this.myInfo.isSplit()) {
                    splitter.setFirstComponent((JComponent)oldComponent);
                    splitter.setSecondComponent(this.myNewComponent);
                    splitter.setProportion(this.normalizeWeigh(oldComponent.getWindowInfo().getSideWeight()));
                    newWeight = this.normalizeWeigh(oldComponent.getWindowInfo().getWeight());
                } else {
                    splitter.setFirstComponent(this.myNewComponent);
                    splitter.setSecondComponent((JComponent)oldComponent);
                    splitter.setProportion(this.normalizeWeigh(this.myInfo.getSideWeight()));
                    newWeight = this.normalizeWeigh(this.myInfo.getWeight());
                }
                ToolWindowsPane.this.setComponent((JComponent)splitter, anchor, newWeight);
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }

        private float normalizeWeigh(float weight) {
            float newWeight;
            float f = newWeight = weight <= 0.0f ? 0.33f : weight;
            if (newWeight >= 1.0f) {
                newWeight = 0.66999996f;
            }
            return newWeight;
        }
    }

    private final class AddDockedComponentCmd
    extends FinalizableCommand {
        private final JComponent myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public AddDockedComponentCmd(JComponent component, WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                float newWeight;
                float f = newWeight = this.myInfo.getWeight() <= 0.0f ? 0.33f : this.myInfo.getWeight();
                if (newWeight >= 1.0f) {
                    newWeight = 0.66999996f;
                }
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                ToolWindowsPane.this.setComponent(this.myComponent, anchor, newWeight);
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    static interface Resizer {
        public void setSize(int var1);

        public static abstract class LayeredPane
        implements Resizer {
            Component myComponent;

            protected LayeredPane(Component component) {
                this.myComponent = component;
            }

            @Override
            public final void setSize(int size) {
                this._setSize(size);
                if (this.myComponent.getParent() instanceof JComponent) {
                    JComponent parent = (JComponent)this.myComponent;
                    parent.revalidate();
                    parent.repaint();
                }
            }

            abstract void _setSize(int var1);

            static class Bottom
            extends LayeredPane {
                Bottom(Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds = this.myComponent.getBounds();
                    int delta = size - bounds.height;
                    bounds.y -= delta;
                    bounds.height += delta;
                    this.myComponent.setBounds(bounds);
                }
            }

            static class Top
            extends LayeredPane {
                Top(Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(this.myComponent.getWidth(), size);
                }
            }

            static class Right
            extends LayeredPane {
                Right(Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds = this.myComponent.getBounds();
                    int delta = size - bounds.width;
                    bounds.x -= delta;
                    bounds.width += delta;
                    this.myComponent.setBounds(bounds);
                }
            }

            static class Left
            extends LayeredPane {
                Left(Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(size, this.myComponent.getHeight());
                }
            }
        }

        public static abstract class Splitter
        implements Resizer {
            ThreeComponentsSplitter mySplitter;

            Splitter(ThreeComponentsSplitter splitter) {
                this.mySplitter = splitter;
            }

            static class LastComponent
            extends Splitter {
                LastComponent(ThreeComponentsSplitter splitter) {
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setLastSize(size);
                }
            }

            static class FirstComponent
            extends Splitter {
                FirstComponent(ThreeComponentsSplitter splitter) {
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setFirstSize(size);
                }
            }
        }
    }
}

