/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.BaseButtonBehavior;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.border.EmptyBorder;

class ContentTabLabel
extends BaseLabel {
    Content myContent;
    private final BaseButtonBehavior myBehavior;
    private TabContentLayout myLayout;

    public ContentTabLabel(Content content, TabContentLayout layout) {
        super(layout.myUi, true);
        this.myLayout = layout;
        this.myContent = content;
        this.update();
        this.myBehavior = new BaseButtonBehavior(this){

            protected void execute(MouseEvent e) {
                ContentManager mgr = ContentTabLabel.this.myUi.myWindow.getContentManager();
                if (mgr.getIndexOfContent(ContentTabLabel.this.myContent) >= 0) {
                    mgr.setSelectedContent(ContentTabLabel.this.myContent, true);
                }
            }
        };
    }

    public void update() {
        if (!this.myLayout.isToDrawTabs()) {
            this.setHorizontalAlignment(2);
            this.setBorder(null);
        } else {
            this.setHorizontalAlignment(0);
            this.setBorder(new EmptyBorder(0, 8, 0, 8));
        }
        this.updateTextAndIcon(this.myContent, this.isSelected());
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isSelected() && this.myLayout.isToDrawTabs()) {
            g.translate(0, 2);
        }
        super.paintComponent(g);
        if (!this.isSelected() && this.myLayout.isToDrawTabs()) {
            g.translate(0, -2);
        }
    }

    public boolean isSelected() {
        return this.myUi.myWindow.getContentManager().isSelected(this.myContent);
    }

    @Override
    public Content getContent() {
        return this.myContent;
    }
}

