/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BackwardDependenciesBuilder
extends DependenciesBuilder {
    private final AnalysisScope[] myForwardScopes = this.getScope().getNarrowedComplementaryScope(this.getProject());

    public BackwardDependenciesBuilder(Project project, AnalysisScope scope) {
        this(project, scope, null);
    }

    public BackwardDependenciesBuilder(Project project, AnalysisScope scope, AnalysisScope scopeOfInterest) {
        super(project, scope, scopeOfInterest);
        int totalCount = 0;
        for (AnalysisScope forwardScope : this.myForwardScopes) {
            totalCount += forwardScope.getFileCount();
        }
        this.myFileCount = totalCount;
        this.myTotalFileCount = totalCount + scope.getFileCount();
    }

    @Override
    public String getRootNodeNameInUsageView() {
        return AnalysisScopeBundle.message((String)"backward.dependencies.usage.view.root.node.text", (Object[])new Object[0]);
    }

    @Override
    public String getInitialUsagesPosition() {
        return AnalysisScopeBundle.message((String)"backward.dependencies.usage.view.initial.text", (Object[])new Object[0]);
    }

    @Override
    public boolean isBackward() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze() {
        final DependenciesBuilder[] builders = new DependenciesBuilder[this.myForwardScopes.length];
        int totalCount = 0;
        for (int i = 0; i < this.myForwardScopes.length; ++i) {
            AnalysisScope scope = this.myForwardScopes[i];
            builders[i] = new ForwardDependenciesBuilder(this.getProject(), scope, this.getScopeOfInterest());
            builders[i].setInitialFileCount(totalCount);
            builders[i].setTotalFileCount(this.myTotalFileCount);
            builders[i].analyze();
            totalCount += scope.getFileCount();
            BackwardDependenciesBuilder.subtractScope(builders[i], this.getScope());
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        psiManager.startBatchFilesProcessingMode();
        try {
            this.getScope().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitFile(PsiFile file) {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    if (indicator != null) {
                        int fileCount;
                        if (indicator.isCanceled()) {
                            throw new ProcessCanceledException();
                        }
                        indicator.setText(AnalysisScopeBundle.message((String)"package.dependencies.progress.text", (Object[])new Object[0]));
                        VirtualFile virtualFile = file.getVirtualFile();
                        if (virtualFile != null) {
                            indicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)BackwardDependenciesBuilder.this.getProject()));
                        }
                        if ((fileCount = BackwardDependenciesBuilder.this.getScope().getFileCount()) > 0) {
                            indicator.setFraction((double)(++BackwardDependenciesBuilder.this.myFileCount) / (double)BackwardDependenciesBuilder.this.myTotalFileCount);
                        }
                    }
                    for (DependenciesBuilder builder : builders) {
                        Map<PsiFile, Set<PsiFile>> dependencies = builder.getDependencies();
                        for (PsiFile psiFile : dependencies.keySet()) {
                            if (!dependencies.get(psiFile).contains(file)) continue;
                            Set<PsiFile> fileDeps = BackwardDependenciesBuilder.this.getDependencies().get(file);
                            if (fileDeps == null) {
                                fileDeps = new HashSet<PsiFile>();
                                BackwardDependenciesBuilder.this.getDependencies().put(file, fileDeps);
                            }
                            fileDeps.add(psiFile);
                        }
                    }
                    psiManager.dropResolveCaches();
                }
            });
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private static void subtractScope(DependenciesBuilder builders, AnalysisScope scope) {
        Map<PsiFile, Set<PsiFile>> dependencies = builders.getDependencies();
        HashSet<PsiFile> excluded = new HashSet<PsiFile>();
        for (PsiFile psiFile : dependencies.keySet()) {
            if (!scope.contains((PsiElement)psiFile)) continue;
            excluded.add(psiFile);
        }
        for (PsiFile psiFile : excluded) {
            dependencies.remove(psiFile);
        }
    }
}

