/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.util.ArrayList;
import java.util.Collection;

public class PlatformProjectViewStructureProvider
implements TreeStructureProvider,
DumbAware {
    private final Project myProject;

    public PlatformProjectViewStructureProvider(Project project) {
        this.myProject = project;
    }

    public Collection<AbstractTreeNode> modify(AbstractTreeNode parent, Collection<AbstractTreeNode> children, ViewSettings settings) {
        VirtualFile vFile;
        if (parent instanceof ProjectViewProjectNode) {
            for (AbstractTreeNode child : children) {
                if (!(child instanceof ProjectViewModuleNode)) continue;
                return child.getChildren();
            }
        } else if (parent instanceof PsiDirectoryNode && (vFile = ((PsiDirectoryNode)parent).getVirtualFile()) != null && vFile.equals(this.myProject.getBaseDir())) {
            Collection<AbstractTreeNode> moduleChildren = ((PsiDirectoryNode)parent).getChildren();
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (AbstractTreeNode moduleChild : moduleChildren) {
                PsiDirectory value;
                if (moduleChild instanceof PsiDirectoryNode && (value = (PsiDirectory)((PsiDirectoryNode)moduleChild).getValue()).getName().equals(".idea")) continue;
                result.add(moduleChild);
            }
            return result;
        }
        return children;
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }
}

