/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl.events;

import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.XmlChangeVisitor;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.events.XmlDocumentChanged;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;

public class XmlDocumentChangedImpl
implements XmlDocumentChanged {
    private final XmlDocument myDocument;

    public XmlDocumentChangedImpl(@NotNull XmlDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/xml/impl/events/XmlDocumentChangedImpl.<init> must not be null");
        }
        this.myDocument = document;
    }

    public XmlDocument getDocument() {
        return this.myDocument;
    }

    public static PomModelEvent createXmlDocumentChanged(PomModel source, XmlDocument document) {
        PomModelEvent event = new PomModelEvent(source);
        XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(source, (XmlFile)document.getParent());
        xmlAspectChangeSet.add((XmlChange)new XmlDocumentChangedImpl(document));
        event.registerChangeSet(source.getModelAspect(XmlAspect.class), (PomChangeSet)xmlAspectChangeSet);
        return event;
    }

    public String toString() {
        return "Xml document changed";
    }

    public void accept(XmlChangeVisitor visitor) {
        visitor.visitDocumentChanged((XmlDocumentChanged)this);
    }
}

