/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

public class ExpectedTypesGetter
implements ContextGetter {
    @NotNull
    public PsiType[] get(PsiElement context, CompletionContext completionContext) {
        PsiType[] psiTypeArray = ExpectedTypesGetter.getExpectedTypes(context, false);
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/filters/getters/ExpectedTypesGetter.get must not return null");
        }
        return psiTypeArray;
    }

    public static PsiType[] getExpectedTypes(PsiElement context, boolean defaultTypes) {
        ExpectedTypesProvider typesProvider = ExpectedTypesProvider.getInstance(context.getProject());
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)context, PsiExpression.class, (boolean)true);
        if (expression == null) {
            return PsiType.EMPTY_ARRAY;
        }
        ExpectedTypeInfo[] infos = typesProvider.getExpectedTypes(expression, true);
        THashSet result = new THashSet(infos.length);
        for (ExpectedTypeInfo info : infos) {
            PsiType type = info.getType();
            PsiType defaultType = info.getDefaultType();
            if (!defaultTypes && !defaultType.equals(type)) {
                result.add(type);
            }
            result.add(defaultType);
        }
        return result.toArray(new PsiType[result.size()]);
    }
}

