/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileFactoryImpl
extends PsiFileFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiFileFactoryImpl");
    private final PsiManager myManager;

    public PsiFileFactoryImpl(PsiManager manager) {
        this.myManager = manager;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text, long modificationStamp, boolean bl) {
        void physical;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        PsiFile psiFile = this.createFileFromText(name, fileType, text, modificationStamp, (boolean)physical, true);
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
        }
        return psiFile;
    }

    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        return this.createFileFromText(name, language, text, true, true);
    }

    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text, boolean physical, boolean markAsCopy) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        return this.trySetupPsiForFile(new LightVirtualFile(name, language, text), language, physical, markAsCopy);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text, long modificationStamp, boolean physical, boolean bl) {
        PsiPlainTextFileImpl psiPlainTextFileImpl;
        void markAsCopy;
        Language language;
        PsiFile file;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, fileType, text, modificationStamp);
        if (fileType instanceof LanguageFileType && (file = this.trySetupPsiForFile(virtualFile, language = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), (VirtualFile)virtualFile, this.myManager.getProject()), physical, (boolean)markAsCopy)) != null) {
            psiPlainTextFileImpl = file;
            if (psiPlainTextFileImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
            return psiPlainTextFileImpl;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated(plainTextFile.getNode(), true);
        }
        if ((psiPlainTextFileImpl = plainTextFile) != null) return psiPlainTextFileImpl;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
    }

    @Nullable
    public PsiFile trySetupPsiForFile(LightVirtualFile virtualFile, Language language, boolean physical, boolean markAsCopy) {
        PsiFile psiFile;
        ParserDefinition parserDefinition;
        FileViewProvider viewProvider;
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory != null ? factory.createFileViewProvider((VirtualFile)virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language = viewProvider.getBaseLanguage())) != null && (psiFile = viewProvider.getPsi(language)) != null) {
            if (markAsCopy) {
                TreeElement node = (TreeElement)psiFile.getNode();
                assert (node != null);
                node.acceptTree(new GeneratedMarkerVisitor());
            }
            return psiFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, Language language, @NotNull Language targetLanguage, @NotNull CharSequence text, long modificationStamp, boolean physical, boolean bl) {
        PsiFile psiFile;
        void markAsCopy;
        PsiFile psiFile2;
        FileViewProvider viewProvider;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (targetLanguage == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, fileType, text, modificationStamp);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory != null ? factory.createFileViewProvider((VirtualFile)virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        }
        if (parserDefinition != null && (psiFile2 = viewProvider.getPsi(targetLanguage)) != null) {
            if (markAsCopy != false) {
                TreeElement node = (TreeElement)psiFile2.getNode();
                assert (node != null);
                node.acceptTree(new GeneratedMarkerVisitor());
            }
            if ((psiFile = psiFile2) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
            return psiFile;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated(plainTextFile.getNode(), true);
        }
        if ((psiFile = plainTextFile) != null) return psiFile;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        PsiFile psiFile = this.createFileFromText(name, fileType, text, LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
        }
        return psiFile;
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull String text) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType type = fileTypeManager.getFileTypeByFileName(name);
        if (type.isBinary()) {
            throw new RuntimeException("Cannot create binary files from text: name " + name + ", file type " + type);
        }
        PsiFile psiFile = this.createFileFromText(name, type, (CharSequence)text);
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
        }
        return psiFile;
    }

    public PsiFile createFileFromText(FileType fileType, String fileName, CharSequence chars, int startOffset, int endOffset) {
        LOG.assertTrue(!fileType.isBinary());
        Object text = startOffset == 0 && endOffset == chars.length() ? chars : new CharSequenceSubSequence(chars, startOffset, endOffset);
        return this.createFileFromText(fileName, fileType, (CharSequence)text);
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull CharSequence chars, @NotNull PsiFile original) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (original == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        PsiFile file = this.createFileFromText(original.getName(), original.getLanguage(), chars, false, true);
        if (file != null) {
            file.putUserData(ORIGINAL_FILE, (Object)original);
        }
        return file;
    }
}

