/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanProperty {
    public static final Icon ICON = IconLoader.getIcon((String)"/nodes/property.png");
    private final PsiMethod myMethod;

    protected BeanProperty(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/beanProperties/BeanProperty.<init> must not be null");
        }
        this.myMethod = method;
    }

    public PsiNamedElement getPsiElement() {
        return new BeanPropertyElement(this.myMethod, this.getName()){

            @Override
            public PsiType getPropertyType() {
                return BeanProperty.this.getPropertyType();
            }
        };
    }

    @NotNull
    public String getName() {
        String name = PropertyUtil.getPropertyName((PsiMethod)this.myMethod);
        String string = name == null ? "" : name;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/BeanProperty.getName must not return null");
        }
        return string;
    }

    @NotNull
    public PsiType getPropertyType() {
        PsiType type = PropertyUtil.getPropertyType((PsiMember)this.myMethod);
        assert (type != null);
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/BeanProperty.getPropertyType must not return null");
        }
        return psiType;
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/beanProperties/BeanProperty.getMethod must not return null");
        }
        return psiMethod;
    }

    @Nullable
    public PsiMethod getGetter() {
        if (PropertyUtil.isSimplePropertyGetter((PsiMethod)this.myMethod)) {
            return this.myMethod;
        }
        return PropertyUtil.findPropertyGetter((PsiClass)this.myMethod.getContainingClass(), (String)this.getName(), (boolean)false, (boolean)true);
    }

    @Nullable
    public PsiMethod getSetter() {
        if (PropertyUtil.isSimplePropertySetter((PsiMethod)this.myMethod)) {
            return this.myMethod;
        }
        return PropertyUtil.findPropertySetter((PsiClass)this.myMethod.getContainingClass(), (String)this.getName(), (boolean)false, (boolean)true);
    }

    public void setName(String newName) throws IncorrectOperationException {
        PsiMethod setter = this.getSetter();
        PsiMethod getter = this.getGetter();
        if (getter != null) {
            String getterName = PropertyUtil.suggestGetterName((String)newName, (PsiType)getter.getReturnType());
            getter.setName(getterName);
        }
        if (setter != null) {
            String setterName = PropertyUtil.suggestSetterName((String)newName);
            setter.setName(setterName);
        }
    }

    @Nullable
    public Icon getIcon(int flags) {
        return ICON;
    }

    @Nullable
    public static BeanProperty createBeanProperty(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/beanProperties/BeanProperty.createBeanProperty must not be null");
        }
        return PropertyUtil.isSimplePropertyAccessor((PsiMethod)method) ? new BeanProperty(method) : null;
    }
}

