/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClsAnnotationValueImpl
extends ClsElementImpl
implements PsiAnnotation,
Navigatable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.impl.compiled.ClsAnnotationValueImpl");
    public static final ClsAnnotationImpl[] EMPTY_ARRAY = new ClsAnnotationImpl[0];
    private final ClsJavaCodeReferenceElementImpl myReferenceElement = this.createReference();
    private final ClsAnnotationParameterListImpl myParameterList = this.createParameterList();
    private final ClsElementImpl myParent;

    public ClsAnnotationValueImpl(ClsElementImpl parent) {
        this.myParent = parent;
    }

    protected abstract ClsAnnotationParameterListImpl createParameterList();

    protected abstract ClsJavaCodeReferenceElementImpl createReference();

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        buffer.append("@").append(this.myReferenceElement.getCanonicalText());
        this.myParameterList.appendMirrorText(indentLevel, buffer);
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsAnnotationValueImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiAnnotation mirror = (PsiAnnotation)SourceTreeToPsiMap.treeElementToPsi(element);
        ((ClsElementImpl)this.getParameterList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getParameterList()));
        ((ClsElementImpl)this.getNameReferenceElement()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getNameReferenceElement()));
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myReferenceElement, this.myParameterList};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationValueImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsAnnotationValueImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation((PsiAnnotation)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        ClsAnnotationParameterListImpl clsAnnotationParameterListImpl = this.myParameterList;
        if (clsAnnotationParameterListImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationValueImpl.getParameterList must not return null");
        }
        return clsAnnotationParameterListImpl;
    }

    @Nullable
    public String getQualifiedName() {
        if (this.myReferenceElement == null) {
            return null;
        }
        return this.myReferenceElement.getCanonicalText();
    }

    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        return this.myReferenceElement;
    }

    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, T value) {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public String getText() {
        StringBuffer buffer = new StringBuffer();
        this.appendMirrorText(0, buffer);
        return buffer.toString();
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase(this);
    }
}

