/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiJavaDirectoryImpl
extends PsiDirectoryImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.PsiJavaDirectoryImpl");

    public PsiJavaDirectoryImpl(PsiManagerImpl manager, VirtualFile file) {
        super(manager, file);
    }

    @Override
    public void checkCreateFile(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiJavaDirectoryImpl.checkCreateFile must not be null");
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType type = fileTypeManager.getFileTypeByFileName(name);
        if (type == StdFileTypes.CLASS) {
            throw new IncorrectOperationException("Cannot create class-file");
        }
        super.checkCreateFile(name);
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiJavaDirectoryImpl.add must not be null");
        }
        if (element instanceof PsiClass) {
            String name = ((PsiClass)element).getName();
            if (name != null) {
                PsiClass newClass = JavaDirectoryService.getInstance().createClass((PsiDirectory)this, name);
                return newClass.replace(element);
            }
            LOG.error("not implemented");
            return null;
        }
        return super.add(element);
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiJavaDirectoryImpl.checkAdd must not be null");
        }
        if (element instanceof PsiClass) {
            if (((PsiClass)element).getContainingClass() == null) {
                JavaDirectoryServiceImpl.checkCreateClassOrInterface(this, ((PsiClass)element).getName());
            } else {
                LOG.error("not implemented");
            }
        } else {
            super.checkAdd(element);
        }
    }

    @Override
    public void navigate(boolean requestFocus) {
        ProjectViewSelectInTarget.select(this.getProject(), (Object)this, "ProjectPane", null, this.getVirtualFile(), requestFocus);
    }
}

