/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsEnumConstantImpl;
import com.intellij.psi.impl.compiled.ClsFieldImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaFieldNameIndex;
import com.intellij.psi.impl.source.PsiEnumConstantImpl;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.impl.source.tree.java.EnumConstantElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFieldStubElementType
extends JavaStubElementType<PsiFieldStub, PsiField> {
    public JavaFieldStubElementType(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaFieldStubElementType.<init> must not be null");
        }
        super(id);
    }

    public PsiField createPsi(PsiFieldStub stub) {
        boolean compiled = this.isCompiled(stub);
        if (compiled) {
            return stub.isEnumConstant() ? new ClsEnumConstantImpl(stub) : new ClsFieldImpl(stub);
        }
        return stub.isEnumConstant() ? new PsiEnumConstantImpl(stub) : new PsiFieldImpl(stub);
    }

    @Override
    public PsiField createPsi(ASTNode node) {
        if (node instanceof EnumConstantElement) {
            return new PsiEnumConstantImpl(node);
        }
        return new PsiFieldImpl(node);
    }

    public PsiFieldStub createStub(PsiField psi, StubElement parentStub) {
        PsiExpression initializer = psi.getInitializer();
        TypeInfo type = TypeInfo.create(psi.getTypeNoResolve(), psi.getTypeElement());
        byte flags = PsiFieldStubImpl.packFlags(psi instanceof PsiEnumConstant, RecordUtil.isDeprecatedByDocComment((PsiElement)psi), RecordUtil.isDeprecatedByAnnotation((PsiElement)psi));
        return new PsiFieldStubImpl(parentStub, psi.getName(), type, JavaFieldStubElementType.encodeInitializer(initializer), flags);
    }

    @Nullable
    private static String encodeInitializer(PsiExpression initializer) {
        if (initializer == null) {
            return null;
        }
        if (initializer instanceof PsiNewExpression || initializer instanceof PsiMethodCallExpression) {
            return ";INITIALIZER_NOT_STORED;";
        }
        return initializer.getText();
    }

    public void serialize(PsiFieldStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getType(false));
        dataStream.writeName(stub.getInitializerText());
        dataStream.writeByte((int)((PsiFieldStubImpl)stub).getFlags());
    }

    public PsiFieldStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        TypeInfo type = TypeInfo.readTYPE(dataStream, parentStub);
        StringRef initializerText = dataStream.readName();
        byte flags = dataStream.readByte();
        return new PsiFieldStubImpl(parentStub, name, type, initializerText, flags);
    }

    public void indexStub(PsiFieldStub stub, IndexSink sink) {
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(JavaFieldNameIndex.KEY, (Object)name);
        }
    }

    public String getId(PsiFieldStub stub) {
        String name = stub.getName();
        if (name != null) {
            return name;
        }
        return super.getId((StubElement)stub);
    }
}

