/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import com.intellij.psi.impl.java.stubs.impl.PsiImportStatementStubImpl;
import com.intellij.psi.impl.source.PsiImportStatementImpl;
import com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import com.intellij.psi.impl.source.tree.java.ImportStaticStatementElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaImportStatementElementType
extends JavaStubElementType<PsiImportStatementStub, PsiImportStatementBase> {
    public JavaImportStatementElementType(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaImportStatementElementType.<init> must not be null");
        }
        super(id);
    }

    public PsiImportStatementBase createPsi(PsiImportStatementStub stub) {
        assert (!this.isCompiled(stub));
        if (stub.isStatic()) {
            return new PsiImportStaticStatementImpl(stub);
        }
        return new PsiImportStatementImpl(stub);
    }

    @Override
    public PsiImportStatementBase createPsi(ASTNode node) {
        if (node instanceof ImportStaticStatementElement) {
            return new PsiImportStaticStatementImpl(node);
        }
        return new PsiImportStatementImpl(node);
    }

    public PsiImportStatementStub createStub(PsiImportStatementBase psi, StubElement parentStub) {
        byte flags = PsiImportStatementStubImpl.packFlags(psi.isOnDemand(), psi instanceof PsiImportStaticStatement);
        PsiJavaCodeReferenceElement ref = psi.getImportReference();
        return new PsiImportStatementStubImpl(parentStub, ref != null ? ref.getCanonicalText() : null, flags);
    }

    public void serialize(PsiImportStatementStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeByte((int)((PsiImportStatementStubImpl)stub).getFlags());
        dataStream.writeName(stub.getImportReferenceText());
    }

    public PsiImportStatementStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        byte flags = dataStream.readByte();
        StringRef reftext = dataStream.readName();
        return new PsiImportStatementStubImpl(parentStub, reftext, flags);
    }

    public void indexStub(PsiImportStatementStub stub, IndexSink sink) {
    }
}

